/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.triassic.ischigualasto;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.NocturnalSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Exaeretodon
extends DinosaurEntity {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)PFBlocks.CLADOPHLEBIS.get()).m_5456_()});
    private static final EntityDataAccessor<Boolean> DIGGING_ROOTS = SynchedEntityData.m_135353_(Exaeretodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int maxHunger = 20;
    private int warningSoundTicks;

    public Exaeretodon(EntityType<? extends Exaeretodon> type, Level levelIn) {
        super(type, levelIn);
        super.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean isDiggingForRoots() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING_ROOTS);
    }

    private void setDiggingForRoots(boolean isDiggingForRoots) {
        this.f_19804_.m_135381_(DIGGING_ROOTS, (Object)isDiggingForRoots);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.CLADOPHLEBIS.get()).m_5456_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new SkittishFleeGoal(this, Player.class, 7.0f, 1.25, 1.25));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.EXAERETODON_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new NocturnalSleepGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(5, (Goal)new DiggingGoal(this));
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.EXAERETODON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.EXAERETODON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.EXAERETODON_DEATH.get();
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.EXAERETODON_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DIGGING_ROOTS, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("DiggingRoots", this.isDiggingForRoots());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDiggingForRoots(compound.m_128471_("DiggingRoots"));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item == ((Block)PFBlocks.MICHELILLOA.get()).m_5456_()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setDiggingForRoots(true);
            return InteractionResult.SUCCESS;
        }
        if (item instanceof PaleopediaItem && !stack.m_41783_().m_128425_("Pages", EnumPaleoPages.EXAERETODON.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.EXAERETODON.ordinal()), stack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.exaeretodon_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setProtective(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setTerritorial(true);
        } else if (temperment >= 95) {
            this.setSkittish(true);
        }
        this.setHerbivorous(true);
        this.setNocturnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Exaeretodon entity = new Exaeretodon((EntityType<? extends Exaeretodon>)((EntityType)PFEntities.EXAERETODON.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.EXAERETODON_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.EXAERETODON_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.EXAERETODON_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Exaeretodon.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Exaeretodon.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class DiggingGoal
    extends Goal {
        private static final ResourceLocation DIGGING_LOOT = new ResourceLocation("prehistoricfauna", "entities/exaeretodon_digging");
        private final Exaeretodon exaeretodon;
        private int diggingTimer;
        private int digTimer2;

        public DiggingGoal(Exaeretodon entity) {
            this.exaeretodon = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.digTimer2 > 0) {
                --this.digTimer2;
                return false;
            }
            BlockPos blockpos = this.exaeretodon.m_20183_();
            BlockState state = this.exaeretodon.m_9236_().m_8055_(blockpos);
            if (state.m_204336_(BlockTags.f_144274_) && this.exaeretodon.isDiggingForRoots()) {
                return true;
            }
            return this.exaeretodon.m_9236_().m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_144274_) && this.exaeretodon.isDiggingForRoots();
        }

        public void m_8056_() {
            this.diggingTimer = 40;
            this.digTimer2 = 6000;
            this.exaeretodon.m_9236_().m_7605_((Entity)this.exaeretodon, (byte)10);
            this.exaeretodon.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.diggingTimer = 0;
            this.exaeretodon.setDiggingForRoots(false);
        }

        public boolean m_8045_() {
            return this.diggingTimer > 0;
        }

        public void m_8037_() {
            if (this.digTimer2 > 0) {
                --this.digTimer2;
            }
            if (this.diggingTimer > 0) {
                --this.diggingTimer;
            }
            if (this.diggingTimer == 25) {
                BlockPos blockpos = this.exaeretodon.m_20183_();
                BlockPos blockpos1 = blockpos.m_7495_();
                if (this.exaeretodon.m_9236_().m_8055_(blockpos1).m_204336_(BlockTags.f_144274_)) {
                    BlockState state = this.exaeretodon.m_9236_().m_8055_(blockpos1);
                    this.exaeretodon.m_9236_().m_46796_(2001, blockpos1, Block.m_49956_((BlockState)state));
                    MinecraftServer server = this.exaeretodon.m_9236_().m_7654_();
                    if (server != null) {
                        ObjectArrayList items = server.m_278653_().m_278676_(DIGGING_LOOT).m_287195_(new LootParams.Builder((ServerLevel)this.exaeretodon.m_9236_()).m_287235_(LootContextParamSets.f_81410_));
                        Containers.m_19010_((Level)this.exaeretodon.m_9236_(), (BlockPos)blockpos, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])items.toArray(new ItemStack[0])));
                    }
                }
            }
        }
    }
}

