/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.jurassic.morrison;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.BurrowingDinosaur;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Eilenodon
extends BurrowingDinosaur {
    private static final EntityDataAccessor<Byte> EILENODON_FLAGS = SynchedEntityData.m_135353_(Eilenodon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)PFBlocks.HORSETAIL.get()).m_5456_()});
    private int maxHunger = 10;

    public Eilenodon(EntityType<? extends Eilenodon> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        ((BurrowingDinosaur)this).maxHunger = this.maxHunger;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.125f;
        }
        return 0.25f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.HORSETAIL.get()).m_5456_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EILENODON_FLAGS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sitting", this.isSitting());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSitting(compound.m_128471_("Sitting"));
    }

    private void setEilenodonFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.f_19804_.m_135381_(EILENODON_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(EILENODON_FLAGS) | p_213505_1_)));
        } else {
            this.f_19804_.m_135381_(EILENODON_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(EILENODON_FLAGS) & ~p_213505_1_)));
        }
    }

    private boolean getEilenodonFlag(int p_213507_1_) {
        return ((Byte)this.f_19804_.m_135370_(EILENODON_FLAGS) & p_213507_1_) != 0;
    }

    public boolean isSitting() {
        return this.getEilenodonFlag(1);
    }

    public void setSitting(boolean p_213466_1_) {
        this.setEilenodonFlag(1, p_213466_1_);
        this.setFallingAsleep();
    }

    public boolean func_213480_dY() {
        return this.getEilenodonFlag(16);
    }

    public void func_213461_s(boolean p_213461_1_) {
        this.setEilenodonFlag(16, p_213461_1_);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.EILENODON.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.EILENODON.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.eilenodon_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.EILENODON_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new SitAndLookGoal());
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 85) {
            this.setSkittish(true);
        } else {
            this.setPassive(true);
        }
        this.setHerbivorous(true);
        this.setNocturnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.EILENODON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.EILENODON_DEATH.get();
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(2.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Eilenodon entity = new Eilenodon((EntityType<? extends Eilenodon>)((EntityType)PFEntities.EILENODON.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.EILENODON_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.EILENODON_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.EILENODON_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class SitAndLookGoal
    extends BaseGoal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Eilenodon.this.m_21188_() == null && Eilenodon.this.m_217043_().m_188501_() < 0.02f && !Eilenodon.this.isAsleep() && Eilenodon.this.m_5448_() == null && Eilenodon.this.m_21573_().m_26571_() && !this.func_220814_h() && !Eilenodon.this.func_213480_dY() && !Eilenodon.this.m_6047_() && Eilenodon.this.m_9236_().m_46468_() <= 10L || Eilenodon.this.m_21188_() == null && Eilenodon.this.m_217043_().m_188501_() < 0.02f && !Eilenodon.this.m_5803_() && Eilenodon.this.m_5448_() == null && Eilenodon.this.m_21573_().m_26571_() && !this.func_220814_h() && !Eilenodon.this.func_213480_dY() && !Eilenodon.this.m_6047_() && Eilenodon.this.m_9236_().m_46468_() >= 1110L && Eilenodon.this.m_9236_().m_46468_() <= 1310L || Eilenodon.this.m_21188_() == null && Eilenodon.this.m_217043_().m_188501_() < 0.02f && !Eilenodon.this.m_5803_() && Eilenodon.this.m_5448_() == null && Eilenodon.this.m_21573_().m_26571_() && !this.func_220814_h() && !Eilenodon.this.func_213480_dY() && !Eilenodon.this.m_6047_() && Eilenodon.this.m_9236_().m_46468_() >= 2210L;
        }

        public boolean m_8045_() {
            return this.field_220822_f == 4;
        }

        public void m_8056_() {
            this.func_220817_j();
            this.field_220822_f = 2 + Eilenodon.this.m_217043_().m_188503_(3);
            Eilenodon.this.setSitting(true);
            Eilenodon.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Eilenodon.this.setSitting(false);
        }

        public void m_8037_() {
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            Eilenodon.this.m_21563_().m_24950_(Eilenodon.this.m_20185_() + this.field_220819_c, Eilenodon.this.m_20188_(), Eilenodon.this.m_20189_() + this.field_220820_d, (float)Eilenodon.this.m_8085_(), (float)Eilenodon.this.m_8132_());
        }

        private void func_220817_j() {
            double d0 = Math.PI * 2 * Eilenodon.this.m_217043_().m_188500_();
            this.field_220819_c = Math.cos(d0);
            this.field_220820_d = Math.sin(d0);
            this.field_220821_e = 80 + Eilenodon.this.m_217043_().m_188503_(20);
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final TargetingConditions field_220816_b;

        private BaseGoal() {
            this.field_220816_b = TargetingConditions.m_148352_().m_26883_(12.0).m_148355_().m_26888_((Predicate)new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = Eilenodon.this.m_20183_();
            return !Eilenodon.this.m_9236_().m_45527_(blockpos) && Eilenodon.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !Eilenodon.this.m_9236_().m_45971_(LivingEntity.class, this.field_220816_b, (LivingEntity)Eilenodon.this, Eilenodon.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof Eilenodon) {
                return false;
            }
            if (!(p_test_1_ instanceof Chicken || p_test_1_ instanceof Rabbit || p_test_1_ instanceof Monster)) {
                if (p_test_1_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_test_1_).m_21824_();
                }
                if (!(p_test_1_ instanceof Player) || !p_test_1_.m_5833_() && !((Player)p_test_1_).m_7500_()) {
                    return !p_test_1_.m_5803_() && !p_test_1_.m_20163_();
                }
                return false;
            }
            return true;
        }
    }
}

