/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.jurassic.kayenta;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Scelidosaurus
extends DinosaurEntity {
    private static final EntityDataAccessor<Boolean> BIPEDAL = SynchedEntityData.m_135353_(Scelidosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BIPEDAL_TICK = SynchedEntityData.m_135353_(Scelidosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int maxHunger = 38;
    private int warningSoundTicks;
    private float bipedalProgress = 0.0f;
    private float prevBipedalProgress = 0.0f;

    public Scelidosaurus(EntityType<? extends Scelidosaurus> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.4f;
        }
        return 0.8f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.CLATHROPTERIS.get()).m_5456_();
    }

    public boolean isBipedal() {
        return (Boolean)this.f_19804_.m_135370_(BIPEDAL);
    }

    private void setBipedal(boolean isBipedal) {
        this.f_19804_.m_135381_(BIPEDAL_TICK, (Object)15);
        this.f_19804_.m_135381_(BIPEDAL, (Object)isBipedal);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIPEDAL, (Object)false);
        this.f_19804_.m_135372_(BIPEDAL_TICK, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsBipedal", this.isBipedal());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBipedal(compound.m_128471_("IsBipedal"));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new BipedalAvoidEntityGoal(this, (PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SCELIDOSAURUS_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new CathemeralSleepGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.SCELIDOSAURUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.SCELIDOSAURUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.scelidosaurus_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setProtective(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setTerritorial(true);
        } else if (temperment >= 95) {
            this.setPassive(true);
        }
        this.setHerbivorous(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.SCELIDOSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.SCELIDOSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.SCELIDOSAURUS_DEATH.get();
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.SCELIDOSAURUS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        this.prevBipedalProgress = this.bipedalProgress;
        if ((Integer)this.f_19804_.m_135370_(BIPEDAL_TICK) > 0) {
            this.f_19804_.m_135381_(BIPEDAL_TICK, (Object)((Integer)this.f_19804_.m_135370_(BIPEDAL_TICK) - 1));
            if (this.bipedalProgress < 1.0f) {
                this.bipedalProgress = Math.min(this.bipedalProgress + 0.1f, 1.0f);
            }
        } else if (this.bipedalProgress > 0.0f) {
            this.bipedalProgress = Math.max(this.bipedalProgress - 0.2f, 0.0f);
        }
    }

    public float getBipedalProgress(float partialTick) {
        return this.prevBipedalProgress + (this.bipedalProgress - this.prevBipedalProgress) * partialTick;
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22285_, 4.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 15.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(7.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
        }
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Scelidosaurus entity = new Scelidosaurus((EntityType<? extends Scelidosaurus>)((EntityType)PFEntities.SCELIDOSAURUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(entity.m_20183_()), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.SCELIDOSAURUS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.SCELIDOSAURUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.SCELIDOSAURUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Scelidosaurus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Scelidosaurus.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    class BipedalAvoidEntityGoal
    extends AvoidEntityGoal {
        Scelidosaurus scelidosaurus;

        public BipedalAvoidEntityGoal(Scelidosaurus scelidosaurus, PathfinderMob entityIn, Class classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, Predicate<LivingEntity> predicate) {
            super(entityIn, classToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn, predicate);
            this.scelidosaurus = scelidosaurus;
        }

        public void m_8056_() {
            super.m_8056_();
            this.scelidosaurus.setBipedal(true);
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.scelidosaurus.isBipedal()) {
                this.scelidosaurus.setBipedal(true);
            }
        }

        public void m_8041_() {
            this.scelidosaurus.setBipedal(false);
            super.m_8041_();
        }
    }
}

