/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.henos;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFTags;

public class LandSentinel
extends Monster {
    private static final EntityDataAccessor<Integer> DIMENSION = SynchedEntityData.m_135353_(LandSentinel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> NON_TRIASSIC = p_289448_ -> !p_289448_.m_6095_().m_204039_(PFTags.TRIASSIC_ENTITIES);
    public static final Predicate<LivingEntity> NON_JURASSIC = p_289448_ -> !p_289448_.m_6095_().m_204039_(PFTags.JURASSIC_ENTITIES);
    public static final Predicate<LivingEntity> NON_CRETACEOUS = p_289448_ -> !p_289448_.m_6095_().m_204039_(PFTags.CRETACEOUS_ENTITIES);
    private Goal cretaceousTargetGoal;
    private Goal jurassicTargetGoal;
    private Goal triassicTargetGoal;

    public LandSentinel(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.m_274367_(1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DIMENSION, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Dimension", this.getDimensionInt());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDimensionInt(compound.m_128451_("Dimension"));
        if (this.m_9236_() instanceof ServerLevel) {
            this.setTargetGoals();
        }
    }

    public int getDimensionInt() {
        return (Integer)this.f_19804_.m_135370_(DIMENSION);
    }

    private void setDimensionInt(int dimensionInt) {
        this.f_19804_.m_135381_(DIMENSION, (Object)dimensionInt);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_) || source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268526_) || source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268513_) || source.m_276093_(DamageTypes.f_268444_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268450_) || source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268669_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8099_() {
        this.cretaceousTargetGoal = new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, NON_CRETACEOUS);
        this.jurassicTargetGoal = new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, NON_JURASSIC);
        this.triassicTargetGoal = new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, NON_TRIASSIC);
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (worldIn.m_204166_(this.m_20097_()).m_203656_(PFTags.IS_CRETACEOUS)) {
            this.setDimensionInt(0);
        } else if (worldIn.m_204166_(this.m_20097_()).m_203656_(PFTags.IS_JURASSIC)) {
            this.setDimensionInt(1);
        } else {
            this.setDimensionInt(2);
        }
        if (worldIn instanceof ServerLevel) {
            this.setTargetGoals();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6040_() {
        return true;
    }

    private void setTargetGoals() {
        if (this.getDimensionInt() == 0) {
            this.f_21346_.m_25352_(0, this.cretaceousTargetGoal);
        }
        if (this.getDimensionInt() == 1) {
            this.f_21346_.m_25352_(0, this.jurassicTargetGoal);
        }
        if (this.getDimensionInt() == 2) {
            this.f_21346_.m_25352_(0, this.triassicTargetGoal);
        }
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22278_, 50.0);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor worldIn, BlockPos pos, RandomSource randomIn) {
        if (worldIn.m_45517_(LightLayer.SKY, pos) > randomIn.m_188503_(32)) {
            return false;
        }
        int i = worldIn.m_6018_().m_46470_() ? worldIn.m_46849_(pos, 10) : worldIn.m_46803_(pos);
        return i <= randomIn.m_188503_(8);
    }

    public static boolean canSpawn(EntityType<LandSentinel> batIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        if (pos.m_123342_() >= worldIn.m_5736_()) {
            return worldIn.m_46791_() != Difficulty.PEACEFUL && LandSentinel.isValidLightLevel(worldIn, pos, randomIn) && LandSentinel.m_217057_(batIn, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn) && worldIn.m_6018_().m_46462_() && randomIn.m_188501_() > 0.95f;
        }
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12450_, 0.15f, 1.0f);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.LAND_SENTINEL_SPAWN_EGG.get());
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)LandSentinel.this, 1.25, true);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 6.0f + attackTarget.m_20205_();
        }
    }
}

