/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.henos;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFParticles;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Henos
extends Animal {
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> USE_BEAM = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> USE_REGULAR_ATTACK = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGING_BEAM = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> USING_BEAM = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LASER_TARGET_ENTITY = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> LASER_X = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> LASER_Y = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> LASER_Z = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_SUMMONED = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MELEE_TICK = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LASER_TICK = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHIELD_LEVEL = SynchedEntityData.m_135353_(Henos.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    public boolean inWall;
    public float targetDistance;
    public float targetAngle;
    public float prevLaserX;
    public float prevLaserY;
    public float prevLaserZ;
    private float leftPunchProgress;
    private float prevLeftPunchProgress;
    private float rightPunchProgress;
    private float prevRightPunchProgress;
    private float laserProgress;
    private float prevLaserProgress;
    private boolean usingLeftHand;
    private int shieldCooldown = 0;

    public Henos(EntityType<? extends Henos> type, Level level) {
        super(type, level);
        super.m_274367_(1.0f);
    }

    protected boolean m_6129_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22278_, 50.0);
    }

    public boolean isSummoned() {
        return (Boolean)this.f_19804_.m_135370_(IS_SUMMONED);
    }

    public void setSummoned(boolean isSummoned) {
        this.f_19804_.m_135381_(IS_SUMMONED, (Object)isSummoned);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)PFSounds.HENOS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.HENOS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.HENOS_DEATH.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new BeamAttackAI(this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal(this, 1.0, true));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_6040_() {
        return true;
    }

    private boolean checkWalls(AABB p_31140_) {
        int i = Mth.m_14107_((double)p_31140_.f_82288_);
        int j = Mth.m_14107_((double)p_31140_.f_82289_);
        int k = Mth.m_14107_((double)p_31140_.f_82290_);
        int l = Mth.m_14107_((double)p_31140_.f_82291_);
        int i1 = Mth.m_14107_((double)p_31140_.f_82292_);
        int j1 = Mth.m_14107_((double)p_31140_.f_82293_);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_13076_)) continue;
                    if (ForgeHooks.canEntityDestroy((Level)this.m_9236_(), (BlockPos)blockpos, (LivingEntity)this) && !blockstate.m_204336_(BlockTags.f_13069_) && !blockstate.m_204336_(PFTags.HENOSTONE)) {
                        flag1 = this.m_9236_().m_7471_(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.f_19796_.m_188503_(l - i + 1), j + this.f_19796_.m_188503_(i1 - j + 1), k + this.f_19796_.m_188503_(j1 - k + 1));
            this.m_9236_().m_46796_(2008, blockpos1, 0);
        }
        return flag;
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            this.inWall = this.checkWalls(this.m_20191_());
        }
        super.m_8107_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevRightPunchProgress = this.rightPunchProgress;
        this.prevLeftPunchProgress = this.leftPunchProgress;
        this.prevLaserX = this.getLaserX();
        this.prevLaserY = this.getLaserY();
        this.prevLaserZ = this.getLaserZ();
        this.prevLaserProgress = this.laserProgress;
        if (this.laserProgress < 1.0f && this.isUsingBeamAttack() && !this.isUsingRegularAttack()) {
            this.laserProgress += 0.1f;
        }
        if (this.laserProgress > 0.0f && (!this.isUsingBeamAttack() || this.isUsingRegularAttack())) {
            this.laserProgress -= 0.1f;
        }
        if (this.m_5448_() != null) {
            this.targetDistance = this.m_20270_((Entity)this.m_5448_()) - this.m_5448_().m_20205_() / 2.0f;
            this.targetAngle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)this.m_5448_());
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || this.m_5448_().m_21223_() <= 0.0f)) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_() && !this.m_21525_()) {
            if (this.isActive()) {
                if (this.m_5448_() == null) {
                    this.setActive(false);
                }
            } else if (this.m_5448_() != null && this.targetDistance <= 30.0f || this.m_5448_() != null && this.targetDistance <= 30.0f) {
                this.setActive(true);
            }
            if (this.getHealthRatio() < 0.5f && this.shieldCooldown == 0 && !this.hasHealingShield()) {
                this.shieldCooldown = 300 + this.f_19796_.m_188503_(300);
                this.setHealingShield(3);
            }
        }
        if (!this.isActive()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            this.f_19857_ = this.f_19859_;
            if (this.m_21223_() < this.m_21233_()) {
                this.setHealingShield(1);
            }
            if (this.m_21223_() == this.m_21233_()) {
                this.setHealingShield(0);
            }
        }
        this.f_20883_ = this.f_20885_;
        if (!this.m_9236_().m_5776_() && this.hasHealingShield()) {
            if (this.m_5448_() == null) {
                this.m_5634_(0.3f);
            } else {
                double dist = this.m_20270_((Entity)this.m_5448_());
                if (dist > 16.0) {
                    this.m_5634_(3.0f);
                } else {
                    this.m_5634_((float)Mth.m_14008_((double)(dist * (double)0.085f), (double)0.2f, (double)3.0));
                }
            }
        }
        if ((Integer)this.f_19804_.m_135370_(MELEE_TICK) > 0 && this.isUsingRegularAttack()) {
            if (Math.max(this.rightPunchProgress, this.leftPunchProgress) == 5.0f && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < this.m_5448_().m_20205_() + this.m_20205_() + 2.0f) {
                this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f);
                if (this.m_5448_().m_21254_()) {
                    ((Player)this.m_5448_()).m_36335_().m_41524_(Items.f_42740_, 100);
                    ((Player)this.m_5448_()).m_5810_();
                    this.m_9236_().m_7605_((Entity)((Player)this.m_5448_()), (byte)30);
                }
            }
            this.f_19804_.m_135381_(MELEE_TICK, (Object)((Integer)this.f_19804_.m_135370_(MELEE_TICK) - 1));
            if ((Integer)this.f_19804_.m_135370_(MELEE_TICK) == 0) {
                boolean bl = this.usingLeftHand = !this.usingLeftHand;
            }
            if (!this.usingLeftHand && this.rightPunchProgress < 5.0f) {
                this.rightPunchProgress += 2.5f;
            }
            if (this.usingLeftHand && this.leftPunchProgress < 5.0f) {
                this.leftPunchProgress += 2.5f;
            }
        } else {
            if (this.leftPunchProgress > 0.0f) {
                this.leftPunchProgress -= Math.min(0.5f, this.leftPunchProgress);
            }
            if (this.rightPunchProgress > 0.0f) {
                this.rightPunchProgress -= Math.min(0.5f, this.rightPunchProgress);
            }
        }
        if (this.usingLeftHand) {
            if (this.rightPunchProgress > 0.0f) {
                this.rightPunchProgress -= 1.0f;
            }
        } else if (this.leftPunchProgress > 0.0f) {
            this.leftPunchProgress -= 1.0f;
        }
        if (this.isUsingBeamAttack()) {
            double d0 = (double)this.getLaserX() - this.m_20185_();
            double d1 = (double)this.getLaserY() - this.m_20227_(1.0);
            double d2 = (double)this.getLaserZ() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d0 /= d3;
            d1 /= d3;
            d2 /= d3;
            double d4 = this.f_19796_.m_188500_();
            while (d4 < d3) {
                this.m_9236_().m_7106_((ParticleOptions)PFParticles.BOSS_LASER.get(), this.m_20185_() + d0 * (d4 += 3.0 - this.f_19796_.m_188500_() * 2.5), this.m_20188_() + d1 * d4, this.m_20189_() + d2 * d4, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
            }
        }
        if (this.hasHealingShield() && this.m_9236_().m_5776_()) {
            for (int i = 0; i < 2 + this.f_19796_.m_188503_(2); ++i) {
                this.m_9236_().m_7106_((ParticleOptions)PFParticles.BOSS_HEAL.get(), this.m_20208_(2.0), this.m_20186_(), this.m_20262_(2.0), this.m_20185_(), this.m_20227_(0.75), this.m_20189_());
            }
        }
        if (this.getLaserTick() < 0) {
            this.setLaserTick(this.getLaserTick() + 1);
        }
        if (this.shieldCooldown > 0 && !this.hasHealingShield()) {
            --this.shieldCooldown;
        }
    }

    public boolean m_6094_() {
        return this.isActive();
    }

    public boolean m_8023_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ACTIVE, (Object)false);
        this.m_20088_().m_135372_(USE_BEAM, (Object)false);
        this.m_20088_().m_135372_(USE_REGULAR_ATTACK, (Object)false);
        this.m_20088_().m_135372_(CHARGING_BEAM, (Object)false);
        this.m_20088_().m_135372_(USING_BEAM, (Object)false);
        this.m_20088_().m_135372_(LASER_X, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(LASER_Y, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(LASER_Z, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(MELEE_TICK, (Object)0);
        this.m_20088_().m_135372_(LASER_TICK, (Object)0);
        this.m_20088_().m_135372_(LASER_TARGET_ENTITY, (Object)-1);
        this.m_20088_().m_135372_(IS_SUMMONED, (Object)false);
        this.m_20088_().m_135372_(SHIELD_LEVEL, (Object)0);
    }

    public boolean isUsingBeamAttack() {
        return (Boolean)this.m_20088_().m_135370_(USE_BEAM);
    }

    public void useBeam(boolean isUsingBeam) {
        this.m_20088_().m_135381_(USE_BEAM, (Object)isUsingBeam);
    }

    public boolean hasHealingShield() {
        return this.getShieldLevel() > 0;
    }

    public int getShieldLevel() {
        return (Integer)this.m_20088_().m_135370_(SHIELD_LEVEL);
    }

    public void setHealingShield(int shield) {
        this.m_20088_().m_135381_(SHIELD_LEVEL, (Object)shield);
    }

    public boolean isUsingRegularAttack() {
        return (Boolean)this.m_20088_().m_135370_(USE_REGULAR_ATTACK);
    }

    public void useRegularAttack(boolean isUsingRegularAttack) {
        this.m_20088_().m_135381_(USE_REGULAR_ATTACK, (Object)isUsingRegularAttack);
    }

    public boolean isActive() {
        return (Boolean)this.m_20088_().m_135370_(ACTIVE);
    }

    public void setActive(boolean isActive) {
        this.m_20088_().m_135381_(ACTIVE, (Object)isActive);
    }

    public float getHealthRatio() {
        return this.m_21223_() / this.m_21233_();
    }

    public float getLaserX() {
        return ((Float)this.f_19804_.m_135370_(LASER_X)).floatValue();
    }

    public void setLaserX(float laser) {
        this.f_19804_.m_135381_(LASER_X, (Object)Float.valueOf(laser));
    }

    public float getLaserY() {
        return ((Float)this.f_19804_.m_135370_(LASER_Y)).floatValue();
    }

    public void setLaserY(float laser) {
        this.f_19804_.m_135381_(LASER_Y, (Object)Float.valueOf(laser));
    }

    public float getLaserZ() {
        return ((Float)this.f_19804_.m_135370_(LASER_Z)).floatValue();
    }

    public void setLaserZ(float laser) {
        this.f_19804_.m_135381_(LASER_Z, (Object)Float.valueOf(laser));
    }

    public boolean isUsingBeam() {
        return (Boolean)this.f_19804_.m_135370_(USING_BEAM);
    }

    private void setUsingBeam(boolean isUsingBeam) {
        this.f_19804_.m_135381_(USING_BEAM, (Object)isUsingBeam);
    }

    public boolean isChargingBeam() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING_BEAM);
    }

    private void setChargingBeam(boolean isChargingBeam) {
        this.f_19804_.m_135381_(CHARGING_BEAM, (Object)isChargingBeam);
    }

    public float getMeleeProgress(boolean left, float partialTick) {
        if (left) {
            return this.prevLeftPunchProgress + (this.leftPunchProgress - this.prevLeftPunchProgress) * partialTick;
        }
        return this.prevRightPunchProgress + (this.rightPunchProgress - this.prevRightPunchProgress) * partialTick;
    }

    public boolean hasLaserTarget() {
        return (Integer)this.f_19804_.m_135370_(LASER_TARGET_ENTITY) != -1;
    }

    private void setLaserEntity(@Nullable Entity entity) {
        this.f_19804_.m_135381_(LASER_TARGET_ENTITY, (Object)(entity == null ? -1 : entity.m_19879_()));
    }

    @Nullable
    public LivingEntity getLaserTarget() {
        if (!this.hasLaserTarget()) {
            return this.m_5448_();
        }
        return (LivingEntity)this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(LASER_TARGET_ENTITY)).intValue());
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    public int getLaserTick() {
        return (Integer)this.m_20088_().m_135370_(LASER_TICK);
    }

    public void setLaserTick(int tick) {
        this.m_20088_().m_135381_(LASER_TICK, (Object)tick);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("active", this.isActive());
        compound.m_128379_("summoned", this.isSummoned());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setActive(compound.m_128471_("active"));
        this.setSummoned(compound.m_128471_("summoned"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public boolean m_7327_(Entity entityIn) {
        this.m_20088_().m_135381_(MELEE_TICK, (Object)10);
        return true;
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.3f;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.m_20189_() - first.m_20189_(), second.m_20185_() - first.m_20185_()) * 57.29577951308232 + 90.0;
    }

    public Vec3 getLaserTargetPos(float partialTicks) {
        float x = this.prevLaserX + (this.getLaserX() - this.prevLaserX) * partialTicks;
        float y = this.prevLaserY + (this.getLaserY() - this.prevLaserY) * partialTicks;
        float z = this.prevLaserZ + (this.getLaserZ() - this.prevLaserZ) * partialTicks;
        return new Vec3((double)x, (double)y, (double)z);
    }

    public float getLaserTargetProgress(float partialTicks) {
        return this.prevLaserProgress + (this.laserProgress - this.prevLaserProgress) * partialTicks;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.hasHealingShield()) {
            float pitchMod = Mth.m_14045_((int)(4 - this.getShieldLevel()), (int)1, (int)3);
            this.m_5496_(SoundEvents.f_11909_, this.m_6121_(), this.m_6100_() * pitchMod);
            this.setHealingShield(Math.max(0, this.getShieldLevel() - 1));
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268684_) || source.m_276093_(DamageTypes.f_268556_) || source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268526_) || source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268513_) || source.m_276093_(DamageTypes.f_268444_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268546_) || source.m_276093_(DamageTypes.f_268450_) || source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268669_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public float getShieldThickness() {
        switch (this.getShieldLevel()) {
            case 1: {
                return 0.15f;
            }
            case 2: {
                return 0.5f;
            }
            case 3: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.HENOS_SPAWN_EGG.get());
    }

    public static class BeamAttackAI
    extends Goal {
        private static final int TIME = 40;
        private Henos henos;
        private float laserYaw;
        private float laserPitch;
        private int laserSoundTick = 0;

        public BeamAttackAI(Henos henos) {
            this.henos = henos;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public static boolean canSeeEntity(Vec3 observer, Entity subject) {
            if (observer == null || subject == null) {
                return false;
            }
            AABB axisalignedbb = subject.m_20191_().m_82400_((double)0.3f);
            Vec3 subjectLocation = new Vec3(subject.m_20185_(), subject.m_20186_() + (double)subject.m_20192_(), subject.m_20189_());
            BlockHitResult traceToBlocks = subject.m_9236_().m_45547_(new ClipContext(observer, subjectLocation, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, subject));
            if (traceToBlocks.m_6662_() != HitResult.Type.MISS) {
                subjectLocation = traceToBlocks.m_82450_();
            }
            Optional traceToEntity = axisalignedbb.m_82371_(observer, subjectLocation);
            return traceToEntity.isPresent();
        }

        public boolean m_8036_() {
            return this.henos.m_21223_() <= this.henos.m_21233_() / 2.0f && !this.henos.isUsingRegularAttack() && this.henos.getLaserTick() >= 0;
        }

        public boolean m_8045_() {
            if (this.henos.f_19797_ > 0 && this.henos.f_19797_ % 20 == 0 && !BeamAttackAI.canSeeEntity(this.henos.m_20182_(), (Entity)this.henos.m_5448_())) {
                this.henos.setChargingBeam(false);
                this.henos.setUsingBeam(false);
                this.henos.setLaserTick(-120);
                return false;
            }
            if (this.henos.getLaserTick() <= 0 || !super.m_8045_()) {
                this.henos.setChargingBeam(false);
                this.henos.setUsingBeam(false);
                return false;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            this.laserSoundTick = 0;
            this.henos.setChargingBeam(true);
            this.henos.setLaserEntity((Entity)this.henos.m_5448_());
            this.henos.m_21573_().m_26573_();
            this.laserYaw = Mth.m_14177_((float)this.henos.f_19857_);
            this.laserPitch = Mth.m_14177_((float)(this.henos.f_19858_ + 90.0f));
            this.henos.f_19812_ = true;
            this.henos.setLaserTick(40);
            this.henos.setLaserX((float)this.henos.m_20185_());
            this.henos.setLaserY((float)this.henos.m_20186_());
            this.henos.setLaserZ((float)this.henos.m_20189_());
            this.henos.useBeam(true);
        }

        private float updateRotation(float currentAngle, float targetAngle, float maxChange) {
            float change = Mth.m_14177_((float)(targetAngle - currentAngle));
            return Mth.m_14177_((float)(currentAngle + this.henos.f_19796_.m_188501_() * 1.5f - 0.75f + change / maxChange));
        }

        private void updateLaser() {
            if (this.henos.m_9236_() != null && this.henos.m_5448_() != null) {
                double targetX = this.henos.m_5448_().m_20185_();
                double targetY = this.henos.m_5448_().m_20186_() + (double)(this.henos.m_5448_().m_20192_() * 0.5f);
                double targetZ = this.henos.m_5448_().m_20189_();
                double rot = (double)this.henos.f_20883_ * 0.01745329238474369 + 1.5707963267948966;
                double lureX = Math.cos(rot) * (double)(this.henos.m_20205_() + 1.0f) + this.henos.m_20185_();
                double lureY = this.henos.m_20227_(0.65f);
                double lureZ = Math.sin(rot) * (double)(this.henos.m_20205_() + 1.0f) + this.henos.m_20189_();
                Vec3 lureVec = new Vec3(lureX, lureY, lureZ);
                double d0 = targetX - lureX;
                double d1 = targetY - lureY;
                double d2 = targetZ - lureZ;
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                float targetYaw = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
                float laserProg = 1.0f - (float)Mth.m_14045_((int)this.henos.getLaserTick(), (int)0, (int)40) / 40.0f;
                float baseYaw = Mth.m_14177_((float)this.henos.f_19857_);
                float basePitch = Mth.m_14177_((float)(this.henos.f_19858_ + 120.0f));
                this.laserYaw = baseYaw + Mth.m_14177_((float)(targetYaw - baseYaw)) * laserProg;
                this.laserPitch = basePitch + (targetPitch - basePitch) * laserProg;
                Vec3 laserAngle = Vec3.m_82498_((float)this.laserPitch, (float)this.laserYaw);
                double range = 30.0;
                Vec3 hitVec = lureVec.m_82549_(laserAngle.m_82490_(range));
                BlockHitResult trace = this.henos.m_9236_().m_45547_(new ClipContext(lureVec, hitVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.henos));
                if (trace.m_6662_() != HitResult.Type.MISS) {
                    hitVec = trace.m_82450_();
                }
                this.henos.setLaserX((float)hitVec.f_82479_);
                this.henos.setLaserY((float)hitVec.f_82480_);
                this.henos.setLaserZ((float)hitVec.f_82481_);
                float f = 1.0f;
                if (this.henos.m_9236_().m_46791_() == Difficulty.HARD) {
                    f += 2.0f;
                }
                LivingEntity base = null;
                for (LivingEntity entity : this.henos.m_9236_().m_45976_(LivingEntity.class, this.henos.m_20191_().m_82400_(30.0))) {
                    AABB axisalignedbb = entity.m_20191_().m_82400_((double)0.3f);
                    Optional traceToEntity = axisalignedbb.m_82371_(lureVec, hitVec);
                    if (!traceToEntity.isPresent() || !BeamAttackAI.canSeeEntity(lureVec, (Entity)entity) || entity == this.henos || base != null && !(this.henos.m_20270_((Entity)entity) < this.henos.m_20270_((Entity)base))) continue;
                    base = entity;
                }
                if (base != null) {
                    base.m_6469_(this.henos.m_269291_().m_269333_((LivingEntity)this.henos), (float)this.henos.m_21051_(Attributes.f_22281_).m_22135_() / 2.0f);
                    if (!base.m_21254_()) {
                        base.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 140 * (int)f, 2));
                        base.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 140 * (int)f, 2));
                    }
                }
            }
        }

        public void m_8037_() {
            this.henos.m_21573_().m_26573_();
            if (this.henos.getLaserTick() > 0) {
                this.henos.setLaserTick(this.henos.getLaserTick() - 1);
            }
            if (this.henos.getLaserTick() == 0) {
                this.henos.setChargingBeam(false);
                this.henos.setUsingBeam(true);
                this.henos.m_5496_((SoundEvent)PFSounds.HENOS_LASER.get(), 1.0f, this.henos.m_6100_());
            } else if (this.henos.getLaserTick() > 0) {
                this.updateLaser();
                if (this.laserSoundTick % 17 == 0) {
                    this.henos.m_5496_((SoundEvent)PFSounds.HENOS_LASER_LOOP.get(), 1.0f, this.henos.m_6100_());
                }
                ++this.laserSoundTick;
            }
            super.m_8037_();
        }

        public void m_8041_() {
            this.henos.setLaserEntity(null);
            this.henos.setLaserTick(-50);
            this.henos.setLaserX((float)this.henos.m_20185_());
            this.henos.setLaserY((float)this.henos.m_20186_());
            this.henos.setLaserZ((float)this.henos.m_20189_());
            this.henos.useBeam(false);
        }
    }

    public class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        Henos henos;

        public MeleeAttackGoal(Henos henos, double speedIn, boolean useLongMemory) {
            super((PathfinderMob)henos, speedIn, useLongMemory);
            this.henos = henos;
        }

        public boolean m_8036_() {
            if (this.henos.m_21223_() >= this.henos.m_21233_() / 2.0f || this.henos.getLaserTick() < 0) {
                return super.m_8036_();
            }
            if (this.henos.m_21223_() <= this.henos.m_21233_() / 2.0f && !this.henos.isUsingBeamAttack()) {
                if (this.henos.m_5448_() != null) {
                    if (this.henos.m_20280_((Entity)this.henos.m_5448_()) <= 14.0) {
                        return super.m_8036_();
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return this.f_25540_.m_20205_() * 3.0f * this.f_25540_.m_20205_() * 3.0f + attackTarget.m_20205_();
        }

        public boolean m_8045_() {
            if (this.henos.getLaserTick() < 0) {
                return super.m_8045_();
            }
            if (this.henos.m_21223_() <= this.henos.m_21233_() / 2.0f && !this.henos.isUsingBeamAttack()) {
                if (this.henos.m_5448_() != null) {
                    if (this.henos.m_20280_((Entity)this.henos.m_5448_()) <= 10.0) {
                        return super.m_8045_();
                    }
                    return false;
                }
                return false;
            }
            if (this.henos.m_21223_() > this.henos.m_21233_() / 2.0f || this.henos.getLaserTick() < 0) {
                return super.m_8045_();
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            this.henos.useRegularAttack(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.henos.useRegularAttack(false);
        }
    }
}

