/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.goal;

import com.mojang.datafixers.DataFixUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.ai.goal.Goal;
import superlord.prehistoricfauna.common.entity.HerdDinosaurEntity;

public class FollowHerdLeaderGoal
extends Goal {
    private final HerdDinosaurEntity taskOwner;
    private int navigateTimer;
    private int cooldown;

    public FollowHerdLeaderGoal(HerdDinosaurEntity taskOwnerIn) {
        this.taskOwner = taskOwnerIn;
        this.cooldown = this.getNewCooldown(taskOwnerIn);
    }

    protected int getNewCooldown(HerdDinosaurEntity taskOwnerIn) {
        return FollowHerdLeaderGoal.m_186073_((int)(200 + taskOwnerIn.m_217043_().m_188503_(200) % 20));
    }

    public boolean m_8036_() {
        if (this.taskOwner.hasFollowers()) {
            return false;
        }
        if (this.taskOwner.isFollower()) {
            return true;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = this.getNewCooldown(this.taskOwner);
        Predicate<HerdDinosaurEntity> predicate = dinosaur -> dinosaur.canBeFollowed() || !dinosaur.isFollower();
        List list = this.taskOwner.m_9236_().m_6443_(((Object)((Object)this.taskOwner)).getClass(), this.taskOwner.m_20191_().m_82377_(8.0, 8.0, 8.0), predicate);
        HerdDinosaurEntity dinosaurEntity = (HerdDinosaurEntity)((Object)DataFixUtils.orElse(list.stream().filter(HerdDinosaurEntity::canBeFollowed).findAny(), (Object)((Object)this.taskOwner)));
        dinosaurEntity.addFollowers(list.stream().filter(dinosaur -> !dinosaur.isFollower()));
        return this.taskOwner.isFollower();
    }

    public boolean m_8045_() {
        return this.taskOwner.isFollower() && this.taskOwner.inRangeOfLeader();
    }

    public void m_8056_() {
        this.navigateTimer = 0;
    }

    public void m_8041_() {
        this.taskOwner.stopFollowing();
    }

    public void m_8037_() {
        if (--this.navigateTimer <= 0) {
            this.navigateTimer = this.m_183277_(10);
            this.taskOwner.pathToLeader();
        }
    }
}

