/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.fossil.jurassic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.entity.PrehistoricEntity;
import superlord.prehistoricfauna.init.PFItems;

public class AllosaurusSkeleton
extends PrehistoricEntity {
    private static final EntityDataAccessor<Boolean> ACTION_LEFT_POSE = SynchedEntityData.m_135353_(AllosaurusSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ACTION_RIGHT_POSE = SynchedEntityData.m_135353_(AllosaurusSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RESTING_POSE = SynchedEntityData.m_135353_(AllosaurusSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RETRO_POSE = SynchedEntityData.m_135353_(AllosaurusSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PUSHING = SynchedEntityData.m_135353_(AllosaurusSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOOKING = SynchedEntityData.m_135353_(AllosaurusSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public boolean isPushableState() {
        return (Boolean)this.f_19804_.m_135370_(PUSHING);
    }

    private void setPushable(boolean isPushable) {
        this.f_19804_.m_135381_(PUSHING, (Object)isPushable);
    }

    public boolean isLooking() {
        return (Boolean)this.f_19804_.m_135370_(LOOKING);
    }

    private void setLooking(boolean isLooking) {
        this.f_19804_.m_135381_(LOOKING, (Object)isLooking);
    }

    public boolean isActionLeft() {
        return (Boolean)this.f_19804_.m_135370_(ACTION_LEFT_POSE);
    }

    private void setActionLeft(boolean isActionLeft) {
        this.f_19804_.m_135381_(ACTION_LEFT_POSE, (Object)isActionLeft);
    }

    public boolean isActionRight() {
        return (Boolean)this.f_19804_.m_135370_(ACTION_RIGHT_POSE);
    }

    private void setActionRight(boolean isActionRight) {
        this.f_19804_.m_135381_(ACTION_RIGHT_POSE, (Object)isActionRight);
    }

    public boolean isClassical() {
        return (Boolean)this.f_19804_.m_135370_(RETRO_POSE);
    }

    private void setClassical(boolean isRetro) {
        this.f_19804_.m_135381_(RETRO_POSE, (Object)isRetro);
    }

    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING_POSE);
    }

    private void setResting(boolean isResting) {
        this.f_19804_.m_135381_(RESTING_POSE, (Object)isResting);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RETRO_POSE, (Object)false);
        this.f_19804_.m_135372_(ACTION_LEFT_POSE, (Object)false);
        this.f_19804_.m_135372_(ACTION_RIGHT_POSE, (Object)false);
        this.f_19804_.m_135372_(RESTING_POSE, (Object)false);
        this.f_19804_.m_135372_(PUSHING, (Object)false);
        this.f_19804_.m_135372_(LOOKING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsActionLeft", this.isActionLeft());
        compound.m_128379_("IsActionRight", this.isActionRight());
        compound.m_128379_("IsResting", this.isResting());
        compound.m_128379_("IsRetro", this.isClassical());
        compound.m_128379_("IsPushable", this.isPushableState());
        compound.m_128379_("IsLooking", this.isLooking());
        compound.m_128350_("Rotation", this.m_6080_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setActionLeft(compound.m_128471_("IsActionLeft"));
        this.setActionRight(compound.m_128471_("IsActionRight"));
        this.setResting(compound.m_128471_("IsResting"));
        this.setClassical(compound.m_128471_("IsRetro"));
        this.setPushable(compound.m_128471_("IsPushable"));
        this.setLooking(compound.m_128471_("IsLooking"));
        this.m_5618_(compound.m_128457_("Rotation"));
        this.m_5616_(compound.m_128457_("Rotation"));
    }

    public AllosaurusSkeleton(EntityType<? extends AllosaurusSkeleton> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal(this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0);
    }

    protected int getExperiencePoints(Player player) {
        return 0;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6094_() {
        return this.isPushableState();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == PFItems.GEOLOGY_HAMMER.get()) {
            if (!(this.isResting() || this.isActionLeft() || this.isActionRight() || this.isClassical() || player.m_6144_())) {
                this.setClassical(true);
            } else if (this.isClassical() && !player.m_6144_()) {
                this.setClassical(false);
                this.setResting(true);
            } else if (this.isResting() && !player.m_6144_()) {
                this.setResting(false);
                this.setActionLeft(true);
            } else if (this.isActionLeft() && !player.m_6144_()) {
                this.setActionLeft(false);
                this.setActionRight(true);
            } else if (this.isActionRight() && !player.m_6144_()) {
                this.setActionRight(false);
            } else if (player.m_6144_() && !this.isPushableState() && !this.isLooking()) {
                this.setPushable(true);
                player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.skeleton.pushable"), true);
            } else if (player.m_6144_() && this.isPushableState()) {
                this.setPushable(false);
                this.setLooking(true);
                player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.skeleton.rotating"), true);
            } else if (player.m_6144_() && this.isLooking()) {
                this.setLooking(false);
                player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.skeleton.neutral"), true);
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7324_(Entity entityIn) {
    }

    private void playBrokenSound() {
        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12381_, this.m_5720_(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50453_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            this.playBrokenSound();
            this.playParticles();
            this.spawnFossil(source);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
        if (source.m_7640_() instanceof Player) {
            this.playBrokenSound();
            this.playParticles();
            Player player = (Player)source.m_7640_();
            if (!player.m_7500_()) {
                this.spawnFossil(source);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
        return false;
    }

    public boolean canBeHitWithPotion() {
        return false;
    }

    public void onKillCommand() {
        this.m_6074_();
    }

    private void spawnFossil(DamageSource p_213815_1_) {
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)PFItems.ALLOSAURUS_SKELETON.get()));
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.ALLOSAURUS_SKELETON.get());
    }

    static class LookAtPlayerGoal
    extends net.minecraft.world.entity.ai.goal.LookAtPlayerGoal {
        AllosaurusSkeleton entity;

        public LookAtPlayerGoal(AllosaurusSkeleton entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((Mob)entityIn, watchTargetClass, maxDistance);
            this.entity = entityIn;
        }

        public boolean m_8036_() {
            if (this.entity.isLooking()) {
                return super.m_8036_();
            }
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.entity.isLooking();
        }
    }
}

