/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.fossil.cretaceous;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.entity.PrehistoricEntity;
import superlord.prehistoricfauna.init.PFItems;

public class ProtoceratopsSkeleton
extends PrehistoricEntity {
    private static final EntityDataAccessor<Boolean> DISPLAY = SynchedEntityData.m_135353_(ProtoceratopsSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAYING = SynchedEntityData.m_135353_(ProtoceratopsSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(ProtoceratopsSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(ProtoceratopsSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PUSHING = SynchedEntityData.m_135353_(ProtoceratopsSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LOOKING = SynchedEntityData.m_135353_(ProtoceratopsSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public boolean isPushableState() {
        return (Boolean)this.f_19804_.m_135370_(PUSHING);
    }

    private void setPushable(boolean isPushable) {
        this.f_19804_.m_135381_(PUSHING, (Object)isPushable);
    }

    public boolean isLooking() {
        return (Boolean)this.f_19804_.m_135370_(LOOKING);
    }

    private void setLooking(boolean isLooking) {
        this.f_19804_.m_135381_(LOOKING, (Object)isLooking);
    }

    public boolean isDisplaying() {
        return (Boolean)this.f_19804_.m_135370_(DISPLAY);
    }

    private void setDisplaying(boolean isDisplaying) {
        this.f_19804_.m_135381_(DISPLAY, (Object)isDisplaying);
    }

    public boolean isLaying() {
        return (Boolean)this.f_19804_.m_135370_(LAYING);
    }

    private void setLaying(boolean isLaying) {
        this.f_19804_.m_135381_(LAYING, (Object)isLaying);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    private void setSitting(boolean isSitting) {
        this.f_19804_.m_135381_(SITTING, (Object)isSitting);
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    private void setRunning(boolean isRunning) {
        this.f_19804_.m_135381_(RUNNING, (Object)isRunning);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DISPLAY, (Object)false);
        this.f_19804_.m_135372_(LAYING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(PUSHING, (Object)false);
        this.f_19804_.m_135372_(LOOKING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsDisplaying", this.isDisplaying());
        compound.m_128379_("IsLaying", this.isLaying());
        compound.m_128379_("IsSitting", this.isSitting());
        compound.m_128379_("IsRunning", this.isRunning());
        compound.m_128379_("IsPushable", this.isPushableState());
        compound.m_128379_("IsLooking", this.isLooking());
        compound.m_128350_("Rotation", this.m_6080_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDisplaying(compound.m_128471_("IsDisplaying"));
        this.setLaying(compound.m_128471_("IsLaying"));
        this.setSitting(compound.m_128471_("IsSitting"));
        this.setRunning(compound.m_128471_("IsRunning"));
        this.setPushable(compound.m_128471_("IsPushable"));
        this.setLooking(compound.m_128471_("IsLooking"));
        this.m_5618_(compound.m_128457_("Rotation"));
        this.m_5616_(compound.m_128457_("Rotation"));
    }

    public ProtoceratopsSkeleton(EntityType<? extends ProtoceratopsSkeleton> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal(this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0);
    }

    protected int getExperiencePoints(Player player) {
        return 0;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6094_() {
        return this.isPushableState();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == PFItems.GEOLOGY_HAMMER.get()) {
            if (!(this.m_5803_() || this.isLaying() || this.isSitting() || this.isDisplaying() || this.isRunning() || player.m_6144_())) {
                this.setDisplaying(true);
            } else if (this.isDisplaying() && !player.m_6144_()) {
                this.setDisplaying(false);
                this.setRunning(true);
            } else if (this.isRunning() && !player.m_6144_()) {
                this.setRunning(false);
                this.setLaying(true);
            } else if (this.isLaying() && !player.m_6144_()) {
                this.setLaying(false);
                this.setSitting(true);
            } else if (this.isSitting() && !player.m_6144_()) {
                this.setSitting(false);
            } else if (player.m_6144_() && !this.isPushableState() && !this.isLooking()) {
                this.setPushable(true);
                player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.skeleton.pushable"), true);
            } else if (player.m_6144_() && this.isPushableState()) {
                this.setPushable(false);
                this.setLooking(true);
                player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.skeleton.rotating"), true);
            } else if (player.m_6144_() && this.isLooking()) {
                this.setLooking(false);
                player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.skeleton.neutral"), true);
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7324_(Entity entityIn) {
    }

    private void playBrokenSound() {
        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12381_, this.m_5720_(), 1.0f, 1.0f);
    }

    private void playParticles() {
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50453_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            this.playBrokenSound();
            this.playParticles();
            this.spawnFossil(source);
            return super.m_6469_(source, amount);
        }
        if (source.m_7640_() instanceof Player) {
            this.playBrokenSound();
            this.playParticles();
            Player player = (Player)source.m_7640_();
            if (!player.m_7500_()) {
                this.spawnFossil(source);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
            return true;
        }
        return false;
    }

    public boolean canBeHitWithPotion() {
        return false;
    }

    public void onKillCommand() {
        this.m_6074_();
    }

    private void spawnFossil(DamageSource p_213815_1_) {
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)PFItems.PROTOCERATOPS_SKELETON.get()));
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.PROTOCERATOPS_SKELETON.get());
    }

    static class LookAtPlayerGoal
    extends net.minecraft.world.entity.ai.goal.LookAtPlayerGoal {
        ProtoceratopsSkeleton entity;

        public LookAtPlayerGoal(ProtoceratopsSkeleton entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((Mob)entityIn, watchTargetClass, maxDistance);
            this.entity = entityIn;
        }

        public boolean m_8036_() {
            if (this.entity.isLooking()) {
                return super.m_8036_();
            }
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.entity.isLooking();
        }
    }
}

