/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.fish;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Lonchidion
extends AbstractFish {
    private static final EntityDataAccessor<Boolean> CHINLE = SynchedEntityData.m_135353_(Lonchidion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Lonchidion(EntityType<? extends AbstractFish> p_27461_, Level p_27462_) {
        super(p_27461_, p_27462_);
    }

    public static AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)PFItems.LONCHIDION_BUCKET.get());
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)PFSounds.FISH_FLOP.get();
    }

    protected SoundEvent m_7975_(DamageSource p_28306_) {
        return (SoundEvent)PFSounds.LONCHIDION_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.LONCHIDION_DEATH.get();
    }

    public boolean isFromChinle() {
        return (Boolean)this.f_19804_.m_135370_(CHINLE);
    }

    public void setFromChinle(boolean isChinle) {
        this.f_19804_.m_135381_(CHINLE, (Object)isChinle);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHINLE, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsFromChinle", this.isFromChinle());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFromChinle(compound.m_128471_("IsFromChinle"));
    }

    public static boolean checkAncientFishSpawnRules(EntityType<? extends AbstractFish> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        int i = worldIn.m_5736_();
        int j = i - 13;
        return pos.m_123342_() >= j && worldIn.m_8055_(pos).m_60713_(Blocks.f_49990_) && randomIn.m_188501_() > 0.99f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.SPAWN_EGG) {
            this.setFromChinle(this.f_19796_.m_188499_());
        } else if (worldIn.m_204166_(this.m_20097_()).m_203656_(PFTags.HAS_CHINLE_HUT)) {
            this.setFromChinle(true);
        } else {
            this.setFromChinle(false);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_6872_(ItemStack p_30049_) {
        super.m_6872_(p_30049_);
        CompoundTag compoundtag = p_30049_.m_41784_();
        if (this.isFromChinle()) {
            compoundtag.m_128405_("chinle_variant", 1);
        } else {
            compoundtag.m_128405_("chinle_variant", 0);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.LONCHIDION_SPAWN_EGG.get());
    }
}

