/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CrepuscularSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HostileCarnivoreGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistBabyHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistHuntingGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Zhenyuanlong
extends DinosaurEntity {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Zhenyuanlong.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DISPLAYING = SynchedEntityData.m_135353_(Zhenyuanlong.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int maxHunger = 38;
    private int climbingTicks = 0;
    private int climbingTickCooldown = 0;

    public Zhenyuanlong(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.RAW_SMALL_THEROPOD_MEAT.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HostileCarnivoreGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DisplayGoal());
        this.f_21346_.m_25352_(2, (Goal)new OpportunistAttackGoal(this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new CrepuscularSleepGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.ZHENYUANLONG_AVOIDING)));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21346_.m_25352_(0, (Goal)new HuntGoal(this, LivingEntity.class, 10, false, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.ZHENYUANLONG_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.ZHENYUANLONG_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.ZHENYUANLONG_BABY_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new OpportunistHuntingGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.ZHENYUANLONG_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new OpportunistBabyHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.ZHENYUANLONG_BABY_HUNTING)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.ZHENYUANLONG.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.ZHENYUANLONG.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.zhenyuanlong_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setProtective(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setTerritorial(true);
        } else if (temperment >= 95) {
            this.setOpportunist(true);
        }
        this.setCarnivorous(true);
        this.setCrepuscular(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.ZHENYUANLONG_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.ZHENYUANLONG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.ZHENYUANLONG_DEATH.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(DISPLAYING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Displaying", this.isDisplaying());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setDisplaying(tag.m_128471_("Displaying"));
    }

    public boolean onLivingFall(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return flag;
    }

    public boolean isDisplaying() {
        return (Boolean)this.f_19804_.m_135370_(DISPLAYING);
    }

    public void setDisplaying(boolean displaying) {
        this.f_19804_.m_135381_(DISPLAYING, (Object)displaying);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19862_ && this.f_19862_) {
            BlockPos blockpos1 = new BlockPos(this.m_20183_().m_123341_() + 1, this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_());
            BlockPos blockpos2 = new BlockPos(this.m_20183_().m_123341_() - 1, this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_());
            BlockPos blockpos3 = new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_() + 1);
            BlockPos blockpos4 = new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_() - 1);
            BlockState blockstate1 = this.m_9236_().m_8055_(blockpos1);
            BlockState blockstate2 = this.m_9236_().m_8055_(blockpos2);
            BlockState blockstate3 = this.m_9236_().m_8055_(blockpos3);
            BlockState blockstate4 = this.m_9236_().m_8055_(blockpos4);
            if (blockstate1.m_204336_(BlockTags.f_13106_) || blockstate1.m_204336_(BlockTags.f_13090_) || blockstate1.m_204336_(BlockTags.f_13095_) || blockstate1.m_204336_(BlockTags.f_13098_) || blockstate1.m_204336_(BlockTags.f_13097_) || blockstate1.m_204336_(BlockTags.f_13096_) || blockstate2.m_204336_(BlockTags.f_13106_) || blockstate2.m_204336_(BlockTags.f_13090_) || blockstate2.m_204336_(BlockTags.f_13095_) || blockstate2.m_204336_(BlockTags.f_13098_) || blockstate2.m_204336_(BlockTags.f_13097_) || blockstate2.m_204336_(BlockTags.f_13096_) || blockstate3.m_204336_(BlockTags.f_13106_) || blockstate3.m_204336_(BlockTags.f_13090_) || blockstate3.m_204336_(BlockTags.f_13095_) || blockstate3.m_204336_(BlockTags.f_13098_) || blockstate3.m_204336_(BlockTags.f_13097_) || blockstate3.m_204336_(BlockTags.f_13096_) || blockstate4.m_204336_(BlockTags.f_13106_) || blockstate4.m_204336_(BlockTags.f_13090_) || blockstate4.m_204336_(BlockTags.f_13095_) || blockstate4.m_204336_(BlockTags.f_13098_) || blockstate4.m_204336_(BlockTags.f_13097_) || blockstate4.m_204336_(BlockTags.f_13096_)) {
                Boolean logBlock = true;
                if (this.climbingTickCooldown == 0 && this.climbingTicks < 600) {
                    this.setBesideClimbableBlock(logBlock);
                    ++this.climbingTicks;
                }
                if (this.climbingTicks >= 599 && this.climbingTickCooldown <= 300) {
                    ++this.climbingTickCooldown;
                }
                if (this.climbingTickCooldown == 300) {
                    this.climbingTicks = 0;
                    this.climbingTickCooldown = 0;
                }
            }
        }
    }

    public boolean isOnLadder() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Zhenyuanlong entity = new Zhenyuanlong((EntityType<? extends TamableAnimal>)((EntityType)PFEntities.ZHENYUANLONG.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.ZHENYUANLONG_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.ZHENYUANLONG_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.ZHENYUANLONG_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class DisplayGoal
    extends Goal {
        public DisplayGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            Iterator iterator = Zhenyuanlong.this.m_9236_().m_45976_(Player.class, Zhenyuanlong.this.m_20191_().m_82377_(4.0, 4.0, 4.0)).iterator();
            if (iterator.hasNext()) {
                Player player = (Player)iterator.next();
                return Zhenyuanlong.this.trusts(player.m_20148_()) && player.m_271686_() != null;
            }
            return Zhenyuanlong.this.m_271686_() != null;
        }

        public void m_8056_() {
            LivingEntity attacker;
            Zhenyuanlong.this.setDisplaying(true);
            if (Zhenyuanlong.this.m_217043_().m_188503_(2) == 0 && (attacker = Zhenyuanlong.this.m_271686_()) instanceof Mob) {
                Mob mob = (Mob)attacker;
                mob.m_6710_(null);
            }
        }

        public void m_8041_() {
            Zhenyuanlong.this.setDisplaying(false);
        }

        public boolean m_8045_() {
            return !Zhenyuanlong.this.m_21573_().m_26571_();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Zhenyuanlong.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }
}

