/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.HuntingDinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HostileCarnivoreGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.entity.henos.CorruptedTheropod;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Yutyrannus
extends HuntingDinosaurEntity {
    private static final EntityDataAccessor<Boolean> CONVERTING_TO_BOSS = SynchedEntityData.m_135353_(Yutyrannus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksTillConversion = 600;
    private int maxHunger = 150;
    private int warningSoundTicks;
    public int attackTick = 0;

    public Yutyrannus(EntityType<? extends Yutyrannus> p_21803_, Level p_21804_) {
        super((EntityType<? extends HuntingDinosaurEntity>)p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((HuntingDinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.RAW_LARGE_SAUROPOD_MEAT.get();
    }

    public boolean isConvertingToBoss() {
        return (Boolean)this.f_19804_.m_135370_(CONVERTING_TO_BOSS);
    }

    private void setConvertingToBoss(boolean isConverting) {
        this.f_19804_.m_135381_(CONVERTING_TO_BOSS, (Object)isConverting);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HostileCarnivoreGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(4, (Goal)new HuntGoal(this, LivingEntity.class, 10, false, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.YUTYRANNUS_HUNTING)));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.YUTYRANNUS_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new YutyrannusCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.YUTYRANNUS_HUNTING)));
        this.f_21345_.m_25352_(1, (Goal)new CathemeralSleepGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.YUTYRANNUS_BABY_HUNTING)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.YUTYRANNUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.YUTYRANNUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.yutyrannus_added"), true);
            return InteractionResult.SUCCESS;
        }
        if (item == PFItems.TIME_TOTEM.get() || item == PFItems.CRETACEOUS_TIME_TOTEM.get() || item == PFItems.JURASIC_TIME_TOTEM.get() || item == PFItems.TRIASSIC_TIME_TOTEM.get()) {
            this.setConvertingToBoss(true);
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 85) {
            this.setProtective(true);
        } else {
            this.setTerritorial(true);
        }
        this.setCarnivorous(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.YUTYRANNUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.YUTYRANNUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.YUTYRANNUS_DEATH.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CONVERTING_TO_BOSS, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ConvertingToBoss", this.isConvertingToBoss());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setConvertingToBoss(compound.m_128471_("ConvertingToBoss"));
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_6162_()) {
            if (!state.m_278721_()) {
                BlockState blockstate = this.m_9236_().m_8055_(pos.m_7494_());
                SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this) : state.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.YUTYRANNUS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return flag;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.isHunting()) {
            for (Yutyrannus yutyrannus : this.m_9236_().m_45976_(Yutyrannus.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                if (yutyrannus.m_6162_()) continue;
                yutyrannus.setHunting(true);
            }
        }
        if (this.isConvertingToBoss() && this.m_21515_()) {
            if (this.ticksTillConversion > 0) {
                --this.ticksTillConversion;
            } else {
                CorruptedTheropod boss = new CorruptedTheropod((EntityType<? extends CorruptedTheropod>)((EntityType)PFEntities.CORRUPTED_THEROPOD.get()), this.m_9236_());
                boss.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)boss);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Yutyrannus entity = new Yutyrannus((EntityType<? extends Yutyrannus>)((EntityType)PFEntities.YUTYRANNUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.YUTYRANNUS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.YUTYRANNUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.YUTYRANNUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Yutyrannus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                Yutyrannus.this.m_5496_((SoundEvent)PFSounds.YUTYRANNUS_BITE.get(), 1.0f, Yutyrannus.this.m_6100_());
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Yutyrannus.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    public class YutyrannusCarnivoreHuntGoal
    extends NearestAttackableTargetGoal {
        double huntSpeed;
        Predicate<LivingEntity> targetPredicate;
        Yutyrannus dinosaur;

        public YutyrannusCarnivoreHuntGoal(Yutyrannus goalOwnerIn, Class<?> targetClassIn, int targetChanceIn, double huntSpeed, boolean checkSight, @Nullable boolean nearbyOnly, Predicate<LivingEntity> targetPredicate) {
            super((Mob)goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnly, targetPredicate);
            this.huntSpeed = huntSpeed;
            this.targetPredicate = targetPredicate;
            this.dinosaur = goalOwnerIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.dinosaur.getCurrentHunger() <= this.dinosaur.getHalfHunger() && !this.dinosaur.m_6162_() && PrehistoricFaunaConfig.advancedHunger && !this.targetPredicate.test((LivingEntity)this.dinosaur) && !this.dinosaur.trusts(this.f_26050_.m_20148_()) && !this.dinosaur.isOpportunist() || this.dinosaur.isHunting();
        }

        public boolean m_8045_() {
            return this.dinosaur.getCurrentHunger() < this.dinosaur.maxHunger && PrehistoricFaunaConfig.advancedHunger;
        }

        public void m_8037_() {
            this.dinosaur.m_21573_().m_26517_(this.huntSpeed);
            if (this.dinosaur.m_5448_() != null) {
                LivingEntity target = this.dinosaur.m_5448_();
                if (!target.m_7306_(null)) {
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_3_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 3 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 3);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_4_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 4 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 4);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_6_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 6 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 6);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_8_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 8 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 8);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_10_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 10 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 10);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_15_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 15 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 15);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_20_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 20 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 20);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_30_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 30 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 30);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_40_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 40 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 40);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_60_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 60 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 60);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_80_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 80 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 80);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_100_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 100 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 100);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_200_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 200 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 200);
                        }
                    }
                } else {
                    this.m_8041_();
                }
            } else {
                this.m_8041_();
            }
            super.m_8037_();
        }
    }
}

