/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CrepuscularSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurOwnerHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurOwnerHurtTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HostileCarnivoreGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistBabyHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistHuntingGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Sinosauropteryx
extends DinosaurEntity {
    private static final EntityDataAccessor<Boolean> TAME_SIT = SynchedEntityData.m_135353_(Sinosauropteryx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(Sinosauropteryx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TAME_WANDER = SynchedEntityData.m_135353_(Sinosauropteryx.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> SIT_TICK = SynchedEntityData.m_135353_(Sinosauropteryx.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int maxHunger = 10;
    private int warningSoundTicks;
    private float sitProgress = 0.0f;
    private float prevSitProgress = 0.0f;

    public boolean isTameSitting() {
        return (Boolean)this.f_19804_.m_135370_(TAME_SIT);
    }

    private void setTameSitting(boolean isTameSitting) {
        this.f_19804_.m_135381_(SIT_TICK, (Object)15);
        this.f_19804_.m_135381_(TAME_SIT, (Object)isTameSitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    private void setSitting(boolean isSitting) {
        this.f_19804_.m_135381_(SIT_TICK, (Object)15);
        this.f_19804_.m_135381_(SITTING, (Object)isSitting);
    }

    public boolean isTameWandering() {
        return (Boolean)this.f_19804_.m_135370_(TAME_WANDER);
    }

    private void setTameWandering(boolean isTameWandering) {
        this.f_19804_.m_135381_(TAME_WANDER, (Object)isTameWandering);
    }

    public Sinosauropteryx(EntityType<? extends Sinosauropteryx> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.EPHEDRA_BERRIES.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SitAndLookGoal());
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21346_.m_25352_(2, (Goal)new OpportunistAttackGoal(this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new CrepuscularSleepGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HostileCarnivoreGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(0, (Goal)new DinosaurOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new DinosaurOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new SinosauropteryxRelaxOnOwnerGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new SinosauropteryxSitOnBedGoal(this, 1.1, 8));
        this.f_21345_.m_25352_(0, (Goal)new SinosauropteryxFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, true));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SINOSAUROPTERYX_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SINOSAUROPTERYX_BABY_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new OpportunistHuntingGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SINOSAUROPTERYX_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new OpportunistBabyHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SINOSAUROPTERYX_BABY_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new HuntGoal(this, LivingEntity.class, 10, false, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SINOSAUROPTERYX_HUNTING)));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SINOSAUROPTERYX_AVOIDING)));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsTamedSitting", this.isTameSitting());
        compound.m_128379_("IsTamedWander", this.isTameWandering());
        compound.m_128379_("IsSitting", this.isSitting());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setTameSitting(compound.m_128471_("IsTamedSitting"));
        this.setTameWandering(compound.m_128471_("IsTamedWander"));
        this.setSitting(compound.m_128471_("IsSitting"));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand p_230254_2_) {
        ItemStack itemstack = player.m_21120_(p_230254_2_);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.SINOSAUROPTERYX.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.SINOSAUROPTERYX.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.sinosauropteryx_added"), true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().m_5776_()) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemstack) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.getCurrentHunger() < this.maxHunger && (itemstack.m_204117_(PFTags.MEATS_2_HUNGER) || itemstack.m_204117_(PFTags.MEATS_4_HUNGER) || itemstack.m_204117_(PFTags.MEATS_6_HUNGER) || itemstack.m_204117_(PFTags.MEATS_8_HUNGER) || itemstack.m_204117_(PFTags.MEATS_10_HUNGER) || itemstack.m_204117_(PFTags.MEATS_12_HUNGER))) {
                if (itemstack.m_204117_(PFTags.MEATS_2_HUNGER)) {
                    if (this.getCurrentHunger() + 2 >= this.maxHunger) {
                        this.setHunger(this.maxHunger);
                    } else {
                        this.setHunger(this.getCurrentHunger() + 2);
                    }
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                }
                if (itemstack.m_204117_(PFTags.MEATS_4_HUNGER)) {
                    if (this.getCurrentHunger() + 4 >= this.maxHunger) {
                        this.setHunger(this.maxHunger);
                    } else {
                        this.setHunger(this.getCurrentHunger() + 4);
                    }
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                }
                if (itemstack.m_204117_(PFTags.MEATS_6_HUNGER)) {
                    if (this.getCurrentHunger() + 6 >= this.maxHunger) {
                        this.setHunger(this.maxHunger);
                    } else {
                        this.setHunger(this.getCurrentHunger() + 6);
                    }
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                }
                if (itemstack.m_204117_(PFTags.MEATS_8_HUNGER)) {
                    if (this.getCurrentHunger() + 8 >= this.maxHunger) {
                        this.setHunger(this.maxHunger);
                    } else {
                        this.setHunger(this.getCurrentHunger() + 8);
                    }
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                }
                if (itemstack.m_204117_(PFTags.MEATS_10_HUNGER)) {
                    if (this.getCurrentHunger() + 10 >= this.maxHunger) {
                        this.setHunger(this.maxHunger);
                    } else {
                        this.setHunger(this.getCurrentHunger() + 10);
                    }
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                }
                if (itemstack.m_204117_(PFTags.MEATS_12_HUNGER)) {
                    if (this.getCurrentHunger() + 12 >= this.maxHunger) {
                        this.setHunger(this.maxHunger);
                    } else {
                        this.setHunger(this.getCurrentHunger() + 12);
                    }
                    if (!player.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
            }
            if (this.m_269323_() == player) {
                if (this.m_6898_(itemstack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        this.m_5634_(item.m_41473_().m_38744_());
                        return InteractionResult.SUCCESS;
                    }
                    if (this.m_5957_()) {
                        this.m_27595_(player);
                        if (!player.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                } else if (this.isTameSitting()) {
                    this.setTameSitting(false);
                    this.setTameWandering(true);
                    player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.velociraptor.wandering"), true);
                } else if (this.isTameWandering()) {
                    this.setTameWandering(false);
                    player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.velociraptor.following"), true);
                } else {
                    this.setTameSitting(true);
                    player.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.velociraptor.sitting"), true);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.m_217043_().m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.setTameSitting(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, p_230254_2_);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.m_217043_().m_188503_(100);
        if (temperment < 80) {
            this.setSkittish(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setPassive(true);
        } else if (temperment >= 95) {
            this.setOpportunist(true);
        }
        this.setCarnivorous(true);
        this.setCrepuscular(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAME_SIT, (Object)false);
        this.f_19804_.m_135372_(TAME_WANDER, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(SIT_TICK, (Object)0);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(2.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.SINOSAUROPTERYX_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.SINOSAUROPTERYX_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.SINOSAUROPTERYX_DEATH.get();
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.SINOSAUROPTERYX_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        this.prevSitProgress = this.sitProgress;
        if ((Integer)this.f_19804_.m_135370_(SIT_TICK) > 0) {
            this.f_19804_.m_135381_(SIT_TICK, (Object)((Integer)this.f_19804_.m_135370_(SIT_TICK) - 1));
            if (this.sitProgress < 1.0f) {
                this.sitProgress = Math.min(this.sitProgress + 0.1f, 1.0f);
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress = Math.max(this.sitProgress - 0.2f, 0.0f);
        }
    }

    public float getSitProgress(float partialTick) {
        return this.prevSitProgress + (this.sitProgress - this.prevSitProgress) * partialTick;
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.isSitting() || this.isTameSitting()) {
            this.m_21573_().m_26573_();
        }
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Sinosauropteryx entity = new Sinosauropteryx((EntityType<? extends Sinosauropteryx>)((EntityType)PFEntities.SINOSAUROPTERYX.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.SINOSAUROPTERYX_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.SINOSAUROPTERYX_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.SINOSAUROPTERYX_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class SitAndLookGoal
    extends Goal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Sinosauropteryx.this.isTameSitting();
        }

        public boolean m_8045_() {
            if (Sinosauropteryx.this.isTameSitting()) {
                return true;
            }
            return this.field_220822_f > 0;
        }

        public void m_8056_() {
            this.func_220817_j();
            this.field_220822_f = 2 + Sinosauropteryx.this.m_217043_().m_188503_(3);
            Sinosauropteryx.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Sinosauropteryx.this.setTameSitting(false);
        }

        public void m_8037_() {
            Sinosauropteryx.this.m_21573_().m_26573_();
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            Sinosauropteryx.this.m_21563_().m_24950_(Sinosauropteryx.this.m_20185_() + this.field_220819_c, Sinosauropteryx.this.m_20188_(), Sinosauropteryx.this.m_20189_() + this.field_220820_d, (float)Sinosauropteryx.this.m_8085_(), (float)Sinosauropteryx.this.m_8132_());
        }

        private void func_220817_j() {
            double d0 = Math.PI * 2 * Sinosauropteryx.this.m_217043_().m_188500_();
            this.field_220819_c = Math.cos(d0);
            this.field_220820_d = Math.sin(d0);
            this.field_220821_e = 80 + Sinosauropteryx.this.m_217043_().m_188503_(20);
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Sinosauropteryx.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Sinosauropteryx.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class SinosauropteryxRelaxOnOwnerGoal
    extends Goal {
        private static final ResourceLocation GIFT_LOOT = new ResourceLocation("prehistoricfauna", "gameplay/sinosauropteryx_gift");
        private final Sinosauropteryx sinosauropteryx;
        @Nullable
        private Player ownerPlayer;
        @Nullable
        private BlockPos goalPos;
        private int onBedTicks;

        public SinosauropteryxRelaxOnOwnerGoal(Sinosauropteryx sinosauropteryx) {
            this.sinosauropteryx = sinosauropteryx;
        }

        public boolean m_8036_() {
            if (!this.sinosauropteryx.m_21824_()) {
                return false;
            }
            if (this.sinosauropteryx.m_21827_()) {
                return false;
            }
            LivingEntity livingentity = this.sinosauropteryx.m_269323_();
            if (livingentity instanceof Player) {
                this.ownerPlayer = (Player)livingentity;
                if (!livingentity.m_5803_()) {
                    return false;
                }
                if (this.sinosauropteryx.m_20280_((Entity)this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.ownerPlayer.m_20183_();
                BlockState blockstate = this.sinosauropteryx.m_9236_().m_8055_(blockpos);
                if (blockstate.m_204336_(BlockTags.f_13038_)) {
                    this.goalPos = blockstate.m_61145_((Property)BedBlock.f_54117_).map(p_28209_ -> blockpos.m_121945_(p_28209_.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockpos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            for (Sinosauropteryx sinosauropteryx : this.sinosauropteryx.m_9236_().m_45976_(Sinosauropteryx.class, new AABB(this.goalPos).m_82400_(2.0))) {
                if (sinosauropteryx == this.sinosauropteryx || !sinosauropteryx.isSitting()) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.sinosauropteryx.m_21824_() && !this.sinosauropteryx.m_21827_() && this.ownerPlayer != null && this.ownerPlayer.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void m_8056_() {
            if (this.goalPos != null) {
                this.sinosauropteryx.m_21837_(false);
                this.sinosauropteryx.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
            }
        }

        public void m_8041_() {
            this.sinosauropteryx.setSitting(false);
            float f = this.sinosauropteryx.m_9236_().m_46942_(1.0f);
            if (this.ownerPlayer.m_36318_() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.sinosauropteryx.m_9236_().m_213780_().m_188501_() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.sinosauropteryx.m_21573_().m_26573_();
        }

        private void giveMorningGift() {
            RandomSource randomsource = this.sinosauropteryx.m_217043_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockpos$mutableblockpos.m_122190_((Vec3i)(this.sinosauropteryx.m_21523_() ? this.sinosauropteryx.m_21524_().m_20183_() : this.sinosauropteryx.m_20183_()));
            this.sinosauropteryx.m_20984_(blockpos$mutableblockpos.m_123341_() + randomsource.m_188503_(11) - 5, blockpos$mutableblockpos.m_123342_() + randomsource.m_188503_(5) - 2, blockpos$mutableblockpos.m_123343_() + randomsource.m_188503_(11) - 5, false);
            blockpos$mutableblockpos.m_122190_((Vec3i)this.sinosauropteryx.m_20183_());
            LootTable loottable = this.sinosauropteryx.m_9236_().m_7654_().m_278653_().m_278676_(GIFT_LOOT);
            LootParams lootparams = new LootParams.Builder((ServerLevel)this.sinosauropteryx.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.sinosauropteryx.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.sinosauropteryx).m_287235_(LootContextParamSets.f_81416_);
            for (ItemStack itemstack : loottable.m_287195_(lootparams)) {
                this.sinosauropteryx.m_9236_().m_7967_((Entity)new ItemEntity(this.sinosauropteryx.m_9236_(), (double)blockpos$mutableblockpos.m_123341_() - (double)Mth.m_14031_((float)(this.sinosauropteryx.f_20883_ * ((float)Math.PI / 180))), (double)blockpos$mutableblockpos.m_123342_(), (double)blockpos$mutableblockpos.m_123343_() + (double)Mth.m_14089_((float)(this.sinosauropteryx.f_20883_ * ((float)Math.PI / 180))), itemstack));
            }
        }

        public void m_8037_() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.sinosauropteryx.m_21837_(false);
                this.sinosauropteryx.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
                if (this.sinosauropteryx.m_20280_((Entity)this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.m_183277_(16)) {
                        this.sinosauropteryx.setSitting(true);
                    } else {
                        this.sinosauropteryx.m_21391_((Entity)this.ownerPlayer, 45.0f, 45.0f);
                    }
                } else {
                    this.sinosauropteryx.setSitting(false);
                }
            }
        }
    }

    class SinosauropteryxSitOnBedGoal
    extends MoveToBlockGoal {
        private final Sinosauropteryx sinosauropteryx;

        public SinosauropteryxSitOnBedGoal(Sinosauropteryx sinosauropteryx, double p_25136_, int p_25137_) {
            super((PathfinderMob)sinosauropteryx, p_25136_, p_25137_, 6);
            this.sinosauropteryx = sinosauropteryx;
            this.f_25603_ = -2;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.sinosauropteryx.m_21824_() && !this.sinosauropteryx.m_21827_() && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.sinosauropteryx.m_21837_(false);
        }

        protected int m_6099_(PathfinderMob p_25140_) {
            return 40;
        }

        public void m_8041_() {
            super.m_8041_();
            this.sinosauropteryx.setSitting(false);
        }

        public void m_8037_() {
            super.m_8037_();
            this.sinosauropteryx.m_21837_(false);
            if (!this.m_25625_()) {
                this.sinosauropteryx.setSitting(false);
            } else if (!this.sinosauropteryx.isSitting()) {
                this.sinosauropteryx.setSitting(true);
            }
        }

        protected boolean m_6465_(LevelReader p_25142_, BlockPos p_25143_) {
            return p_25142_.m_46859_(p_25143_.m_7494_()) && p_25142_.m_8055_(p_25143_).m_204336_(BlockTags.f_13038_);
        }
    }

    public class SinosauropteryxFollowOwnerGoal
    extends FollowOwnerGoal {
        public SinosauropteryxFollowOwnerGoal(TamableAnimal tameable, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
            super(tameable, speed, minDist, maxDist, teleportToLeaves);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Sinosauropteryx.this.isTameSitting() && !Sinosauropteryx.this.isTameWandering();
        }
    }
}

