/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.AgedHerdDinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.AgedFollowHerdLeaderGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Ruixinia
extends AgedHerdDinosaurEntity {
    private static final EntityDataAccessor<Boolean> IS_JUVENILE = SynchedEntityData.m_135353_(Ruixinia.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int maxHunger = 150;
    private int warningSoundTicks;
    private int crushTicks = 0;

    public Ruixinia(EntityType<? extends AgedHerdDinosaurEntity> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((AgedHerdDinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean isJuvenile() {
        return (Boolean)this.f_19804_.m_135370_(IS_JUVENILE);
    }

    private void setJuvenile(boolean isJuvenile) {
        this.f_19804_.m_135381_(IS_JUVENILE, (Object)isJuvenile);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.CALLIANTHUS.get();
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            if (!this.isAsleep() || !this.m_6162_()) {
                this.m_5496_(soundevent, this.m_6121_() * 2.0f, this.m_6100_());
            } else {
                this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
            }
        }
    }

    @Override
    public double moveToRange() {
        return 10.0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new AgedFollowHerdLeaderGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new MateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.RUIXINIA_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.RUIXINIA.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.RUIXINIA.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.ruixinia_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? (SoundEvent)PFSounds.RUIXINIA_SNORES.get() : (SoundEvent)PFSounds.RUIXINIA_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.RUIXINIA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.RUIXINIA_DEATH.get();
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.RUIXINIA_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_JUVENILE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MaxHunger", this.currentHunger);
        compound.m_128379_("InNaturalLove", this.isInLoveNaturally());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() < -24000) {
            this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
        } else if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.setJuvenile(true);
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
        } else if (this.m_146764_() >= 0) {
            this.setJuvenile(false);
            this.m_21051_(Attributes.f_22276_).m_22100_(60.0);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!(this.m_20184_().f_82479_ == 0.0 && this.m_20184_().f_82480_ == 0.0 && this.m_20184_().f_82481_ == 0.0 || this.m_6162_())) {
            this.crushTicks = this.crushTicks <= 600 ? ++this.crushTicks : 0;
            for (ItemEntity entity : this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
                Item item = entity.m_32055_().m_41720_();
                if (this.crushTicks != 1200 || item != PFItems.HENOSTONE.get()) continue;
                if (this.f_19796_.m_188503_(100) < 5) {
                    ItemEntity newItem = new ItemEntity(this.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)PFItems.TIME_GEM_SHARD.get()));
                    newItem.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    this.m_9236_().m_7967_((Entity)newItem);
                }
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Ruixinia entity = new Ruixinia((EntityType<? extends AgedHerdDinosaurEntity>)((EntityType)PFEntities.RUIXINIA.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        entity.m_146762_(-72000);
        return entity;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 85) {
            this.setProtective(true);
        } else {
            this.setTerritorial(true);
        }
        this.setHerbivorous(true);
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.RUIXINIA_SPAWN_EGG.get());
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.RUIXINIA_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Ruixinia.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Ruixinia.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 15.0f + attackTarget.m_20205_();
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final Ruixinia ruixinia;
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
        private int breedDelay;
        private final double moveSpeed;

        MateGoal(Ruixinia ruixinia, double speed) {
            super((Animal)ruixinia, speed);
            this.ruixinia = ruixinia;
            this.moveSpeed = speed;
        }

        @Nullable
        private Animal getNearbyMate() {
            List list = this.f_25114_.m_45971_(Ruixinia.class, PARTNER_TARGETING, (LivingEntity)this.f_25113_, this.f_25113_.m_20191_().m_82400_(24.0));
            double d0 = Double.MAX_VALUE;
            Animal animalentity = null;
            for (Animal animalentity1 : list) {
                if (!this.f_25113_.m_7848_(animalentity1) || !(this.f_25113_.m_20280_((Entity)animalentity1) < d0)) continue;
                animalentity = animalentity1;
                d0 = this.f_25113_.m_20280_((Entity)animalentity1);
            }
            return animalentity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.ruixinia.hasBaby() && !this.ruixinia.isInLoveNaturally();
        }

        public void m_8041_() {
            this.f_25115_ = null;
            this.breedDelay = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            this.f_25113_.m_21563_().m_24960_((Entity)this.f_25115_, 10.0f, (float)this.f_25113_.m_8132_());
            this.f_25113_.m_21573_().m_5624_((Entity)this.f_25115_, this.moveSpeed);
            ++this.breedDelay;
            if (this.breedDelay >= 60 && this.f_25113_.m_20280_((Entity)this.f_25115_) < 20.0) {
                this.m_8026_();
            }
        }

        protected void m_8026_() {
            ServerPlayer serverPlayer = this.f_25113_.m_27592_();
            if (serverPlayer == null && this.f_25115_.m_27592_() != null) {
                serverPlayer = this.f_25115_.m_27592_();
            }
            if (serverPlayer != null) {
                serverPlayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayer, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.ruixinia.setHasBaby(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource random = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final Ruixinia ruixinia;

        NaturalMateGoal(Ruixinia ruixinia, double speed) {
            super((Animal)ruixinia, speed);
            this.ruixinia = ruixinia;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.ruixinia.hasBaby() && this.ruixinia.getCurrentHunger() >= this.ruixinia.getThreeQuartersHunger() && this.ruixinia.f_19797_ % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.ruixinia.isInLoveNaturally();
        }

        protected void m_8026_() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.ruixinia.m_5496_(SoundEvents.f_11752_, 1.0f, (this.ruixinia.f_19796_.m_188501_() - this.ruixinia.f_19796_.m_188501_()) * 0.2f + 1.0f);
                int eggAmount = this.ruixinia.f_19796_.m_188503_(4);
                for (int i = 0; i <= eggAmount; ++i) {
                    this.ruixinia.m_19998_((ItemLike)((Block)PFBlocks.RUIXINIA_EGG.get()).m_5456_());
                }
            } else {
                this.ruixinia.setHasBaby(true);
            }
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
        }
    }

    class RuixiniaFollowParentGoal
    extends Goal {
        private final Ruixinia babyRuixinia;
        private Ruixinia parentRuixinia;
        private final double moveSpeed;
        private int delayCounter;

        public RuixiniaFollowParentGoal(Ruixinia ruixinia, double speed) {
            this.babyRuixinia = ruixinia;
            this.moveSpeed = speed;
        }

        public boolean m_8036_() {
            if (this.babyRuixinia.m_6162_() && !this.babyRuixinia.isJuvenile()) {
                List list = this.babyRuixinia.m_9236_().m_45976_(((Object)((Object)this.babyRuixinia)).getClass(), this.babyRuixinia.m_20191_().m_82377_(8.0, 4.0, 8.0));
                Ruixinia ruixinia = null;
                double d0 = Double.MAX_VALUE;
                for (Ruixinia tyrannosaurus1 : list) {
                    double d1;
                    if (tyrannosaurus1.m_6162_() || (d1 = this.babyRuixinia.m_20280_((Entity)tyrannosaurus1)) > d0) continue;
                    d0 = d1;
                    ruixinia = tyrannosaurus1;
                }
                if (ruixinia == null) {
                    return false;
                }
                if (d0 < 9.0) {
                    return false;
                }
                this.parentRuixinia = ruixinia;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!this.babyRuixinia.isJuvenile() || !this.babyRuixinia.m_6162_()) {
                return false;
            }
            if (!this.parentRuixinia.m_6084_()) {
                return false;
            }
            if (this.babyRuixinia.m_6162_() && !this.babyRuixinia.isJuvenile()) {
                double d0 = this.babyRuixinia.m_20280_((Entity)this.parentRuixinia);
                return !(d0 < 9.0) && !(d0 > 256.0);
            }
            return false;
        }

        public void m_8056_() {
            this.delayCounter = 0;
        }

        public void m_8041_() {
            this.parentRuixinia = null;
        }

        public void m_8037_() {
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.babyRuixinia.m_21573_().m_5624_((Entity)this.parentRuixinia, this.moveSpeed);
            }
        }
    }
}

