/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.entity.BurrowingDinosaur;
import superlord.prehistoricfauna.common.entity.goal.AvoidHealthyAdultGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.LowHealthOrBabyHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Repenomamus
extends BurrowingDinosaur {
    private int maxHunger = 20;

    public Repenomamus(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((BurrowingDinosaur)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.RAW_SMALL_MARGINOCEPHALIAN_MEAT.get();
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new MateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new CarryYoungGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(8, new AvoidHealthyAdultGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.REPENOMAMUS_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new LowHealthOrBabyHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.REPENOMAMUS_HUNTING)));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.REPENOMAMUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.REPENOMAMUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.repenomamus_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.REPENOMAMUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)PFSounds.REPENOMAMUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.REPENOMAMUS_DEATH.get();
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setOpportunist(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setTerritorial(true);
        } else if (temperment >= 95) {
            this.setProtective(true);
        }
        this.setCarnivorous(true);
        this.setNocturnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Repenomamus entity = new Repenomamus((EntityType<? extends TamableAnimal>)((EntityType)PFEntities.REPENOMAMUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.REPENOMAMUS_SPAWN_EGG.get());
    }

    static class MateGoal
    extends BreedGoal {
        private final Repenomamus repenomamus;

        MateGoal(Repenomamus repenomamus, double speed) {
            super((Animal)repenomamus, speed);
            this.repenomamus = repenomamus;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.repenomamus.hasBaby() && !this.repenomamus.isInLoveNaturally();
        }

        protected void m_8026_() {
            ServerPlayer serverplayerentity = this.f_25113_.m_27592_();
            if (serverplayerentity == null && this.f_25115_.m_27592_() != null) {
                serverplayerentity = this.f_25115_.m_27592_();
            }
            if (serverplayerentity != null) {
                serverplayerentity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayerentity, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.repenomamus.setHasBaby(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource random = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final Repenomamus repenomamus;

        NaturalMateGoal(Repenomamus repenomamus, double speed) {
            super((Animal)repenomamus, speed);
            this.repenomamus = repenomamus;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.repenomamus.hasBaby() && this.repenomamus.getCurrentHunger() >= this.repenomamus.getThreeQuartersHunger() && this.repenomamus.f_19797_ % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.repenomamus.isInLoveNaturally();
        }

        protected void m_8026_() {
            this.repenomamus.setHasBaby(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
        }
    }

    static class CarryYoungGoal
    extends MoveToBlockGoal {
        private final Repenomamus repenomamus;

        CarryYoungGoal(Repenomamus repenomamus, double speedIn) {
            super((PathfinderMob)repenomamus, speedIn, 16);
            this.repenomamus = repenomamus;
        }

        public boolean m_8036_() {
            return this.repenomamus.hasBaby() ? super.m_8036_() : false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.repenomamus.hasBaby();
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.repenomamus.m_20069_() && this.m_25625_()) {
                if (this.repenomamus.isBirthing < 1) {
                    this.repenomamus.setBirthing(true);
                } else if (this.repenomamus.isBirthing > 200) {
                    Level level = this.repenomamus.m_9236_();
                    int amount = level.f_46441_.m_188503_(4) + 1;
                    for (int i = 0; i < amount; ++i) {
                        Repenomamus baby = new Repenomamus((EntityType<? extends TamableAnimal>)((EntityType)PFEntities.REPENOMAMUS.get()), level);
                        baby.m_146762_(-24000);
                        baby.m_6034_(this.repenomamus.m_20185_(), this.repenomamus.m_20186_(), this.repenomamus.m_20189_());
                        level.m_7967_((Entity)baby);
                    }
                    this.repenomamus.setHasBaby(false);
                    this.repenomamus.setBirthing(false);
                    this.repenomamus.m_27601_(600);
                }
                if (this.repenomamus.isBirthing()) {
                    ++this.repenomamus.isBirthing;
                }
            }
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            if (!worldIn.m_46859_(pos.m_7494_())) {
                return false;
            }
            Block block = worldIn.m_8055_(pos).m_60734_();
            BlockState state = worldIn.m_8055_(pos);
            return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50599_ || block == Blocks.f_50195_ || block == Blocks.f_49992_ || block == Blocks.f_49993_ || block == PFBlocks.MOSSY_DIRT.get() || block == PFBlocks.MOSS_BLOCK.get() || block == PFBlocks.LOAM.get() || block == PFBlocks.PACKED_LOAM.get() || block == PFBlocks.SILT.get() || block == PFBlocks.PACKED_LOAM.get() || state.m_204336_(BlockTags.f_13035_);
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Repenomamus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }
}

