/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;
import superlord.prehistoricfauna.common.entity.cretaceous.yixian.Cretaraneus;
import superlord.prehistoricfauna.common.entity.navigation.DirectPathNavigator;
import superlord.prehistoricfauna.common.entity.navigation.FlightMoveController;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;

public class Liaonemobius
extends Animal {
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.m_135353_(Liaonemobius.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Liaonemobius.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    private Direction prevAttachDir = Direction.DOWN;
    public boolean isUpsideDownNavigator;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;

    public Liaonemobius(EntityType type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.f_21343_ = new LiaonemobiusJumpControl(this);
        this.switchNavigator(true);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)PFSounds.LIAONEMOBIUS_IDLE.get();
    }

    protected void m_7355_(BlockPos p_33543_, BlockState p_33544_) {
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_() * 5.0f, this.m_6100_());
        }
    }

    private void switchNavigator(boolean rightsideUp) {
        if (rightsideUp) {
            this.f_21342_ = new LiaonemobiusMoveControl(this);
            this.f_21344_ = new WallClimberNavigation((Mob)this, this.m_9236_());
            this.enableJumpControl();
            this.isUpsideDownNavigator = false;
        } else {
            this.f_21342_ = new FlightMoveController((Mob)this, 0.6f, false);
            this.f_21344_ = new DirectPathNavigator((Mob)this, this.m_9236_());
            this.disableJumpControl();
            this.isUpsideDownNavigator = true;
        }
    }

    protected float m_6118_() {
        Path path;
        float f = 0.3f;
        if (this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5) {
            f = 0.5f;
        }
        if ((path = this.f_21344_.m_26570_()) != null && !path.m_77392_()) {
            Vec3 vec3 = path.m_77380_((Entity)this);
            if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                f = 0.5f;
            }
        }
        if (this.f_21342_.m_24999_() <= 0.6) {
            f = 0.2f;
        }
        return f + this.m_285755_();
    }

    public void setSpeedModifier(double p_29726_) {
        this.m_21573_().m_26517_(p_29726_);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), p_29726_);
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float p_29736_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_29736_) / (float)this.jumpDuration;
    }

    public void m_8024_() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.m_20096_()) {
            LiaonemobiusJumpControl liaonemobius$liaonemobiusjumpcontrol;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (!(liaonemobius$liaonemobiusjumpcontrol = (LiaonemobiusJumpControl)this.f_21343_).wantJump()) {
                if (this.f_21342_.m_24995_() && this.jumpDelayTicks == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vec3 = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vec3 = path.m_77380_((Entity)this);
                    }
                    this.facePoint(vec3.f_82479_, vec3.f_82481_);
                    this.startJumping();
                }
            } else if (!liaonemobius$liaonemobiusjumpcontrol.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    private void facePoint(double p_29687_, double p_29688_) {
        this.m_146922_((float)(Mth.m_14136_((double)(p_29688_ - this.m_20189_()), (double)(p_29687_ - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((LiaonemobiusJumpControl)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((LiaonemobiusJumpControl)this.f_21343_).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
    }

    public void m_7822_(byte p_29663_) {
        if (p_29663_ == 1) {
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(p_29663_);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.m_5496_((SoundEvent)PFSounds.LIAONEMOBIUS_HOP.get(), 0.15f, 1.0f);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    private static boolean isSideSolid(BlockGetter reader, BlockPos pos, Entity entityIn, Direction direction) {
        return Block.m_49918_((VoxelShape)reader.m_8055_(pos).m_60742_(reader, pos, CollisionContext.m_82750_((Entity)entityIn)), (Direction)direction);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.f_19804_.m_135370_(ATTACHED_FACE);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cretaraneus.class, 6.0f, 1.0, 1.2));
    }

    public int getMaxAir() {
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42590_) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            player.m_36356_(new ItemStack((ItemLike)PFItems.BOTTLED_LIAONEMOBIUS.get()));
            this.m_146870_();
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attachChangeProgress > 0.0f) {
            this.attachChangeProgress -= 0.25f;
        }
        this.m_274367_(1.0f);
        Vec3 vector3d = this.m_20184_();
        if (!this.m_9236_().m_5776_()) {
            this.setBesideClimbableBlock(this.f_19862_ || this.f_19863_ && !this.m_20096_());
            if (this.m_20096_() || this.m_20072_() || this.m_20077_()) {
                this.f_19804_.m_135381_(ATTACHED_FACE, (Object)Direction.DOWN);
            } else if (this.f_19863_) {
                this.f_19804_.m_135381_(ATTACHED_FACE, (Object)Direction.UP);
            } else {
                Direction closestDirection = Direction.DOWN;
                double closestDistance = 100.0;
                for (Direction dir : HORIZONTALS) {
                    BlockPos antPos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
                    BlockPos offsetPos = antPos.m_121945_(dir);
                    Vec3 offset = Vec3.m_82512_((Vec3i)offsetPos);
                    if (!(closestDistance > this.m_20182_().m_82554_(offset)) || !this.m_9236_().m_46578_(offsetPos, (Entity)this, dir.m_122424_())) continue;
                    closestDistance = this.m_20182_().m_82554_(offset);
                    closestDirection = dir;
                }
                this.f_19804_.m_135381_(ATTACHED_FACE, (Object)closestDirection);
            }
        }
        boolean flag = false;
        if (this.getAttachmentFacing() != Direction.DOWN) {
            if (this.getAttachmentFacing() == Direction.UP) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 1.0, 0.0));
            } else {
                if (!this.f_19862_ && this.getAttachmentFacing() != Direction.UP) {
                    Vec3 vec = Vec3.m_82528_((Vec3i)this.getAttachmentFacing().m_122436_());
                    this.m_20256_(this.m_20184_().m_82549_(vec.m_82541_().m_82542_((double)0.1f, (double)0.1f, (double)0.1f)));
                }
                if (!this.m_20096_() && vector3d.f_82480_ < 0.0) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
                    flag = true;
                }
            }
        }
        if (this.getAttachmentFacing() == Direction.UP) {
            this.m_20242_(true);
            this.m_20256_(vector3d.m_82542_(0.7, 1.0, 0.7));
        } else {
            this.m_20242_(false);
        }
        if (!flag && this.m_6147_()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.4, 1.0));
        }
        if (this.prevAttachDir != this.getAttachmentFacing()) {
            this.attachChangeProgress = 1.0f;
        }
        this.prevAttachDir = this.getAttachmentFacing();
        if (this.m_9236_().m_5776_()) {
            if (this.getAttachmentFacing() == Direction.UP && !this.isUpsideDownNavigator) {
                this.switchNavigator(false);
            }
            if (this.getAttachmentFacing() != Direction.UP && this.isUpsideDownNavigator) {
                this.switchNavigator(true);
            }
        }
    }

    private boolean isClimeableFromSide(BlockPos offsetPos, Direction opposite) {
        return false;
    }

    protected void m_6763_(BlockState state) {
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(ATTACHED_FACE, (Object)Direction.DOWN);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)Direction.m_122376_((int)compound.m_128445_("AttachFace")));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("AttachFace", (byte)((Direction)this.f_19804_.m_135370_(ATTACHED_FACE)).m_122411_());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    public static boolean canBugSpawn(EntityType<? extends PathfinderMob> animal, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return (worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || worldIn.m_8055_(pos.m_7495_()).m_204336_(Tags.Blocks.SAND) || worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13035_) || worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13105_)) && worldIn.m_45524_(pos, 0) > 8;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.LIAONEMOBIUS_SPAWN_EGG.get());
    }

    public static class LiaonemobiusJumpControl
    extends JumpControl {
        private final Liaonemobius liaonemobius;
        private boolean canJump;

        public LiaonemobiusJumpControl(Liaonemobius p_186229_) {
            super((Mob)p_186229_);
            this.liaonemobius = p_186229_;
        }

        public boolean wantJump() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean p_29759_) {
            this.canJump = p_29759_;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.liaonemobius.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    static class LiaonemobiusMoveControl
    extends MoveControl {
        private final Liaonemobius liaonemobius;
        private double nextJumpSpeed;

        public LiaonemobiusMoveControl(Liaonemobius p_29766_) {
            super((Mob)p_29766_);
            this.liaonemobius = p_29766_;
        }

        public void m_8126_() {
            if (this.liaonemobius.m_20096_() && !this.liaonemobius.f_20899_ && !((LiaonemobiusJumpControl)this.liaonemobius.f_21343_).wantJump()) {
                this.liaonemobius.setSpeedModifier(0.0);
            } else if (this.m_24995_()) {
                this.liaonemobius.setSpeedModifier(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double p_29769_, double p_29770_, double p_29771_, double p_29772_) {
            if (this.liaonemobius.m_20069_()) {
                p_29772_ = 1.5;
            }
            super.m_6849_(p_29769_, p_29770_, p_29771_, p_29772_);
            if (p_29772_ > 0.0) {
                this.nextJumpSpeed = p_29772_;
            }
        }
    }
}

