/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.blocks.SapBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Jinzhousaurus
extends DinosaurEntity {
    private static final EntityDataAccessor<Boolean> SCRATCHING = SynchedEntityData.m_135353_(Jinzhousaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int maxHunger = 100;
    private int warningSoundTicks;
    int scratchTick = 3000;

    public Jinzhousaurus(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Jinzhousaurus entity = new Jinzhousaurus((EntityType<? extends TamableAnimal>)((EntityType)PFEntities.JINZHOUSAURUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.RUFFORDIA.get()).m_5456_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new StripLogGoal(1.2f, 12, 2));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.JINZHOUSAURUS_AVOIDING)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.JINZHOUSAURUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.JINZHOUSAURUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.jinzhousaurus_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 20.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.JINZHOUSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.JINZHOUSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.JINZHOUSAURUS_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.m_6162_()) {
            if (!blockIn.m_278721_()) {
                BlockState blockstate = this.m_9236_().m_8055_(pos.m_7494_());
                SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this) : blockIn.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    public boolean isScratching() {
        return (Boolean)this.f_19804_.m_135370_(SCRATCHING);
    }

    public void setScratching(boolean scratching) {
        this.f_19804_.m_135381_(SCRATCHING, (Object)scratching);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCRATCHING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Scratching", this.isScratching());
    }

    public void setAdditionalSaveData(CompoundTag compound) {
        super.m_7378_(compound);
        this.setScratching(compound.m_128471_("Scratching"));
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.JINZHOUSAURUS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.scratchTick != 0 && !this.isScratching()) {
            --this.scratchTick;
        }
        if (this.scratchTick == 0) {
            this.setScratching(true);
            this.scratchTick = 3000;
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 85) {
            this.setProtective(true);
        } else {
            this.setTerritorial(true);
        }
        this.setHerbivorous(this.f_19850_);
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.JINZHOUSAURUS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.JINZHOUSAURUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.JINZHOUSAURUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Jinzhousaurus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Jinzhousaurus.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }

    class StripLogGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public StripLogGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((PathfinderMob)Jinzhousaurus.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Jinzhousaurus.this.isScratching();
        }

        public boolean m_8045_() {
            return super.m_8045_() && Jinzhousaurus.this.isScratching();
        }

        public void m_8041_() {
            Jinzhousaurus.this.setScratching(false);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean shouldMove() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.m_8055_(pos);
            return blockstate.m_204336_(BlockTags.f_13106_);
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.field_220731_g >= 40) {
                    this.causeSap();
                } else {
                    ++this.field_220731_g;
                }
            }
            super.m_8037_();
        }

        public void causeSap() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)Jinzhousaurus.this.m_9236_(), (Entity)Jinzhousaurus.this) && Jinzhousaurus.this.m_9236_().m_8055_(this.f_25602_.m_121945_(Jinzhousaurus.this.m_6350_().m_122424_())).m_60795_()) {
                Jinzhousaurus.this.m_9236_().m_46597_(this.f_25602_.m_121945_(Jinzhousaurus.this.m_6350_().m_122424_()), (BlockState)((Block)PFBlocks.SAP.get()).m_49966_().m_61124_((Property)SapBlock.FACING, (Comparable)Jinzhousaurus.this.m_6350_()));
                this.m_8041_();
            }
        }
    }
}

