/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.yixian;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CrepuscularSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.InsectivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Changyuraptor
extends DinosaurEntity {
    public static final EntityDataAccessor<Integer> FALLING_TICK = SynchedEntityData.m_135353_(Changyuraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> STEALING = SynchedEntityData.m_135353_(Changyuraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Changyuraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Nullable
    private BlockPos targetPosition;
    int timer = 0;
    int tryStealing = 0;

    public Changyuraptor(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_274367_(1.0f);
        this.f_21344_ = new WallClimberNavigation((Mob)this, this.m_9236_());
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.DEAD_SPIDER.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(1, (Goal)new CrepuscularSleepGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new InsectivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.CHANGYURAPTOR_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.CHANGYURAPTOR_BABY_HUNTING)));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.CHANGYURAPTOR_AVOIDING)));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 85) {
            this.setPassive(true);
        } else {
            this.setSkittish(true);
        }
        this.setInsectivorous(true);
        this.setCrepuscular(true);
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_213945_(RandomSource p_218171_, DifficultyInstance p_218172_) {
        if (p_218171_.m_188501_() < 0.2f) {
            float f = p_218171_.m_188501_();
            ItemStack itemstack = f < 0.05f ? new ItemStack((ItemLike)PFItems.FERMENTED_GINKO_BERRY.get()) : (f < 0.2f ? new ItemStack((ItemLike)PFItems.TIME_GEM_SHARD.get()) : (f < 0.4f ? (p_218171_.m_188499_() ? new ItemStack((ItemLike)PFItems.DEAD_HOPPER.get()) : new ItemStack((ItemLike)PFItems.DEAD_BEETLE.get())) : (f < 0.6f ? new ItemStack((ItemLike)PFItems.TUBER.get()) : (f < 0.8f ? new ItemStack((ItemLike)PFItems.REPENOMAMUS_HIDE.get()) : new ItemStack((ItemLike)Items.f_42402_)))));
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(3.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(6.0);
        }
    }

    private static boolean isSideSolid(BlockGetter reader, BlockPos pos, Entity entityIn, Direction direction) {
        return Block.m_49918_((VoxelShape)reader.m_8055_(pos).m_60742_(reader, pos, CollisionContext.m_82750_((Entity)entityIn)), (Direction)direction);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    private boolean isClimeableFromSide(BlockPos offsetPos, Direction opposite) {
        return false;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isStealing() {
        return (Boolean)this.f_19804_.m_135370_(STEALING);
    }

    public void setStealing(boolean isStealing) {
        this.f_19804_.m_135381_(STEALING, (Object)isStealing);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(f_21798_, (Object)b0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.CHANGYURAPTOR_IDLE.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setClimbing(this.f_19862_);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.CHANGYURAPTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.CHANGYURAPTOR_DEATH.get();
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Changyuraptor entity = new Changyuraptor((EntityType<? extends TamableAnimal>)((EntityType)PFEntities.CHANGYURAPTOR.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.CHANGYURAPTOR_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.CHANGYURAPTOR_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.CHANGYURAPTOR_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    public boolean m_142535_(float p_148875_, float p_148876_, DamageSource p_148877_) {
        return false;
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)itemEntity);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        ItemStack stack = this.m_21205_();
        ItemStack newStack = new ItemStack((ItemLike)Items.f_41852_);
        if (stack.m_41720_() != Items.f_41852_) {
            ++this.timer;
            if (this.timer == 600) {
                this.spawnItem(stack);
                this.m_21008_(InteractionHand.MAIN_HAND, newStack);
                this.timer = 0;
            }
            if (this.m_21188_() != null && this.timer < 600) {
                this.spawnItem(stack);
                this.m_21008_(InteractionHand.MAIN_HAND, newStack);
                this.timer = 0;
            }
        }
        if (this.f_19797_ > 1000 && this.f_19796_.m_188503_(1000) == 213) {
            this.setStealing(true);
        }
        if (this.isStealing()) {
            ++this.tryStealing;
            if (this.tryStealing == 600) {
                this.setStealing(false);
                this.tryStealing = 0;
            }
            for (Player entity : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(8.0, 8.0, 8.0))) {
                if (entity.m_21205_() == new ItemStack((ItemLike)Items.f_41852_) || entity.m_7500_() || !this.m_21205_().m_41619_()) continue;
                this.m_21573_().m_5624_((Entity)entity, 1.0);
                for (Player closePlayer : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(1.0, 2.0, 1.0))) {
                    if (!this.m_21205_().m_41619_() || closePlayer.m_21205_().m_41619_()) continue;
                    ItemStack stack1 = closePlayer.m_21120_(InteractionHand.MAIN_HAND);
                    if (closePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41613_() > 1) {
                        stack1.m_41774_(1);
                        closePlayer.m_21008_(InteractionHand.MAIN_HAND, stack1);
                    } else {
                        ItemStack airStack = new ItemStack((ItemLike)Items.f_41852_);
                        closePlayer.m_21008_(InteractionHand.MAIN_HAND, airStack);
                    }
                    this.m_21008_(InteractionHand.MAIN_HAND, stack1);
                    this.tryStealing = 0;
                }
            }
        }
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_() && !this.isClimbing()) {
            this.setFallingTicks(this.getFallingTicks() + 1);
            if (this.getFallingTicks() < 10) {
                this.m_20256_(vec3.m_82542_(1.0, 0.75, 1.0));
            } else {
                this.m_20256_(vec3.m_82542_(vec3.f_82479_ * 2.5, 0.5, vec3.f_82481_ * 2.5));
            }
        } else {
            this.setFallingTicks(0);
        }
    }

    @Override
    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        Item item;
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (!this.m_21205_().m_41619_() && itemstack.m_204117_(PFTags.INSECTS_2_HUNGER_ITEM)) {
            this.spawnItem(this.m_21205_());
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41852_));
            itemstack.m_41774_(1);
        }
        if ((item = itemstack.m_41720_()) instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.CHANGYURAPTOR.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.CHANGYURAPTOR.ordinal()), itemstack);
            p_230254_1_.m_5661_((Component)Component.m_237115_((String)"paleopedia.changyuraptor_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.getFallingTicks() != 0) {
            if (this.targetPosition == null || this.targetPosition.m_203195_((Position)this.m_20182_(), 12.0)) {
                this.targetPosition = new BlockPos((int)this.m_20185_() + this.f_19796_.m_188503_(7) - this.f_19796_.m_188503_(7), (int)this.m_20186_() + this.f_19796_.m_188503_(6) - 2, (int)this.m_20189_() + this.f_19796_.m_188503_(7) - this.f_19796_.m_188503_(7));
            }
            double d2 = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
            double d1 = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3 = this.m_20184_();
            Vec3 vec31 = vec3.m_82520_((Math.signum(d2) * 0.5 - vec3.f_82479_) * (double)0.3f, 0.0, (Math.signum(d1) * 0.5 - vec3.f_82481_) * (double)0.3f);
            this.m_20256_(vec31);
            float f = (float)(Mth.m_14136_((double)vec31.f_82481_, (double)vec31.f_82479_) * 57.2957763671875) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.m_146922_(this.m_146908_() + f1);
        }
    }

    public int getFallingTicks() {
        return (Integer)this.f_19804_.m_135370_(FALLING_TICK);
    }

    public void setFallingTicks(int fallingTick) {
        this.f_19804_.m_135381_(FALLING_TICK, (Object)fallingTick);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FALLING_TICK, (Object)0);
        this.f_19804_.m_135372_(STEALING, (Object)false);
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FallingTick", this.getFallingTicks());
        compound.m_128379_("Stealing", this.isStealing());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFallingTicks(compound.m_128451_("FallingTick"));
        this.setStealing(compound.m_128471_("Stealing"));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Changyuraptor.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }
}

