/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.AggressiveTempermentAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HostileCarnivoreGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.JuvenileCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.JuvenileHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.entity.henos.CorruptedTheropod;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEffects;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Tyrannosaurus
extends DinosaurEntity {
    private static final EntityDataAccessor<Boolean> IS_JUVENILE = SynchedEntityData.m_135353_(Tyrannosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CONVERTING_TO_BOSS = SynchedEntityData.m_135353_(Tyrannosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int maxHunger = 250;
    private int ticksTillConversion = 600;
    private int warningSoundTicks;
    public int attackTick = 0;
    private Goal panicGoal;

    public Tyrannosaurus(EntityType<? extends Tyrannosaurus> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (!this.isJuvenile()) {
            return 1.4f;
        }
        if (this.isJuvenile()) {
            return 2.8f;
        }
        return 4.0f;
    }

    public boolean isJuvenile() {
        return (Boolean)this.f_19804_.m_135370_(IS_JUVENILE);
    }

    public void setJuvenile(boolean isJuvenile) {
        this.f_19804_.m_135381_(IS_JUVENILE, (Object)isJuvenile);
    }

    public boolean isConvertingToBoss() {
        return (Boolean)this.f_19804_.m_135370_(CONVERTING_TO_BOSS);
    }

    private void setConvertingToBoss(boolean isConverting) {
        this.f_19804_.m_135381_(CONVERTING_TO_BOSS, (Object)isConverting);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.RAW_LARGE_ORNITHISCHIAN_MEAT.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.panicGoal = new BabyPanicGoal(this);
        this.f_21345_.m_25352_(1, this.panicGoal);
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TyrannosaurusFollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AggressiveTempermentAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new CathemeralSleepGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21346_.m_25352_(0, (Goal)new HostileCarnivoreGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new JuvenileHuntGoal(this, LivingEntity.class, 10, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TYRANNOSAURUS_JUVENILE_HUNTING)));
        this.f_21346_.m_25352_(1, (Goal)new HuntGoal(this, LivingEntity.class, 10, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TYRANNOSAURUS_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TYRANNOSAURUS_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new JuvenileCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TYRANNOSAURUS_JUVENILE_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TYRANNOSAURUS_BABY_HUNTING)));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TYRANNOSAURUS_AVOIDING)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.TYRANNOSAURUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.TYRANNOSAURUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.tyrannosaurus_added"), true);
            return InteractionResult.SUCCESS;
        }
        if (item == PFItems.TIME_TOTEM.get() || item == PFItems.CRETACEOUS_TIME_TOTEM.get() || item == PFItems.JURASIC_TIME_TOTEM.get() || item == PFItems.TRIASSIC_TIME_TOTEM.get()) {
            this.setConvertingToBoss(true);
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
        }
        return super.m_6071_(player, hand);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22278_, 0.75);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() < -24000) {
            this.m_21051_(Attributes.f_22276_).m_22100_(25.0);
        } else if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.setJuvenile(true);
            this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
        } else if (this.m_146764_() >= 0) {
            this.setJuvenile(false);
            this.m_21051_(Attributes.f_22276_).m_22100_(100.0);
        }
    }

    protected SoundEvent m_7515_() {
        if (this.isAsleep()) {
            if (!this.m_6162_()) {
                return (SoundEvent)PFSounds.TYRANNOSAURUS_SNORES.get();
            }
            return null;
        }
        return (SoundEvent)PFSounds.TYRANNOSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.TYRANNOSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.TYRANNOSAURUS_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_6162_()) {
            if (!state.m_278721_()) {
                BlockState blockstate = this.m_9236_().m_8055_(pos.m_7494_());
                SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this) : state.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.TYRANNOSAURUS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_JUVENILE, (Object)false);
        this.f_19804_.m_135372_(CONVERTING_TO_BOSS, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ConvertingToBoss", this.isConvertingToBoss());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setConvertingToBoss(compound.m_128471_("ConvertingToBoss"));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.isConvertingToBoss() && this.m_21515_()) {
            if (this.ticksTillConversion > 0) {
                --this.ticksTillConversion;
            } else {
                CorruptedTheropod boss = new CorruptedTheropod((EntityType<? extends CorruptedTheropod>)((EntityType)PFEntities.CORRUPTED_THEROPOD.get()), this.m_9236_());
                boss.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)boss);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setProtective(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setTerritorial(true);
        } else if (temperment >= 95) {
            this.m_21561_(true);
        }
        this.setCarnivorous(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance((MobEffect)PFEffects.BLEEDING.get(), 300, 0, true, false));
        }
        return flag;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Tyrannosaurus entity = new Tyrannosaurus((EntityType<? extends Tyrannosaurus>)((EntityType)PFEntities.TYRANNOSAURUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        entity.m_146762_(-48000);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.TYRANNOSAURUS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.TYRANNOSAURUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.TYRANNOSAURUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class TyrannosaurusFollowParentGoal
    extends Goal {
        private final Tyrannosaurus babyTyrannosaurus;
        private Tyrannosaurus parentTyrannosaurus;
        private final double moveSpeed;
        private int delayCounter;

        public TyrannosaurusFollowParentGoal(Tyrannosaurus tyrannosaurus, double speed) {
            this.babyTyrannosaurus = tyrannosaurus;
            this.moveSpeed = speed;
        }

        public boolean m_8036_() {
            if (this.babyTyrannosaurus.m_6162_() && !this.babyTyrannosaurus.isJuvenile()) {
                List list = this.babyTyrannosaurus.m_9236_().m_45976_(((Object)((Object)this.babyTyrannosaurus)).getClass(), this.babyTyrannosaurus.m_20191_().m_82377_(8.0, 4.0, 8.0));
                Tyrannosaurus tyrannosaurus = null;
                double d0 = Double.MAX_VALUE;
                for (Tyrannosaurus tyrannosaurus1 : list) {
                    double d1;
                    if (tyrannosaurus1.m_6162_() || (d1 = this.babyTyrannosaurus.m_20280_((Entity)tyrannosaurus1)) > d0) continue;
                    d0 = d1;
                    tyrannosaurus = tyrannosaurus1;
                }
                if (tyrannosaurus == null) {
                    return false;
                }
                if (d0 < 9.0) {
                    return false;
                }
                this.parentTyrannosaurus = tyrannosaurus;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!this.babyTyrannosaurus.isJuvenile() || !this.babyTyrannosaurus.m_6162_()) {
                return false;
            }
            if (!this.parentTyrannosaurus.m_6084_()) {
                return false;
            }
            if (this.babyTyrannosaurus.m_6162_() && !this.babyTyrannosaurus.isJuvenile()) {
                double d0 = this.babyTyrannosaurus.m_20280_((Entity)this.parentTyrannosaurus);
                return !(d0 < 9.0) && !(d0 > 256.0);
            }
            return false;
        }

        public void m_8056_() {
            this.delayCounter = 0;
        }

        public void m_8041_() {
            this.parentTyrannosaurus = null;
        }

        public void m_8037_() {
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.babyTyrannosaurus.m_21573_().m_5624_((Entity)this.parentTyrannosaurus, this.moveSpeed);
            }
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Tyrannosaurus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                Tyrannosaurus.this.m_5496_((SoundEvent)PFSounds.TYRANNOSAURUS_BITE.get(), 1.0f, Tyrannosaurus.this.m_6100_());
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Tyrannosaurus.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 15.0f + attackTarget.m_20205_();
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final Tyrannosaurus tyrannosaurus;

        NaturalMateGoal(Tyrannosaurus tyrannosaurus, double speed) {
            super((Animal)tyrannosaurus, speed);
            this.tyrannosaurus = tyrannosaurus;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.tyrannosaurus.hasBaby() && this.tyrannosaurus.getCurrentHunger() >= this.tyrannosaurus.getThreeQuartersHunger() && this.tyrannosaurus.f_19797_ % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.tyrannosaurus.isInLoveNaturally();
        }

        protected void m_8026_() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.tyrannosaurus.m_5496_(SoundEvents.f_11752_, 1.0f, (this.tyrannosaurus.f_19796_.m_188501_() - this.tyrannosaurus.f_19796_.m_188501_()) * 0.2f + 1.0f);
                int eggAmount = this.tyrannosaurus.f_19796_.m_188503_(4);
                for (int i = 0; i <= eggAmount; ++i) {
                    this.tyrannosaurus.m_19998_((ItemLike)PFItems.TYRANNOSAURUS_EGG.get());
                }
            } else {
                this.tyrannosaurus.setHasBaby(true);
            }
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final Tyrannosaurus tyrannosaurus;

        MateGoal(Tyrannosaurus tyrannosaurus, double speedIn) {
            super((Animal)tyrannosaurus, speedIn);
            this.tyrannosaurus = tyrannosaurus;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.tyrannosaurus.hasBaby() && !this.tyrannosaurus.isInLoveNaturally();
        }

        protected void m_8026_() {
            ServerPlayer serverplayerentity = this.f_25113_.m_27592_();
            if (serverplayerentity == null && this.f_25115_.m_27592_() != null) {
                serverplayerentity = this.f_25115_.m_27592_();
            }
            if (serverplayerentity != null) {
                serverplayerentity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayerentity, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.tyrannosaurus.setHasBaby(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource random = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((PathfinderMob)Tyrannosaurus.this, 2.0);
        }

        public boolean m_8036_() {
            if (!Tyrannosaurus.this.m_6162_() && !Tyrannosaurus.this.m_6060_()) {
                return false;
            }
            if (Tyrannosaurus.this.isJuvenile() && !Tyrannosaurus.this.m_6060_()) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

