/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.blocks.FeederBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Triceratops
extends AbstractChestedHorse {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DIGGING = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_JUVENILE = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALBINO = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MELANISTIC = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NATURAL_LOVE = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SLEEP_TICK = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> PROTECTIVE = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TERRITORIAL = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AGGRESSIVE = SynchedEntityData.m_135353_(Triceratops.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int maxHunger = 200;
    private int currentHunger = 200;
    int hungerTick = 0;
    private int lastInLove = 0;
    private int warningSoundTicks;
    private int isDigging;
    public float ridingXZ;
    public float ridingY = 1.0f;
    private boolean allowStandSliding;
    public int attackTick;
    int loveTick = 0;
    private float meleeProgress = 0.0f;
    private float prevMeleeProgress = 0.0f;
    private float sleepProgress = 0.0f;
    private float prevSleepProgress = 0.0f;
    public int warryTicks = 0;

    public Triceratops(EntityType<? extends Triceratops> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.75f;
        }
        return 2.2f;
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Triceratops entity = new Triceratops((EntityType<? extends Triceratops>)((EntityType)PFEntities.TRICERATOPS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        entity.m_146762_(-48000);
        return entity;
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(IS_DIGGING);
    }

    private void setDigging(boolean isDigging) {
        this.isDigging = isDigging ? 1 : 0;
        this.f_19804_.m_135381_(IS_DIGGING, (Object)isDigging);
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    private void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    private void setSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)isSleeping);
    }

    public boolean isJuvenile() {
        return (Boolean)this.f_19804_.m_135370_(IS_JUVENILE);
    }

    public void setJuvenile(boolean isJuvenile) {
        this.f_19804_.m_135381_(IS_JUVENILE, (Object)isJuvenile);
    }

    public boolean isAlbino() {
        return (Boolean)this.f_19804_.m_135370_(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.f_19804_.m_135381_(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.f_19804_.m_135370_(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.f_19804_.m_135381_(MELANISTIC, (Object)isMelanistic);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.OSMUNDA.get()).m_5456_();
    }

    public boolean isLoveNaturally() {
        return (Boolean)this.f_19804_.m_135370_(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isLoveNaturally) {
        this.f_19804_.m_135381_(NATURAL_LOVE, (Object)isLoveNaturally);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    private void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    protected void m_214179_(RandomSource p_218803_) {
    }

    public boolean m_30617_() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    private void setTriceratopsEating(boolean isEating) {
        this.f_19804_.m_135381_(EATING, (Object)isEating);
    }

    public boolean isProtective() {
        return (Boolean)this.f_19804_.m_135370_(PROTECTIVE);
    }

    public void setProtective(boolean isProtective) {
        this.f_19804_.m_135381_(PROTECTIVE, (Object)isProtective);
    }

    public boolean isTerritorial() {
        return (Boolean)this.f_19804_.m_135370_(TERRITORIAL);
    }

    public void setTerritorial(boolean isTerritorial) {
        this.f_19804_.m_135381_(TERRITORIAL, (Object)isTerritorial);
    }

    public boolean m_5912_() {
        return (Boolean)this.f_19804_.m_135370_(AGGRESSIVE);
    }

    public void m_21561_(boolean isAggressive) {
        this.f_19804_.m_135381_(AGGRESSIVE, (Object)isAggressive);
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return list;
    }

    public void addTrustedUUID(@Nullable UUID p_28516_) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    public void removeTrustedUUID(@Nullable UUID p_28516_) {
        this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, null);
        this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, null);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal());
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TriceratopsLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new TriceratopsRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AttackPlayerGoal());
        this.f_21346_.m_25352_(2, (Goal)new TriceratopsTerritorialAttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TriceratopsAggressiveTempermentAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new MateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new CathemeralSleepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(1.2f, 12, 2));
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, (double)1.2f));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TRICERATOPS_AVOIDING)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22288_, 0.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected SoundEvent m_7515_() {
        return this.m_5803_() ? (SoundEvent)PFSounds.TRICERATOPS_SNORES.get() : (SoundEvent)PFSounds.TRICERATOPS_IDLE.get();
    }

    protected void m_5877_(SoundType p_190680_1_) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.TRICERATOPS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.TRICERATOPS_DEATH.get();
    }

    protected SoundEvent m_7871_() {
        return (SoundEvent)PFSounds.TRICERATOPS_WARN.get();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource p_149501_) {
        int i;
        if (distance > 1.0f) {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
        if ((i = this.m_5639_(distance, damageMultiplier)) <= 0) {
            return false;
        }
        this.m_6469_(this.m_269291_().m_268989_(), i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(this.m_269291_().m_268989_(), (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_6162_()) {
            if (!state.m_278721_()) {
                BlockState blockstate = this.m_9236_().m_8055_(pos.m_7494_());
                SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this) : state.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.TRICERATOPS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(IS_DIGGING, (Object)false);
        this.f_19804_.m_135372_(IS_JUVENILE, (Object)false);
        this.f_19804_.m_135372_(ALBINO, (Object)false);
        this.f_19804_.m_135372_(MELANISTIC, (Object)false);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(NATURAL_LOVE, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
        this.f_19804_.m_135372_(SLEEP_TICK, (Object)0);
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.f_19804_.m_135372_(PROTECTIVE, (Object)false);
        this.f_19804_.m_135372_(TERRITORIAL, (Object)false);
        this.f_19804_.m_135372_(AGGRESSIVE, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        compound.m_128365_("Trusted", (Tag)listtag);
        compound.m_128379_("HasEgg", this.hasEgg());
        compound.m_128379_("IsAlbino", this.isAlbino());
        compound.m_128379_("IsMelanistic", this.isMelanistic());
        compound.m_128379_("IsSleeping", this.m_5803_());
        compound.m_128405_("AttackTick", this.attackTick);
        compound.m_128405_("MaxHunger", this.currentHunger);
        compound.m_128379_("IsEating", this.m_30617_());
        compound.m_128379_("InNaturalLove", this.isLoveNaturally());
        compound.m_128379_("IsProtective", this.isProtective());
        compound.m_128379_("IsTerritorial", this.isTerritorial());
        compound.m_128379_("IsAggressive", this.m_5912_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ListTag listtag = compound.m_128437_("Trusted", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
        }
        this.setHasEgg(compound.m_128471_("HasEgg"));
        this.setAlbino(compound.m_128471_("IsAlbino"));
        this.setMelanistic(compound.m_128471_("IsMelanistic"));
        this.setSleeping(compound.m_128471_("IsSleeping"));
        this.attackTick = compound.m_128451_("AttackTick");
        this.setTriceratopsEating(compound.m_128471_("IsEating"));
        this.setHunger(compound.m_128451_("MaxHunger"));
        this.setInLoveNaturally(compound.m_128471_("InNaturalLove"));
        this.setProtective(compound.m_128471_("IsProtective"));
        this.setTerritorial(compound.m_128471_("IsTerritorial"));
        this.m_21561_(compound.m_128471_("IsAggressive"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Random random = new Random();
        int birthNumber = random.nextInt(799);
        int temperment = random.nextInt(100);
        if (temperment < 80) {
            this.setProtective(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setTerritorial(true);
        } else {
            this.m_21561_(true);
        }
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal otherAnimal) {
        return this.m_30628_() && ((Triceratops)otherAnimal).m_30628_();
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.TRICERATOPS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.TRICERATOPS.ordinal()), itemstack);
            p_230254_1_.m_5661_((Component)Component.m_237115_((String)"paleopedia.triceratops_added"), true);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6162_()) {
            if (this.m_30614_() && p_230254_1_.m_36341_()) {
                this.m_213583_(p_230254_1_);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (this.m_20160_()) {
                return super.m_6071_(p_230254_1_, p_230254_2_);
            }
        }
        if (!itemstack.m_41619_()) {
            if (!this.m_30614_()) {
                this.m_7564_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (!this.m_30502_() && itemstack.m_41720_() == Blocks.f_50087_.m_5456_()) {
                this.m_30504_(true);
                this.m_7609_();
                if (!p_230254_1_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_30625_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (!this.m_6162_() && !this.m_6254_() && itemstack.m_41720_() == Items.f_42450_) {
                this.m_213583_(p_230254_1_);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return super.m_6071_(p_230254_1_, p_230254_2_);
        }
        if (PrehistoricFaunaConfig.advancedHunger) {
            int hunger = this.getCurrentHunger();
            if (hunger < this.maxHunger) {
                if (!(!this.m_6898_(itemstack) || this.m_27593_() && this.isLoveNaturally())) {
                    this.m_27595_(p_230254_1_);
                    if (!p_230254_1_.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                } else {
                    if (itemstack.m_204117_(PFTags.PLANTS_2_HUNGER_ITEM)) {
                        if (hunger + 2 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 2);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_4_HUNGER_ITEM)) {
                        if (hunger + 4 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 4);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_6_HUNGER_ITEM)) {
                        if (hunger + 6 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 6);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_8_HUNGER_ITEM)) {
                        if (hunger + 8 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 8);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_10_HUNGER_ITEM)) {
                        if (hunger + 10 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 10);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_12_HUNGER_ITEM)) {
                        if (hunger + 12 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 12);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_15_HUNGER_ITEM)) {
                        if (hunger + 15 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 15);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_20_HUNGER_ITEM)) {
                        if (hunger + 20 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 20);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_25_HUNGER_ITEM)) {
                        if (hunger + 25 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 25);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_204117_(PFTags.PLANTS_30_HUNGER_ITEM)) {
                        if (hunger + 30 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 30);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (itemstack.m_150930_((Item)PFItems.MARMARTHIA_BERRIES.get())) {
                        if (hunger + 2 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 2);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                        this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 300));
                    }
                }
            }
            if (itemstack.m_204117_(PFTags.PLANTS_2_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_4_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_6_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_8_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_10_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_12_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_15_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_20_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_25_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_30_HUNGER_ITEM)) {
                p_230254_1_.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
            }
        }
        if (this.m_6162_()) {
            return super.m_6071_(p_230254_1_, p_230254_2_);
        }
        this.m_6835_(p_230254_1_);
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevSleepProgress = this.sleepProgress;
        this.prevMeleeProgress = this.meleeProgress;
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        if ((Integer)this.f_19804_.m_135370_(SLEEP_TICK) > 0) {
            this.f_19804_.m_135381_(SLEEP_TICK, (Object)((Integer)this.f_19804_.m_135370_(SLEEP_TICK) - 1));
            if (this.sleepProgress < 1.0f) {
                this.sleepProgress = Math.min(this.sleepProgress + 0.1f, 1.0f);
            }
        } else if (this.sleepProgress > 0.0f) {
            this.sleepProgress = Math.max(this.sleepProgress - 0.2f, 0.0f);
        }
        if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) > 0) {
            LivingEntity target = this.m_5448_();
            if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) == 1 && target != null && this.m_142582_((Entity)target) && this.m_20270_((Entity)target) < this.getMeleeRange() + this.m_20205_() + target.m_20205_()) {
                this.onAttackAnimationFinish((Entity)target);
            }
            this.f_19804_.m_135381_(ATTACK_TICK, (Object)((Integer)this.f_19804_.m_135370_(ATTACK_TICK) - 1));
            if (this.meleeProgress < 1.0f) {
                this.meleeProgress = Math.min(this.meleeProgress + 0.2f, 1.0f);
            }
        } else if (this.meleeProgress > 0.0f) {
            this.meleeProgress = Math.max(this.meleeProgress - 0.2f, 0.0f);
        }
    }

    public float getMeleeRange() {
        return 2.5f;
    }

    public boolean attackEntityAsMob(Entity entityIn) {
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)7);
        return true;
    }

    public boolean onAttackAnimationFinish(Entity target) {
        return target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
    }

    public float getSleepProgress(float partialTick) {
        return this.prevSleepProgress + (this.sleepProgress - this.prevSleepProgress) * partialTick;
    }

    public float getMeleeProgress(float partialTick) {
        return this.prevMeleeProgress + (this.meleeProgress - this.prevMeleeProgress) * partialTick;
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.m_5803_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.2f);
        }
        if (!this.m_21525_()) {
            List list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(20.0, 20.0, 20.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.m_6162_() || this.hungerTick == 300 && this.m_6162_() && !this.isJuvenile() || this.hungerTick == 450 && this.isJuvenile()) {
                    if (!this.m_5803_()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.m_21223_() > this.m_21233_() / 2.0f) {
                            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.m_9236_().m_46791_() == Difficulty.HARD && this.m_21223_() <= this.m_21233_() / 2.0f) {
                            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.currentHunger == 0 && !this.m_6162_() && !this.getTrustedUUIDs().isEmpty()) {
                    this.getTrustedUUIDs().clear();
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.m_21223_() < this.m_21233_() && this.m_21223_() != 0.0f && this.m_5448_() == null && this.m_21188_() == null) {
                    float currentHealth = this.m_21223_();
                    this.m_21153_(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.f_19797_ % 900 != 0 || this.m_6162_() || this.m_27593_() || this.m_5803_() || list.size() >= 10)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.m_27601_(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                int naturalBreedingChance = this.f_19796_.m_188503_(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.m_6162_() || this.m_27593_() || this.m_5803_() || list.size() >= 10)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.m_27601_(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
        if (!this.m_9236_().m_5776_() && this.warryTicks != 0) {
            --this.warryTicks;
        }
    }

    public void setAwakeTicks(int ticks) {
        this.warryTicks = ticks;
    }

    public void setFallingAsleep() {
        this.f_19804_.m_135381_(SLEEP_TICK, (Object)15);
    }

    protected void m_5502_(Player p_28481_, Mob p_28482_) {
        ((Triceratops)p_28482_).addTrustedUUID(p_28481_.m_20148_());
    }

    public boolean trusts(UUID p_28530_) {
        return this.getTrustedUUIDs().contains(p_28530_);
    }

    public Player getRidingPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    public void m_19956_(Entity p_30642_, Entity.MoveFunction p_289531_) {
        super.m_19956_(p_30642_, p_289531_);
        if (p_30642_ instanceof Mob) {
            Mob mob = (Mob)p_30642_;
            this.f_20883_ = mob.f_20883_;
        }
        float radius = this.ridingXZ * 0.7f * -3.0f;
        float angle = (float)Math.PI / 180 * this.f_20884_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = this.ridingY * 4.0f;
        p_30642_.m_6034_(this.m_20185_() + extraX, this.m_20186_() + extraY - 1.75, this.m_20189_() + extraZ);
    }

    public void m_7023_(Vec3 p_30633_) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.m_217005_() && this.m_6254_()) {
                LivingEntity livingentity = this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.f_30524_ = 0;
                }
                if (this.m_20096_() && this.f_30522_ == 0.0f && this.m_30622_() && !this.allowStandSliding) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.f_30522_ > 0.0f && !this.m_30616_() && this.m_20096_()) {
                    double d1 = 0.0;
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.f_19812_ = true;
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.f_30522_), 0.0, (double)(0.4f * f3 * this.f_30522_)));
                    }
                    this.f_30522_ = 0.0f;
                }
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, p_30633_.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    this.f_30522_ = 0.0f;
                    this.m_30655_(false);
                }
                this.m_267651_(false);
                this.m_146872_();
            } else {
                super.m_7023_(p_30633_);
            }
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.TRICERATOPS_SPAWN_EGG.get());
    }

    protected void m_149508_(AgeableMob p_190681_1_, AbstractHorse p_190681_2_) {
        double d0 = this.m_21133_(Attributes.f_22276_);
        p_190681_2_.m_21051_(Attributes.f_22276_).m_22100_(d0);
        double d2 = this.m_21133_(Attributes.f_22279_);
        p_190681_2_.m_21051_(Attributes.f_22279_).m_22100_(d2);
        double d3 = this.m_21172_(Attributes.f_22288_);
        p_190681_2_.m_21051_(Attributes.f_22288_).m_22100_(d3);
    }

    public boolean m_7327_(Entity entityIn) {
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)7);
        return true;
    }

    protected boolean m_5994_(Player player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        Item item = stack.m_41720_();
        if (item == ((Block)PFBlocks.HORSETAIL.get()).m_5456_()) {
            f = 2.0f;
            i = 20;
        } else if (item == ((Block)PFBlocks.TALL_HORSETAIL.get()).m_5456_()) {
            f = 1.0f;
            i = 30;
        } else if (item == ((Block)PFBlocks.OSMUNDA.get()).m_5456_()) {
            f = 20.0f;
            i = 180;
            if (this.m_146764_() == 0 && !this.m_27593_()) {
                flag = true;
                this.m_27595_(player);
            }
        } else if (item == ((Block)PFBlocks.TALL_OSMUNDA.get()).m_5456_()) {
            f = 3.0f;
            i = 60;
        } else if (item == ((Block)PFBlocks.CLUBMOSS.get()).m_5456_()) {
            f = 4.0f;
            i = 60;
        } else if (item == ((Block)PFBlocks.LIVERWORT.get()).m_5456_()) {
            f = 3.0f;
            i = 80;
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().m_5776_()) {
                this.m_146758_(i);
            }
            flag = true;
        }
        return flag;
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Triceratops.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Triceratops.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 10.0f + attackTarget.m_20205_();
        }
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((PathfinderMob)Triceratops.this, 2.0);
        }

        public boolean m_8036_() {
            return !Triceratops.this.m_6162_() && !Triceratops.this.m_6060_() ? false : super.m_8036_();
        }
    }

    public class TriceratopsLookAtGoal
    extends LookAtPlayerGoal {
        Triceratops triceratops;

        public TriceratopsLookAtGoal(Triceratops entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((Mob)entityIn, watchTargetClass, maxDistance);
            this.triceratops = entityIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.triceratops.m_5803_();
        }
    }

    public class TriceratopsRandomLookGoal
    extends RandomLookAroundGoal {
        Triceratops dinosaur;

        public TriceratopsRandomLookGoal(Triceratops entitylivingIn) {
            super((Mob)entitylivingIn);
            this.dinosaur = entitylivingIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.dinosaur.m_5803_();
        }
    }

    public class DinosaurHurtByTargetGoal
    extends HurtByTargetGoal {
        Triceratops dinosaur;

        public DinosaurHurtByTargetGoal(Triceratops dinosaur) {
            super((PathfinderMob)dinosaur, new Class[0]);
            this.dinosaur = dinosaur;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.dinosaur.getTrustedUUIDs() != null && this.dinosaur.trusts(this.f_26137_.m_20148_())) {
                this.dinosaur.removeTrustedUUID(this.f_26137_.m_20148_());
            }
            if (this.dinosaur.m_6162_()) {
                this.m_26047_();
                this.m_8041_();
            }
        }

        protected void alertOther(Mob mobIn, DinosaurEntity targetIn) {
            if (!mobIn.m_6162_()) {
                super.m_5766_(mobIn, (LivingEntity)targetIn);
            }
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        public AttackPlayerGoal() {
            super((Mob)Triceratops.this, Player.class, 20, true, true, (Predicate)null);
        }

        public boolean m_8036_() {
            if (Triceratops.this.m_6162_() && !Triceratops.this.isJuvenile() || Triceratops.this.m_30614_()) {
                return false;
            }
            if (super.m_8036_()) {
                for (Triceratops triceratops : Triceratops.this.m_9236_().m_45976_(Triceratops.class, Triceratops.this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                    if (triceratops.trusts(this.f_26050_.m_20148_()) || !triceratops.isProtective() && !triceratops.isTerritorial() || Triceratops.this.m_5448_() == null || !triceratops.m_6162_() || triceratops.isJuvenile()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }

    public class TriceratopsTerritorialAttackGoal
    extends NearestAttackableTargetGoal<Player> {
        Triceratops dinosaur;

        public TriceratopsTerritorialAttackGoal(Triceratops dinosaur) {
            super((Mob)dinosaur, Player.class, true, true);
            this.dinosaur = dinosaur;
        }

        public boolean m_8036_() {
            if (this.dinosaur.m_6162_()) {
                return false;
            }
            if (super.m_8036_()) {
                for (Triceratops dinosaur : this.dinosaur.m_9236_().m_45976_(Triceratops.class, this.dinosaur.m_20191_().m_82377_(24.0, 4.0, 24.0))) {
                    if (dinosaur.trusts(this.f_26050_.m_20148_()) || !dinosaur.isTerritorial() || dinosaur.m_30614_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }

    public class TriceratopsAggressiveTempermentAttackGoal
    extends NearestAttackableTargetGoal<Player> {
        Triceratops dinosaur;

        public TriceratopsAggressiveTempermentAttackGoal(Triceratops dinosaur) {
            super((Mob)dinosaur, Player.class, true, true);
            this.dinosaur = dinosaur;
        }

        public boolean m_8036_() {
            if (this.dinosaur.m_6162_()) {
                return false;
            }
            return super.m_8036_() && !this.dinosaur.trusts(this.f_26050_.m_20148_()) && this.dinosaur.m_5912_() && !this.dinosaur.m_30614_();
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }

    static class LayEggGoal
    extends MoveToBlockGoal {
        private final Triceratops triceratops;

        LayEggGoal(Triceratops triceratops, double speedIn) {
            super((PathfinderMob)triceratops, speedIn, 16);
            this.triceratops = triceratops;
        }

        public boolean m_8036_() {
            return this.triceratops.hasEgg() ? super.m_8036_() : false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.triceratops.hasEgg();
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockpos = new BlockPos((Vec3i)this.triceratops.m_20183_());
            Random random = new Random();
            if (!this.triceratops.m_20069_() && this.m_25625_()) {
                if (this.triceratops.isDigging < 1) {
                    this.triceratops.setDigging(true);
                } else if (this.triceratops.isDigging > 200) {
                    Level world = this.triceratops.m_9236_();
                    world.m_5594_((Player)null, blockpos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.m_188501_() * 0.2f);
                    world.m_7731_(blockpos, (BlockState)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(random.nextInt(4) + 1)), 0);
                    this.triceratops.setHasEgg(false);
                    this.triceratops.setDigging(false);
                    this.triceratops.m_27601_(600);
                }
                if (this.triceratops.isDigging()) {
                    ++this.triceratops.isDigging;
                }
            }
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            if (!worldIn.m_46859_(pos.m_7494_())) {
                return false;
            }
            Block block = worldIn.m_8055_(pos).m_60734_();
            BlockState state = worldIn.m_8055_(pos);
            return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50599_ || block == Blocks.f_50195_ || block == Blocks.f_49992_ || block == Blocks.f_49993_ || block == PFBlocks.MOSSY_DIRT.get() || block == PFBlocks.MOSS_BLOCK.get() || block == PFBlocks.LOAM.get() || block == PFBlocks.PACKED_LOAM.get() || block == PFBlocks.SILT.get() || block == PFBlocks.PACKED_LOAM.get() || state.m_204336_(BlockTags.f_13035_);
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final Triceratops triceratops;
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
        private int breedDelay;
        private final double moveSpeed;

        MateGoal(Triceratops triceratops, double speed) {
            super((Animal)triceratops, speed);
            this.triceratops = triceratops;
            this.moveSpeed = speed;
        }

        @Nullable
        private Triceratops getNearbyMate() {
            List list = this.f_25114_.m_45971_(Triceratops.class, PARTNER_TARGETING, (LivingEntity)this.f_25113_, this.f_25113_.m_20191_().m_82400_(24.0));
            double d0 = Double.MAX_VALUE;
            Triceratops animalentity = null;
            for (Triceratops animalentity1 : list) {
                if (!this.f_25113_.m_7848_((Animal)animalentity1) || !(this.f_25113_.m_20280_((Entity)animalentity1) < d0)) continue;
                animalentity = animalentity1;
                d0 = this.f_25113_.m_20280_((Entity)animalentity1);
            }
            return animalentity;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.triceratops.hasEgg() && !this.triceratops.isLoveNaturally();
        }

        public void m_8041_() {
            this.f_25115_ = null;
            this.breedDelay = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            this.f_25113_.m_21563_().m_24960_((Entity)this.f_25115_, 10.0f, (float)this.f_25113_.m_8132_());
            this.f_25113_.m_21573_().m_5624_((Entity)this.f_25115_, this.moveSpeed);
            ++this.breedDelay;
            if (this.breedDelay >= 60 && this.f_25113_.m_20280_((Entity)this.f_25115_) < 20.0) {
                this.m_8026_();
            }
        }

        protected void m_8026_() {
            ServerPlayer serverPlayer = this.f_25113_.m_27592_();
            if (serverPlayer == null && this.f_25115_.m_27592_() != null) {
                serverPlayer = this.f_25115_.m_27592_();
            }
            if (serverPlayer != null) {
                serverPlayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverPlayer, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.triceratops.setHasEgg(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource randomom = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), randomom.m_188503_(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final Triceratops triceratops;

        NaturalMateGoal(Triceratops triceratops, double speed) {
            super((Animal)triceratops, speed);
            this.triceratops = triceratops;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.triceratops.hasEgg() && this.triceratops.getCurrentHunger() >= this.triceratops.getThreeQuartersHunger() && this.triceratops.f_19797_ % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.triceratops.isLoveNaturally();
        }

        protected void m_8026_() {
            if (PrehistoricFaunaConfig.naturalEggItemLaying) {
                this.triceratops.m_5496_(SoundEvents.f_11752_, 1.0f, (this.triceratops.f_19796_.m_188501_() - this.triceratops.f_19796_.m_188501_()) * 0.2f + 1.0f);
                int eggAmount = this.triceratops.f_19796_.m_188503_(4);
                if (eggAmount == 0) {
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                }
                if (eggAmount == 1) {
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                }
                if (eggAmount == 2) {
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                }
                if (eggAmount == 3) {
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                    this.triceratops.m_19998_((ItemLike)((Block)PFBlocks.TRICERATOPS_EGG.get()).m_5456_());
                }
            } else {
                this.triceratops.setHasEgg(true);
            }
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
        }
    }

    public class CathemeralSleepGoal
    extends Goal {
        public Triceratops entity;
        private int sleepTimer = 0;

        public CathemeralSleepGoal(Triceratops sleeper) {
            this.entity = sleeper;
        }

        public boolean m_8036_() {
            for (Player player : this.entity.m_9236_().m_45976_(Player.class, this.entity.m_20191_().m_82377_(1.0, 1.0, 1.0))) {
                if (player.m_6144_()) continue;
                return false;
            }
            PrehistoricFaunaConfig.sleeping = this.entity.m_217043_().m_188503_(1000) == 0 && this.entity.m_21188_() == null && !this.entity.m_30614_() && this.entity.getRidingPlayer() == null && !this.entity.m_20069_() && !this.entity.m_20077_() && !PrehistoricFaunaConfig.unscheduledSleeping && this.entity.warryTicks == 0;
            return PrehistoricFaunaConfig.sleeping;
        }

        public boolean m_8045_() {
            Iterator iterator = this.entity.m_9236_().m_45976_(Player.class, this.entity.m_20191_().m_82377_(1.0, 1.0, 1.0)).iterator();
            if (iterator.hasNext()) {
                Player player = (Player)iterator.next();
                if (!player.m_6144_()) {
                    this.m_8041_();
                    return false;
                }
                return this.sleepTimer >= 6000 || this.entity.m_21188_() != null || this.entity.m_30614_() || this.entity.getRidingPlayer() != null || !super.m_8045_() || this.entity.m_20069_() || this.entity.m_20077_();
            }
            if (this.sleepTimer >= 6000 || this.entity.m_21188_() != null || this.entity.m_30614_() || this.entity.getRidingPlayer() != null || !super.m_8045_() || this.entity.m_20069_() || this.entity.m_20077_()) {
                this.m_8041_();
                return false;
            }
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.sleepTimer;
            this.entity.m_21573_().m_26573_();
            for (Player player : this.entity.m_9236_().m_45976_(Player.class, this.entity.m_20191_().m_82377_(1.0, 1.0, 1.0))) {
                if (player.m_6144_()) continue;
                this.m_8041_();
            }
            if (this.sleepTimer >= 6000 || this.entity.m_21188_() != null || this.entity.m_30614_() || this.entity.getRidingPlayer() != null || super.m_8045_() || this.entity.m_20069_() || this.entity.m_20077_()) {
                this.m_8041_();
            }
        }

        public void m_8056_() {
            this.sleepTimer = 0;
            this.entity.setSleeping(true);
            this.entity.f_20900_ = 0.0f;
            this.entity.f_20901_ = 0.0f;
            this.entity.f_20902_ = 0.0f;
            this.entity.m_21573_().m_26573_();
            Triceratops.this.setFallingAsleep();
            this.entity.m_20334_(0.0, 0.0, 0.0);
        }

        public void m_8041_() {
            this.sleepTimer = 0;
            this.entity.setAwakeTicks(100);
            this.entity.setSleeping(false);
            Triceratops.this.setFallingAsleep();
        }
    }

    public class UnscheduledSleepingGoal
    extends Goal {
        public Triceratops entity;
        private int sleepTimer = 0;

        public UnscheduledSleepingGoal(Triceratops sleeper) {
            this.entity = sleeper;
        }

        public boolean m_8036_() {
            Level level = this.entity.m_9236_();
            List list = level.m_45976_(Player.class, this.entity.m_20191_().m_82377_(1.0, 1.0, 1.0));
            PrehistoricFaunaConfig.unscheduledSleeping = this.entity.m_217043_().m_188503_(1000) == 0 && this.entity.m_21188_() == null && this.entity.m_5448_() == null && !this.entity.m_20069_() && !this.entity.m_20077_() && !list.isEmpty();
            return PrehistoricFaunaConfig.unscheduledSleeping;
        }

        public boolean m_8045_() {
            Level level = this.entity.m_9236_();
            List list = level.m_45976_(Player.class, this.entity.m_20191_().m_82377_(1.0, 1.0, 1.0));
            if (this.sleepTimer >= 6000 || this.entity.m_21188_() != null || this.entity.m_5448_() != null || super.m_8045_() || this.entity.m_20069_() || this.entity.m_20077_() || !list.isEmpty()) {
                this.entity.setSleeping(false);
                this.sleepTimer = 0;
                this.m_8041_();
                return false;
            }
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            Level level = this.entity.m_9236_();
            List list = level.m_45976_(Player.class, this.entity.m_20191_().m_82377_(1.0, 1.0, 1.0));
            ++this.sleepTimer;
            if (this.sleepTimer >= 6000 || this.entity.m_21188_() != null || this.entity.m_5448_() != null || this.entity.m_20069_() || this.entity.m_20077_() || !list.isEmpty()) {
                this.entity.setSleeping(false);
                this.sleepTimer = 0;
                this.m_8041_();
            }
        }

        public void m_8056_() {
            this.sleepTimer = 0;
            this.entity.setSleeping(true);
            this.entity.f_20900_ = 0.0f;
            this.entity.f_20901_ = 0.0f;
            this.entity.f_20902_ = 0.0f;
            this.entity.m_21573_().m_26573_();
            this.entity.m_6001_(0.0, 0.0, 0.0);
        }

        public void m_8041_() {
            this.sleepTimer = 0;
            this.entity.setSleeping(false);
        }
    }

    public class HerbivoreEatGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HerbivoreEatGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((PathfinderMob)Triceratops.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean shouldMove() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.m_8055_(pos);
            return blockstate.m_204336_(PFTags.PLANTS_2_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_4_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_6_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_8_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_10_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_12_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_15_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_20_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_25_HUNGER) || blockstate.m_204336_(PFTags.PLANTS_30_HUNGER);
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    Triceratops.this.m_30661_(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    Triceratops.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_11990_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
            if (Triceratops.this.getCurrentHunger() >= 13) {
                Triceratops.this.m_30661_(false);
            }
            super.m_8037_();
        }

        protected void eatBerry() {
            int hunger;
            BlockState blockstate = Triceratops.this.m_9236_().m_8055_(this.f_25602_);
            if (blockstate.m_204336_(PFTags.PLANTS_2_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 2 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 2);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_4_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 4 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 4);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_6_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 6 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 6);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_8_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 8 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 8);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_10_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 10 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 10);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_12_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 12 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 12);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_15_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 15 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 15);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_20_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 20 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 20);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_25_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 25 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 25);
                    Triceratops.this.m_30661_(false);
                }
            }
            if (blockstate.m_204336_(PFTags.PLANTS_30_HUNGER)) {
                hunger = Triceratops.this.getCurrentHunger();
                if (hunger + 30 >= Triceratops.this.maxHunger) {
                    Triceratops.this.setHunger(Triceratops.this.maxHunger);
                    Triceratops.this.m_30661_(false);
                } else {
                    Triceratops.this.setHunger(hunger + 30);
                    Triceratops.this.m_30661_(false);
                }
            }
        }

        public boolean m_8036_() {
            return !Triceratops.this.m_5803_() && super.m_8036_() && Triceratops.this.getCurrentHunger() < Triceratops.this.getHalfHunger();
        }

        public boolean m_8045_() {
            if (Triceratops.this.getCurrentHunger() >= Triceratops.this.maxHunger || Triceratops.this.m_5803_()) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            this.field_220731_g = 0;
            super.m_8056_();
        }
    }

    public class EatFromFeederGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public EatFromFeederGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((PathfinderMob)Triceratops.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean shouldMove() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.m_8055_(pos);
            return blockstate.m_60734_() instanceof FeederBlock && (Boolean)blockstate.m_61143_((Property)FeederBlock.PLANT) == true;
        }

        protected BlockPos m_6669_() {
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122012_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122012_())) {
                return this.f_25602_.m_122012_();
            }
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122019_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122019_())) {
                return this.f_25602_.m_122019_();
            }
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122029_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122029_())) {
                return this.f_25602_.m_122029_();
            }
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122024_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122024_())) {
                return this.f_25602_.m_122024_();
            }
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122012_().m_122029_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122012_().m_122029_())) {
                return this.f_25602_.m_122012_().m_122029_();
            }
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122012_().m_122024_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122012_().m_122024_())) {
                return this.f_25602_.m_122012_().m_122024_();
            }
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122019_().m_122029_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122019_().m_122029_())) {
                return this.f_25602_.m_122019_().m_122029_();
            }
            if (!Triceratops.this.m_9236_().m_8055_(this.f_25602_.m_122019_().m_122024_()).m_60838_((BlockGetter)Triceratops.this.m_9236_(), this.f_25602_.m_122019_().m_122024_())) {
                return this.f_25602_.m_122019_().m_122024_();
            }
            return this.f_25602_.m_7494_();
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.field_220731_g >= 20) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                    Triceratops.this.m_30661_(true);
                }
                if (this.field_220731_g % 5 == 1) {
                    Triceratops.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_11990_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
            if (Triceratops.this.getCurrentHunger() >= 13) {
                Triceratops.this.m_30661_(false);
            }
            super.m_8037_();
        }

        protected void eatBerry() {
            int missingHunger = Triceratops.this.maxHunger - Triceratops.this.getCurrentHunger();
            int hunger = Triceratops.this.getCurrentHunger();
            FeederBlock block = (FeederBlock)Triceratops.this.m_9236_().m_8055_(this.f_25602_).m_60734_();
            int foodContained = block.getFoodAmount(Triceratops.this.m_9236_(), this.f_25602_);
            if (missingHunger <= foodContained) {
                block.setFoodAmount(foodContained - missingHunger, Triceratops.this.m_9236_(), this.f_25602_);
                Triceratops.this.setHunger(Triceratops.this.maxHunger);
                Triceratops.this.m_30661_(false);
            } else if (foodContained - missingHunger < 0) {
                block.setFoodAmount(0, Triceratops.this.m_9236_(), this.f_25602_);
                Triceratops.this.setHunger(hunger + foodContained);
                Triceratops.this.m_30661_(false);
            }
        }

        public boolean m_8036_() {
            return !Triceratops.this.m_5803_() && super.m_8036_() && Triceratops.this.getCurrentHunger() < Triceratops.this.getHalfHunger();
        }

        public void m_8041_() {
            super.m_8041_();
            Triceratops.this.m_30661_(false);
        }

        public boolean m_8045_() {
            if (Triceratops.this.getCurrentHunger() >= Triceratops.this.maxHunger || Triceratops.this.m_5803_()) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            this.field_220731_g = 0;
            super.m_8056_();
        }
    }

    class TriceratopsFollowParentGoal
    extends Goal {
        private final Triceratops babyTriceratops;
        private Triceratops parentTriceratops;
        private final double moveSpeed;
        private int delayCounter;

        public TriceratopsFollowParentGoal(Triceratops triceratops, double speed) {
            this.babyTriceratops = triceratops;
            this.moveSpeed = speed;
        }

        public boolean m_8036_() {
            if (this.babyTriceratops.m_6162_() && !this.babyTriceratops.isJuvenile()) {
                List list = this.babyTriceratops.m_9236_().m_45976_(((Object)((Object)this.babyTriceratops)).getClass(), this.babyTriceratops.m_20191_().m_82377_(8.0, 4.0, 8.0));
                Triceratops triceratopsEntity = null;
                double d0 = Double.MAX_VALUE;
                for (Triceratops triceratopsEntity1 : list) {
                    double d1;
                    if (triceratopsEntity1.m_6162_() || (d1 = this.babyTriceratops.m_20280_((Entity)triceratopsEntity1)) > d0) continue;
                    d0 = d1;
                    triceratopsEntity = triceratopsEntity1;
                }
                if (triceratopsEntity == null) {
                    return false;
                }
                if (d0 < 9.0) {
                    return false;
                }
                this.parentTriceratops = triceratopsEntity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!this.babyTriceratops.isJuvenile() || !this.babyTriceratops.m_6162_()) {
                return false;
            }
            if (!this.parentTriceratops.m_6084_()) {
                return false;
            }
            if (this.babyTriceratops.m_6162_() && !this.babyTriceratops.isJuvenile()) {
                double d0 = this.babyTriceratops.m_20280_((Entity)this.parentTriceratops);
                return !(d0 < 9.0) && !(d0 > 256.0);
            }
            return false;
        }

        public void m_8056_() {
            this.delayCounter = 0;
        }

        public void m_8041_() {
            this.parentTriceratops = null;
        }

        public void m_8037_() {
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                this.babyTriceratops.m_21573_().m_5624_((Entity)this.parentTriceratops, this.moveSpeed);
            }
        }
    }
}

