/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.HerdDinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.AggressiveTempermentAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFDamageSources;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Edmontosaurus
extends HerdDinosaurEntity {
    private static final EntityDataAccessor<Boolean> IS_JUVENILE = SynchedEntityData.m_135353_(Edmontosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int warningSoundTicks = 200;
    private static final Map<LivingEntity, BlockPos> previousPositions = new HashMap<LivingEntity, BlockPos>();
    public int maxHunger = 250;

    public Edmontosaurus(EntityType<? extends Edmontosaurus> p_21803_, Level p_21804_) {
        super((EntityType<? extends HerdDinosaurEntity>)p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((HerdDinosaurEntity)this).maxHunger = this.maxHunger;
    }

    @Override
    public double moveToRange() {
        return 15.0;
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            if (!this.isAsleep() || !this.m_6162_()) {
                this.m_5496_(soundevent, this.m_6121_() * 4.0f, this.m_6100_());
            }
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public boolean isJuvenile() {
        return (Boolean)this.f_19804_.m_135370_(IS_JUVENILE);
    }

    public void setJuvenile(boolean isJuvenile) {
        this.f_19804_.m_135381_(IS_JUVENILE, (Object)isJuvenile);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.OSMUNDA.get()).m_5456_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurHurtByTargetGoal(this).m_26044_(new Class[]{Edmontosaurus.class}));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AggressiveTempermentAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.EDMONTOSAURUS_AVOIDING)));
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.EDMONTOSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.EDMONTOSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.EDMONTOSAURUS_DEATH.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, 6.0);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() < -24000) {
            this.m_21051_(Attributes.f_22276_).m_22100_(25.0);
        } else if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.setJuvenile(true);
            this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
        } else if (this.m_146764_() >= 0) {
            this.setJuvenile(false);
            this.m_21051_(Attributes.f_22276_).m_22100_(100.0);
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.EDMONTOSAURUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.EDMONTOSAURUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.edmontosaurus_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_JUVENILE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsJuvenile", this.isJuvenile());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setJuvenile(compound.m_128471_("IsJuvenile"));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        this.setHerbivorous(true);
        if (temperment < 80) {
            this.setProtective(true);
        } else if (temperment > 95) {
            this.m_21561_(true);
        } else {
            this.setTerritorial(true);
        }
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.EDMONTOSAURUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.EDMONTOSAURUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Edmontosaurus entity = new Edmontosaurus((EntityType<? extends Edmontosaurus>)((EntityType)PFEntities.EDMONTOSAURUS.get()), this.m_9236_());
        entity.m_146762_(-48000);
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.EDMONTOSAURUS_SPAWN_EGG.get());
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_6162_()) {
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(6.0, 0.0, 6.0))) {
                List edmontosaurus = this.m_9236_().m_45976_(Edmontosaurus.class, this.m_20191_().m_82377_(6.0, 0.0, 6.0));
                if (!edmontosaurus.isEmpty()) continue;
                this.m_6710_((LivingEntity)player);
            }
            for (DinosaurEntity dinosaur : this.m_9236_().m_45976_(DinosaurEntity.class, this.m_20191_().m_82377_(6.0, 0.0, 6.0))) {
                if (!dinosaur.isCarnivorous()) continue;
                this.playWarningSound();
            }
            if (PrehistoricFaunaConfig.sauropodTrampling) {
                BlockPos currentPosition = new BlockPos((int)this.m_20182_().m_7096_(), (int)this.m_20182_().m_7098_(), (int)this.m_20182_().m_7094_());
                BlockPos previousPosition = previousPositions.getOrDefault((Object)this, currentPosition);
                if (!previousPosition.equals((Object)currentPosition)) {
                    for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(1.0, 0.0, 1.0))) {
                        if (entity instanceof Edmontosaurus || !(entity.m_21233_() < 60.0f)) continue;
                        entity.m_6469_(PFDamageSources.causeSauropodTramplingDamage(entity.m_9236_().m_9598_(), (Entity)this), 5.0f);
                    }
                }
                previousPositions.clear();
                previousPositions.put((LivingEntity)this, currentPosition);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.EDMONTOSAURUS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Edmontosaurus.this, 1.25, true);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }
}

