/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.CrassostreaOysterBlock;
import superlord.prehistoricfauna.common.entity.BurrowingDinosaur;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.ShellfishEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Didelphodon
extends BurrowingDinosaur {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)PFBlocks.CRASSOSTREA_OYSTER.get()).m_5456_()});
    private int maxHunger = 10;
    public int eatTicks;
    private float interestedAngle;
    private float interestedAngleO;

    public Didelphodon(EntityType<? extends Didelphodon> type, Level level) {
        super(type, level);
        this.m_21553_(true);
        this.m_274367_(1.0f);
        ((BurrowingDinosaur)this).maxHunger = this.maxHunger;
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)item);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.175f;
        }
        return 0.35f;
    }

    protected void updateEquipmentIfNeeded(ItemEntity item) {
        ItemStack itemstack = item.m_32055_();
        if (this.canEquipItem(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.spawnItem(itemstack.m_41620_(i - 1));
            }
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)item, itemstack.m_41613_());
            item.m_142687_(Entity.RemovalReason.DISCARDED);
            this.eatTicks = 0;
        }
    }

    @Override
    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.DIDELPHODON.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.DIDELPHODON.ordinal()), itemstack);
            p_230254_1_.m_5661_((Component)Component.m_237115_((String)"paleopedia.didelphodon_added"), true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().m_5776_()) {
            boolean flag = this.m_21830_((LivingEntity)p_230254_1_) || this.m_21824_() || item == Items.f_42500_ && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (!this.m_21824_()) {
            if (item == PFItems.CRASSOSTREA_OYSTER.get()) {
                if (!p_230254_1_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_230254_1_)) {
                    this.m_21828_(p_230254_1_);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213475_v(float p_213475_1_) {
        return Mth.m_14179_((float)p_213475_1_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(2.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        }
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_21515_()) {
            ++this.eatTicks;
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEatItem(stack) && this.eatTicks > 100) {
                if (this.m_21824_()) {
                    ItemStack itemStack = stack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    ItemStack openedStack = ((Item)PFItems.RAW_OYSTER.get()).m_7968_();
                    if (!itemStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
                    }
                    this.eatTicks = 0;
                    Random random = new Random();
                    int dropChance = random.nextInt(99);
                    if (dropChance >= 24) {
                        this.spawnItem(openedStack);
                    } else if (PrehistoricFaunaConfig.advancedHunger) {
                        if (this.getCurrentHunger() + 5 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(this.currentHunger + 5);
                        }
                    }
                    itemStack.m_41774_(1);
                } else {
                    ItemStack itemStack = stack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (PrehistoricFaunaConfig.advancedHunger) {
                        if (this.getCurrentHunger() + 5 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(this.currentHunger + 5);
                        }
                    }
                    if (!itemStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
                    }
                    itemStack.m_41774_(1);
                }
            }
        }
        super.m_8107_();
    }

    public boolean canEatItem(ItemStack stack) {
        return stack.m_204117_(PFTags.SHELLFISH_3_HUNGER);
    }

    public boolean canEquipItem(ItemStack stack) {
        return this.canEatItem(stack);
    }

    public int getMaxAir() {
        return 4800;
    }

    protected int determineNextAir(int currentAir) {
        return this.getMaxAir();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.CRASSOSTREA_OYSTER.get()).m_5456_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new SwimGoal());
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new MateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(7, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.DIDELPHODON_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new CarryYoungGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new ShellfishEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.DIDELPHODON_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.DIDELPHODON_BABY_HUNTING)));
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.DIDELPHODON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)PFSounds.DIDELPHODON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.DIDELPHODON_DEATH.get();
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.23);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemStack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vector3d = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.f_19858_ * ((float)Math.PI / 180)).m_82524_(-this.f_19857_ * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vector3d.f_82479_, vector3d.f_82480_ + 0.05, vector3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setSkittish(true);
        } else {
            this.setPassive(true);
        }
        this.setMolluscivorous(true);
        this.setCrepuscular(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Didelphodon entity = new Didelphodon((EntityType<? extends Didelphodon>)((EntityType)PFEntities.DIDELPHODON.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.DIDELPHODON_SPAWN_EGG.get());
    }

    class SwimGoal
    extends FloatGoal {
        public SwimGoal() {
            super((Mob)Didelphodon.this);
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8036_() {
            return Didelphodon.this.m_20069_() && Didelphodon.this.m_204036_(FluidTags.f_13131_) > 0.25 || Didelphodon.this.m_20077_();
        }
    }

    static class MateGoal
    extends BreedGoal {
        private final Didelphodon didelphodon;

        MateGoal(Didelphodon didelphodon, double speed) {
            super((Animal)didelphodon, speed);
            this.didelphodon = didelphodon;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.didelphodon.hasBaby() && !this.didelphodon.isInLoveNaturally();
        }

        protected void m_8026_() {
            ServerPlayer serverplayerentity = this.f_25113_.m_27592_();
            if (serverplayerentity == null && this.f_25115_.m_27592_() != null) {
                serverplayerentity = this.f_25115_.m_27592_();
            }
            if (serverplayerentity != null) {
                serverplayerentity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayerentity, this.f_25113_, this.f_25115_, (AgeableMob)null);
            }
            this.didelphodon.setHasBaby(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource random = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }

    static class NaturalMateGoal
    extends BreedGoal {
        private final Didelphodon didelphodon;

        NaturalMateGoal(Didelphodon didelphodon, double speed) {
            super((Animal)didelphodon, speed);
            this.didelphodon = didelphodon;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.didelphodon.hasBaby() && this.didelphodon.getCurrentHunger() >= this.didelphodon.getThreeQuartersHunger() && this.didelphodon.f_19797_ % 60 == 0 && (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && this.didelphodon.isInLoveNaturally();
        }

        protected void m_8026_() {
            this.didelphodon.setHasBaby(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Didelphodon.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }

    static class CarryYoungGoal
    extends MoveToBlockGoal {
        private final Didelphodon didelphodon;

        CarryYoungGoal(Didelphodon ankylosaurus, double speedIn) {
            super((PathfinderMob)ankylosaurus, speedIn, 16);
            this.didelphodon = ankylosaurus;
        }

        public boolean m_8036_() {
            return this.didelphodon.hasBaby() ? super.m_8036_() : false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.didelphodon.hasBaby();
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.didelphodon.m_20069_() && this.m_25625_()) {
                if (this.didelphodon.isBirthing < 1) {
                    this.didelphodon.setBirthing(true);
                } else if (this.didelphodon.isBirthing > 200) {
                    Level level = this.didelphodon.m_9236_();
                    int amount = level.f_46441_.m_188503_(4) + 1;
                    for (int i = 0; i < amount; ++i) {
                        Didelphodon baby = new Didelphodon((EntityType<? extends Didelphodon>)((EntityType)PFEntities.DIDELPHODON.get()), level);
                        baby.m_146762_(-24000);
                        baby.m_6034_(this.didelphodon.m_20185_(), this.didelphodon.m_20186_(), this.didelphodon.m_20189_());
                        level.m_7967_((Entity)baby);
                    }
                    this.didelphodon.setHasBaby(false);
                    this.didelphodon.setBirthing(false);
                    this.didelphodon.m_27601_(600);
                }
                if (this.didelphodon.isBirthing()) {
                    ++this.didelphodon.isBirthing;
                }
            }
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            if (!worldIn.m_46859_(pos.m_7494_())) {
                return false;
            }
            Block block = worldIn.m_8055_(pos).m_60734_();
            BlockState state = worldIn.m_8055_(pos);
            return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50546_ || block == Blocks.f_50599_ || block == Blocks.f_50195_ || block == Blocks.f_49992_ || block == Blocks.f_49993_ || block == PFBlocks.MOSSY_DIRT.get() || block == PFBlocks.MOSS_BLOCK.get() || block == PFBlocks.LOAM.get() || block == PFBlocks.PACKED_LOAM.get() || block == PFBlocks.SILT.get() || block == PFBlocks.PACKED_LOAM.get() || state.m_204336_(BlockTags.f_13035_);
        }
    }

    public class EatBerriesGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public EatBerriesGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((PathfinderMob)Didelphodon.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean shouldMove() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.m_8055_(pos);
            return blockstate.m_60713_((Block)PFBlocks.CRASSOSTREA_OYSTER.get()) && (Integer)blockstate.m_61143_((Property)CrassostreaOysterBlock.AGE) >= 2;
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.field_220731_g >= 40) {
                    this.eatOyster();
                } else {
                    ++this.field_220731_g;
                }
            } else if (this.m_25625_() || Didelphodon.this.f_19796_.m_188501_() < 0.05f) {
                // empty if block
            }
            super.m_8037_();
        }

        protected void eatOyster() {
            BlockState blockstate;
            if (ForgeEventFactory.getMobGriefingEvent((Level)Didelphodon.this.m_9236_(), (Entity)Didelphodon.this) && (blockstate = Didelphodon.this.m_9236_().m_8055_(this.f_25602_)).m_60713_((Block)PFBlocks.CRASSOSTREA_OYSTER.get())) {
                int i = (Integer)blockstate.m_61143_((Property)CrassostreaOysterBlock.AGE);
                blockstate.m_61124_((Property)CrassostreaOysterBlock.AGE, (Comparable)Integer.valueOf(0));
                int j = 1 + Didelphodon.this.m_217043_().m_188503_(2) + (i == 3 ? 1 : 0);
                ItemStack itemstack = Didelphodon.this.m_6844_(EquipmentSlot.MAINHAND);
                if (itemstack.m_41619_()) {
                    Didelphodon.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)PFItems.CRASSOSTREA_OYSTER.get()));
                    --j;
                }
                if (j > 0) {
                    Block.m_49840_((Level)Didelphodon.this.m_9236_(), (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)PFItems.CRASSOSTREA_OYSTER.get(), j));
                }
                Didelphodon.this.m_9236_().m_7731_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)CrassostreaOysterBlock.AGE, (Comparable)Integer.valueOf(0)), 2);
            }
        }

        public boolean m_8036_() {
            return !Didelphodon.this.m_5803_() && super.m_8036_();
        }

        public void m_8056_() {
            this.field_220731_g = 0;
            super.m_8056_();
        }
    }

    abstract class PassiveGoal
    extends Goal {
        private PassiveGoal() {
        }

        public abstract boolean canDidelphodonStart();

        public abstract boolean canDidelphodonContinue();

        public boolean m_8036_() {
            return this.canDidelphodonStart();
        }

        public boolean m_8045_() {
            return this.canDidelphodonContinue();
        }
    }
}

