/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.AggressiveTempermentAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CrepuscularSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HostileCarnivoreGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Dakotaraptor
extends DinosaurEntity {
    private static final EntityDataAccessor<Byte> DAKOTARAPTOR_FLAGS = SynchedEntityData.m_135353_(Dakotaraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(Dakotaraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final Predicate<LivingEntity> IS_PREY = p_213498_0_ -> p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_3_HUNGER) || p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_4_HUNGER) || p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_6_HUNGER) || p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_8_HUNGER) || p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_10_HUNGER) || p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_15_HUNGER) || p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_20_HUNGER) || p_213498_0_.m_6095_().m_204039_(PFTags.ANIMALS_30_HUNGER);
    public static final EntityDataAccessor<Integer> SIT_TICK = SynchedEntityData.m_135353_(Dakotaraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float interestedAngle;
    private float interestedAngleO;
    private float crouchAmount;
    private float crouchAmountO;
    private int warningSoundTicks;
    private int eatTicks;
    private int maxHunger = 75;
    private int climbingTicks = 0;
    private int climbingTickCooldown = 0;
    private float sitProgress = 0.0f;
    private float prevSitProgress = 0.0f;

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.RAW_SMALL_ORNITHISCHIAN_MEAT.get();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    public Dakotaraptor(EntityType<? extends Dakotaraptor> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new LookHelperController();
        this.f_21342_ = new MoveHelperController();
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAKOTARAPTOR_FLAGS, (Object)0);
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(SIT_TICK, (Object)0);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(4, (Goal)new HuntGoal(this, LivingEntity.class, 10, false, false, p_213498_0_ -> p_213498_0_.m_6095_().m_204039_(PFTags.DAKOTARAPTOR_HUNTING)));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JumpGoal());
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal());
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AggressiveTempermentAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowTargetGoal());
        this.f_21345_.m_25352_(1, (Goal)new PounceGoal());
        this.f_21345_.m_25352_(6, (Goal)new FindShelterGoal(1.25));
        this.f_21345_.m_25352_(7, (Goal)new BiteGoal(1.2f, true));
        this.f_21345_.m_25352_(7, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(8, (Goal)new FollowGoal(this, 1.25));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(10, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(11, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(13, (Goal)new SitAndLookGoal());
        this.f_21346_.m_25352_(0, (Goal)new HostileCarnivoreGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.DAKOTARAPTOR_AVOIDING)));
        this.f_21345_.m_25352_(1, (Goal)new CrepuscularSleepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213498_0_ -> p_213498_0_.m_6095_().m_204039_(PFTags.DAKOTARAPTOR_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213498_0_ -> p_213498_0_.m_6095_().m_204039_(PFTags.DAKOTARAPTOR_HUNTING)));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.DAKOTARAPTOR.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.DAKOTARAPTOR.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.dakotaraptor_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
        }
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            LivingEntity livingentity;
            ItemStack itemstack;
            ++this.eatTicks;
            if (this.isSitting()) {
                this.m_21573_().m_26573_();
            }
            if (this.canEatItem(itemstack = this.m_6844_(EquipmentSlot.MAINHAND))) {
                if (this.eatTicks > 600) {
                    ItemStack itemstack1 = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!itemstack1.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.eatTicks = 0;
                } else if (this.eatTicks > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                }
            }
            if ((livingentity = this.m_5448_()) == null || !livingentity.m_6084_()) {
                this.setCrouching(false);
                this.func_213502_u(false);
            }
        }
        if (this.m_5448_() != null && this.m_20202_() != null && this.m_20202_() == this.m_5448_() && this.f_19797_ % 20 == 0) {
            AttributeInstance iattributeinstance = this.m_21051_(Attributes.f_22281_);
            this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)iattributeinstance.m_22115_());
        }
        if (!this.m_21525_()) {
            if (this.m_5803_() || this.isMovementBlocked()) {
                this.f_20899_ = false;
                this.f_20900_ = 0.0f;
                this.f_20902_ = 0.0f;
            }
            super.m_8107_();
            if (!this.isDakotaraptorAggroed() || this.f_19796_.m_188501_() < 0.05f) {
                // empty if block
            }
        }
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.m_41720_().m_41472_() && itemStackIn.m_41720_().m_41473_().m_38746_() && this.m_5448_() == null && this.m_20096_() && !this.m_5803_();
    }

    protected boolean isMovementBlocked() {
        return this.m_21223_() <= 0.0f;
    }

    public boolean canEquipItem(ItemStack stack) {
        Item item = stack.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() || this.eatTicks > 0 && item.m_41472_();
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stackIn);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stackIn);
        this.m_9236_().m_7967_((Entity)itementity);
    }

    protected void m_7581_(ItemEntity item) {
        ItemStack itemstack = item.m_32055_();
        if (this.canEquipItem(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)item, itemstack.m_41613_());
            item.m_142687_(Entity.RemovalReason.DISCARDED);
            this.eatTicks = 0;
        }
    }

    protected void setEquipmentBasedOnDifficulty(DifficultyInstance difficulty) {
        if (this.f_19796_.m_188501_() < 0.2f) {
            float f = this.f_19796_.m_188501_();
            ItemStack itemstack = f < 0.05f ? new ItemStack((ItemLike)Items.f_42616_) : (f < 0.2f ? new ItemStack((ItemLike)Items.f_42521_) : (f < 0.4f ? (this.f_19796_.m_188499_() ? new ItemStack((ItemLike)Items.f_42648_) : new ItemStack((ItemLike)Items.f_42649_)) : (f < 0.6f ? new ItemStack((ItemLike)Items.f_42405_) : (f < 0.8f ? new ItemStack((ItemLike)Items.f_42454_) : new ItemStack((ItemLike)Items.f_42402_)))));
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3d = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.f_19858_ * ((float)Math.PI / 180)).m_82524_(-this.f_19857_ * ((float)Math.PI / 180));
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (this.m_5448_() != null && this.m_5448_() == entity && !this.m_20096_() && this.m_20202_() != entity && !(entity instanceof Player)) {
            this.m_20329_(entity);
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setProtective(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.m_21561_(true);
        } else if (temperment >= 95) {
            this.setTerritorial(true);
        }
        this.setCarnivorous(true);
        this.setCrepuscular(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6469_(DamageSource dmg, float i) {
        if (this.m_20202_() != null && this.m_21214_() != null && this.m_21214_() == this.m_20202_() && this.m_217043_().m_188503_(2) == 0) {
            this.m_8127_();
        }
        return super.m_6469_(dmg, i);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsSleeping", this.m_5803_());
        compound.m_128379_("IsSitting", this.isSitting());
        compound.m_128379_("IsCrouching", this.m_6047_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleeping(compound.m_128471_("IsSleeping"));
        this.setSitting(compound.m_128471_("IsSitting"));
        this.setCrouching(compound.m_128471_("IsCrouching"));
    }

    public boolean isSitting() {
        return this.getDakotaraptorFlag(1);
    }

    public void setSitting(boolean p_213466_1_) {
        this.setDakotaraptorFlag(1, p_213466_1_);
        this.f_19804_.m_135381_(SIT_TICK, (Object)15);
    }

    public boolean isStuck() {
        return this.getDakotaraptorFlag(64);
    }

    private void setStuck(boolean p_213492_1_) {
        this.setDakotaraptorFlag(64, p_213492_1_);
    }

    private boolean isDakotaraptorAggroed() {
        return this.getDakotaraptorFlag(128);
    }

    private void setDakotaraptorAggroed(boolean p_213482_1_) {
        this.setDakotaraptorFlag(128, p_213482_1_);
    }

    public boolean m_5803_() {
        return this.getDakotaraptorFlag(32);
    }

    public void setSleeping(boolean p_213485_1_) {
        this.setDakotaraptorFlag(32, p_213485_1_);
    }

    private void setDakotaraptorFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.f_19804_.m_135381_(DAKOTARAPTOR_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(DAKOTARAPTOR_FLAGS) | p_213505_1_)));
        } else {
            this.f_19804_.m_135381_(DAKOTARAPTOR_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(DAKOTARAPTOR_FLAGS) & ~p_213505_1_)));
        }
    }

    private boolean getDakotaraptorFlag(int p_213507_1_) {
        return ((Byte)this.f_19804_.m_135370_(DAKOTARAPTOR_FLAGS) & p_213507_1_) != 0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21515_()) {
            boolean flag = this.m_20069_();
            if (flag || this.m_5448_() != null || this.m_9236_().m_46470_()) {
                this.func_213454_em();
            }
            if (flag || this.m_5803_()) {
                this.setSitting(false);
            }
            if (this.isStuck() && this.m_217043_().m_188501_() < 0.2f) {
                BlockPos blockpos = new BlockPos((Vec3i)this.m_20183_());
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                this.m_9236_().m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
            }
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.func_213467_eg() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.m_6047_()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
        if (!this.m_9236_().m_5776_() && this.f_19862_) {
            BlockPos blockpos1 = new BlockPos(this.m_20183_().m_123341_() + 1, this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_());
            BlockPos blockpos2 = new BlockPos(this.m_20183_().m_123341_() - 1, this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_());
            BlockPos blockpos3 = new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_() + 1);
            BlockPos blockpos4 = new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() + 1, this.m_20183_().m_123343_() - 1);
            BlockState blockstate1 = this.m_9236_().m_8055_(blockpos1);
            BlockState blockstate2 = this.m_9236_().m_8055_(blockpos2);
            BlockState blockstate3 = this.m_9236_().m_8055_(blockpos3);
            BlockState blockstate4 = this.m_9236_().m_8055_(blockpos4);
            if (blockstate1.m_204336_(BlockTags.f_13106_) || blockstate1.m_204336_(BlockTags.f_13090_) || blockstate1.m_204336_(BlockTags.f_13095_) || blockstate1.m_204336_(BlockTags.f_13098_) || blockstate1.m_204336_(BlockTags.f_13097_) || blockstate1.m_204336_(BlockTags.f_13096_) || blockstate2.m_204336_(BlockTags.f_13106_) || blockstate2.m_204336_(BlockTags.f_13090_) || blockstate2.m_204336_(BlockTags.f_13095_) || blockstate2.m_204336_(BlockTags.f_13098_) || blockstate2.m_204336_(BlockTags.f_13097_) || blockstate2.m_204336_(BlockTags.f_13096_) || blockstate3.m_204336_(BlockTags.f_13106_) || blockstate3.m_204336_(BlockTags.f_13090_) || blockstate3.m_204336_(BlockTags.f_13095_) || blockstate3.m_204336_(BlockTags.f_13098_) || blockstate3.m_204336_(BlockTags.f_13097_) || blockstate3.m_204336_(BlockTags.f_13096_) || blockstate4.m_204336_(BlockTags.f_13106_) || blockstate4.m_204336_(BlockTags.f_13090_) || blockstate4.m_204336_(BlockTags.f_13095_) || blockstate4.m_204336_(BlockTags.f_13098_) || blockstate4.m_204336_(BlockTags.f_13097_) || blockstate4.m_204336_(BlockTags.f_13096_)) {
                Boolean logBlock = true;
                if (this.climbingTickCooldown == 0 && this.climbingTicks < 600) {
                    this.setBesideClimbableBlock(logBlock);
                    ++this.climbingTicks;
                }
                if (this.climbingTicks >= 599 && this.climbingTickCooldown <= 300) {
                    ++this.climbingTickCooldown;
                }
                if (this.climbingTickCooldown == 300) {
                    this.climbingTicks = 0;
                    this.climbingTickCooldown = 0;
                }
            }
        }
        this.prevSitProgress = this.sitProgress;
        if ((Integer)this.f_19804_.m_135370_(SIT_TICK) > 0) {
            this.f_19804_.m_135381_(SIT_TICK, (Object)((Integer)this.f_19804_.m_135370_(SIT_TICK) - 1));
            if (this.sitProgress < 1.0f) {
                this.sitProgress = Math.min(this.sitProgress + 0.1f, 1.0f);
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress = Math.max(this.sitProgress - 0.2f, 0.0f);
        }
    }

    public float getSitProgress(float partialTick) {
        return this.prevSitProgress + (this.sitProgress - this.prevSitProgress) * partialTick;
    }

    public boolean isOnLadder() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    public boolean func_213480_dY() {
        return this.getDakotaraptorFlag(16);
    }

    public void func_213461_s(boolean p_213461_1_) {
        this.setDakotaraptorFlag(16, p_213461_1_);
    }

    public boolean func_213490_ee() {
        return this.crouchAmount == 3.0f;
    }

    public void setCrouching(boolean p_213451_1_) {
        this.setDakotaraptorFlag(4, p_213451_1_);
    }

    public boolean m_6047_() {
        return this.getDakotaraptorFlag(4);
    }

    public void func_213502_u(boolean p_213502_1_) {
        this.setDakotaraptorFlag(8, p_213502_1_);
    }

    public boolean func_213467_eg() {
        return this.getDakotaraptorFlag(8);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213475_v(float p_213475_1_) {
        return Mth.m_14179_((float)p_213475_1_, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213503_w(float p_213503_1_) {
        return Mth.m_14179_((float)p_213503_1_, (float)this.crouchAmountO, (float)this.crouchAmount);
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.isDakotaraptorAggroed() && entitylivingbaseIn == null) {
            this.setDakotaraptorAggroed(false);
        }
        super.m_6710_(entitylivingbaseIn);
    }

    protected int m_5639_(float p_225508_1_, float p_225508_2_) {
        return Mth.m_14167_((float)((p_225508_1_ - 5.0f) * p_225508_2_));
    }

    private void func_213454_em() {
        this.setSleeping(false);
    }

    private void func_213499_en() {
        this.func_213502_u(false);
        this.setCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setDakotaraptorAggroed(false);
        this.setStuck(false);
    }

    private boolean func_213478_eo() {
        return !this.m_5803_() && !this.isSitting() && !this.isStuck();
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.DAKOTARAPTOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.DAKOTARAPTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.DAKOTARAPTOR_DEATH.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 1.075f;
        }
        return 2.15f;
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.DAKOTARAPTOR_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.1);
    }

    public static boolean func_213481_a(Dakotaraptor p_213481_0_, LivingEntity p_213481_1_) {
        double d0 = p_213481_1_.m_20189_() - p_213481_0_.m_20189_();
        double d1 = p_213481_1_.m_20185_() - p_213481_0_.m_20185_();
        double d2 = d0 / d1;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_213481_0_.m_9236_().m_8055_(new BlockPos((int)p_213481_0_.m_20185_() + (int)d4, (int)p_213481_0_.m_20186_() + k, (int)p_213481_0_.m_20189_() + (int)d3)).m_247087_()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        if (this.m_20096_()) {
            Vec3 vector3d = this.m_20184_();
            Vec3 vector3d1 = new Vec3(entity.m_20185_() - this.m_20185_(), 0.0, entity.m_20189_() - this.m_20189_());
            if (vector3d1.m_82556_() > 1.0E-7) {
                vector3d1 = vector3d1.m_82541_().m_82490_(0.5).m_82549_(vector3d.m_82490_(0.2));
            }
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, entity.m_20299_(1.0f));
            this.m_20334_(vector3d1.f_82479_, 0.4, vector3d1.f_82481_);
        }
        return flag;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Dakotaraptor entity = new Dakotaraptor((EntityType<? extends Dakotaraptor>)((EntityType)PFEntities.DAKOTARAPTOR.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.DAKOTARAPTOR_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.DAKOTARAPTOR_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.DAKOTARAPTOR_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    public class LookHelperController
    extends LookControl {
        public LookHelperController() {
            super((Mob)Dakotaraptor.this);
        }

        public void m_8128_() {
            if (!Dakotaraptor.this.m_5803_()) {
                super.m_8128_();
            }
        }

        protected boolean func_220680_b() {
            return !Dakotaraptor.this.func_213480_dY() && !Dakotaraptor.this.m_6047_() && !Dakotaraptor.this.func_213467_eg() & !Dakotaraptor.this.isStuck();
        }
    }

    class MoveHelperController
    extends MoveControl {
        public MoveHelperController() {
            super((Mob)Dakotaraptor.this);
        }

        public void m_8126_() {
            if (Dakotaraptor.this.func_213478_eo()) {
                super.m_8126_();
            }
        }
    }

    class JumpGoal
    extends Goal {
        int delay;

        public JumpGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Dakotaraptor.this.isStuck();
        }

        public boolean m_8045_() {
            return this.m_8036_() && this.delay > 0;
        }

        public void m_8056_() {
            this.delay = 40;
        }

        public void m_8041_() {
            Dakotaraptor.this.setStuck(false);
        }

        public void m_8037_() {
            --this.delay;
        }
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((PathfinderMob)Dakotaraptor.this, 2.0);
        }

        public boolean m_8036_() {
            return !Dakotaraptor.this.m_6162_() && !Dakotaraptor.this.m_6060_() ? false : super.m_8036_();
        }
    }

    class FollowTargetGoal
    extends Goal {
        public FollowTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (Dakotaraptor.this.m_5803_()) {
                return false;
            }
            LivingEntity livingentity = Dakotaraptor.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && IS_PREY.test(livingentity) && Dakotaraptor.this.m_20280_((Entity)livingentity) > 36.0 && !Dakotaraptor.this.m_6047_() && !Dakotaraptor.this.func_213467_eg() && !Dakotaraptor.this.f_20899_;
        }

        public void m_8056_() {
            Dakotaraptor.this.setSitting(false);
            Dakotaraptor.this.setStuck(false);
        }

        public void m_8041_() {
            LivingEntity livingentity = Dakotaraptor.this.m_5448_();
            if (livingentity != null && Dakotaraptor.func_213481_a(Dakotaraptor.this, livingentity)) {
                Dakotaraptor.this.func_213502_u(true);
                Dakotaraptor.this.setCrouching(true);
                Dakotaraptor.this.m_21573_().m_26573_();
                Dakotaraptor.this.m_21563_().m_24960_((Entity)livingentity, (float)Dakotaraptor.this.m_8085_(), (float)Dakotaraptor.this.m_8132_());
            } else {
                Dakotaraptor.this.func_213502_u(false);
                Dakotaraptor.this.setCrouching(false);
            }
        }

        public void m_8037_() {
            LivingEntity livingentity = Dakotaraptor.this.m_5448_();
            Dakotaraptor.this.m_21563_().m_24960_((Entity)livingentity, (float)Dakotaraptor.this.m_8085_(), (float)Dakotaraptor.this.m_8132_());
            if (Dakotaraptor.this.m_20280_((Entity)livingentity) <= 36.0) {
                Dakotaraptor.this.func_213502_u(true);
                Dakotaraptor.this.setCrouching(true);
                Dakotaraptor.this.m_21573_().m_26573_();
            } else {
                Dakotaraptor.this.m_21573_().m_5624_((Entity)livingentity, 1.5);
            }
        }
    }

    public class PounceGoal
    extends net.minecraft.world.entity.ai.goal.JumpGoal {
        public boolean m_8036_() {
            if (!Dakotaraptor.this.func_213490_ee()) {
                return false;
            }
            LivingEntity livingentity = Dakotaraptor.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (livingentity.m_6374_() != livingentity.m_6350_()) {
                    return false;
                }
                boolean flag = Dakotaraptor.func_213481_a(Dakotaraptor.this, livingentity);
                if (!flag) {
                    Dakotaraptor.this.m_21573_().m_6570_((Entity)livingentity, 0);
                    Dakotaraptor.this.setCrouching(false);
                    Dakotaraptor.this.func_213502_u(false);
                }
                return flag;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = Dakotaraptor.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                double d0 = Dakotaraptor.this.m_20184_().f_82480_;
                return !(d0 * d0 < (double)0.05f && Math.abs(Dakotaraptor.this.f_19858_) < 15.0f && Dakotaraptor.this.m_20096_() || Dakotaraptor.this.isStuck());
            }
            return false;
        }

        public boolean isPreemptible() {
            return false;
        }

        public void m_8056_() {
            Dakotaraptor.this.m_6862_(true);
            Dakotaraptor.this.func_213461_s(true);
            Dakotaraptor.this.func_213502_u(false);
            LivingEntity livingentity = Dakotaraptor.this.m_5448_();
            Dakotaraptor.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
            Vec3 vec3d = new Vec3(livingentity.m_20185_() - Dakotaraptor.this.m_20185_(), livingentity.m_20186_() - Dakotaraptor.this.m_20186_(), livingentity.m_20189_() - Dakotaraptor.this.m_20189_()).m_82541_();
            Dakotaraptor.this.m_20256_(Dakotaraptor.this.m_20184_().m_82520_(vec3d.f_82479_ * 0.8, 0.9, vec3d.f_82481_ * 0.8));
            Dakotaraptor.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Dakotaraptor.this.setCrouching(false);
            Dakotaraptor.this.crouchAmount = 0.0f;
            Dakotaraptor.this.crouchAmountO = 0.0f;
            Dakotaraptor.this.func_213502_u(false);
            Dakotaraptor.this.func_213461_s(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = Dakotaraptor.this.m_5448_();
            if (livingentity != null) {
                Dakotaraptor.this.m_21563_().m_24960_((Entity)livingentity, 60.0f, 30.0f);
            }
            if (!Dakotaraptor.this.isStuck()) {
                Vec3 vec3d = Dakotaraptor.this.m_20184_();
                if (vec3d.f_82480_ * vec3d.f_82480_ < (double)0.03f && Dakotaraptor.this.f_19858_ != 0.0f) {
                    Dakotaraptor.this.f_19858_ = Mth.m_14189_((float)Dakotaraptor.this.f_19858_, (float)0.0f, (float)0.2f);
                } else {
                    double d0 = vec3d.m_165924_();
                    double d1 = Math.signum(-vec3d.f_82480_) * Math.acos(d0 / vec3d.m_82553_()) * 57.2957763671875;
                    Dakotaraptor.this.f_19858_ = (float)d1;
                }
            }
            if (livingentity != null && Dakotaraptor.this.m_20270_((Entity)livingentity) <= 2.0f) {
                Dakotaraptor.this.m_7327_((Entity)livingentity);
            } else if (Dakotaraptor.this.f_19858_ > 0.0f && Dakotaraptor.this.m_20096_() && (float)Dakotaraptor.this.m_20184_().f_82480_ != 0.0f && Dakotaraptor.this.m_9236_().m_8055_(new BlockPos((Vec3i)Dakotaraptor.this.m_20183_())).m_60734_() == Blocks.f_50125_) {
                Dakotaraptor.this.f_19858_ = 60.0f;
                Dakotaraptor.this.m_6710_(null);
            }
        }
    }

    class FindShelterGoal
    extends FleeSunGoal {
        private int cooldown;

        public FindShelterGoal(double p_i50724_2_) {
            super((PathfinderMob)Dakotaraptor.this, p_i50724_2_);
            this.cooldown = 100;
        }

        public boolean m_8036_() {
            if (!Dakotaraptor.this.m_5803_() && this.f_25214_.m_5448_() == null) {
                if (Dakotaraptor.this.m_9236_().m_46470_()) {
                    return true;
                }
                if (this.cooldown > 0) {
                    --this.cooldown;
                    return false;
                }
                this.cooldown = 100;
                BlockPos blockpos = new BlockPos((Vec3i)this.f_25214_.m_20183_());
                return Dakotaraptor.this.m_9236_().m_46461_() && Dakotaraptor.this.m_9236_().m_45527_(blockpos) && !((ServerLevel)Dakotaraptor.this.m_9236_()).m_8802_(blockpos) && this.m_25226_();
            }
            return false;
        }

        public void m_8056_() {
            Dakotaraptor.this.func_213499_en();
            super.m_8056_();
        }
    }

    class BiteGoal
    extends MeleeAttackGoal {
        public BiteGoal(double p_i50731_2_, boolean p_i50731_4_) {
        }

        @Override
        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            }
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8056_() {
            Dakotaraptor.this.func_213502_u(false);
            super.m_8056_();
        }

        public boolean m_8036_() {
            return !Dakotaraptor.this.isSitting() && !Dakotaraptor.this.m_5803_() && !Dakotaraptor.this.m_6047_() && !Dakotaraptor.this.isStuck() && super.m_8036_();
        }
    }

    class SleepGoal
    extends BaseGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = Dakotaraptor.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (Dakotaraptor.this.f_20900_ == 0.0f && Dakotaraptor.this.f_20901_ == 0.0f && Dakotaraptor.this.f_20902_ == 0.0f && !PrehistoricFaunaConfig.sleeping) {
                return this.canSleep() || Dakotaraptor.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return Dakotaraptor.this.m_9236_().m_46461_() && this.hasShelter() && !this.alertable() && !Dakotaraptor.this.f_146808_;
        }

        public void m_8041_() {
            this.countdown = Dakotaraptor.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            Dakotaraptor.this.func_213499_en();
        }

        public void m_8056_() {
            Dakotaraptor.this.setSitting(false);
            Dakotaraptor.this.setCrouching(false);
            Dakotaraptor.this.func_213502_u(false);
            Dakotaraptor.this.m_6862_(false);
            Dakotaraptor.this.setSleeping(true);
            Dakotaraptor.this.m_21573_().m_26573_();
            Dakotaraptor.this.m_21566_().m_6849_(Dakotaraptor.this.m_20185_(), Dakotaraptor.this.m_20186_(), Dakotaraptor.this.m_20189_(), 0.0);
        }
    }

    class FollowGoal
    extends FollowParentGoal {
        private final Dakotaraptor owner;

        public FollowGoal(Dakotaraptor p_i50735_2_, double p_i50735_3_) {
            super((Animal)p_i50735_2_, p_i50735_3_);
            this.owner = p_i50735_2_;
        }

        public boolean m_8036_() {
            return !this.owner.isDakotaraptorAggroed() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.owner.isDakotaraptorAggroed() && super.m_8045_();
        }

        public void m_8056_() {
            this.owner.func_213499_en();
            super.m_8056_();
        }
    }

    class SitAndLookGoal
    extends BaseGoal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Dakotaraptor.this.m_21188_() == null && Dakotaraptor.this.m_217043_().m_188501_() < 0.02f && !Dakotaraptor.this.m_5803_() && Dakotaraptor.this.m_5448_() == null && Dakotaraptor.this.m_21573_().m_26571_() && !this.alertable() && !Dakotaraptor.this.func_213480_dY() && !Dakotaraptor.this.m_6047_();
        }

        public boolean m_8045_() {
            return this.field_220822_f > 0;
        }

        public void m_8056_() {
            this.func_220817_j();
            this.field_220822_f = 2 + Dakotaraptor.this.m_217043_().m_188503_(3);
            Dakotaraptor.this.setSitting(true);
            Dakotaraptor.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Dakotaraptor.this.setSitting(false);
        }

        public void m_8037_() {
            Dakotaraptor.this.m_21573_().m_26573_();
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            Dakotaraptor.this.m_21563_().m_24950_(Dakotaraptor.this.m_20185_() + this.field_220819_c, Dakotaraptor.this.m_20188_(), Dakotaraptor.this.m_20189_() + this.field_220820_d, (float)Dakotaraptor.this.m_8085_(), (float)Dakotaraptor.this.m_8132_());
        }

        private void func_220817_j() {
            double d0 = Math.PI * 2 * Dakotaraptor.this.m_217043_().m_188500_();
            this.field_220819_c = Math.cos(d0);
            this.field_220820_d = Math.sin(d0);
            this.field_220821_e = 80 + Dakotaraptor.this.m_217043_().m_188503_(20);
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Dakotaraptor.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Dakotaraptor.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 5.0f + attackTarget.m_20205_();
        }
    }

    class WatchGoal
    extends LookAtPlayerGoal {
        public WatchGoal(Mob p_i50733_2_, Class<? extends LivingEntity> p_i50733_3_, float p_i50733_4_) {
            super(p_i50733_2_, p_i50733_3_, p_i50733_4_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Dakotaraptor.this.isStuck() && !Dakotaraptor.this.func_213467_eg();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !Dakotaraptor.this.isStuck() && !Dakotaraptor.this.func_213467_eg();
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final TargetingConditions field_220816_b;

        private BaseGoal() {
            this.field_220816_b = TargetingConditions.m_148352_().m_26883_(12.0).m_148355_().m_26888_((Predicate)new AlertablePredicate());
        }

        protected boolean hasShelter() {
            BlockPos blockpos = new BlockPos((Vec3i)Dakotaraptor.this.m_20183_());
            return !Dakotaraptor.this.m_9236_().m_45527_(blockpos) && Dakotaraptor.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !Dakotaraptor.this.m_9236_().m_45971_(LivingEntity.class, this.field_220816_b, (LivingEntity)Dakotaraptor.this, Dakotaraptor.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof Dakotaraptor) {
                return false;
            }
            if (!(p_test_1_ instanceof Chicken || p_test_1_ instanceof Rabbit || p_test_1_ instanceof Monster)) {
                if (p_test_1_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_test_1_).m_21824_();
                }
                if (!(p_test_1_ instanceof Player) || !p_test_1_.m_5833_() && !((Player)p_test_1_).m_7500_()) {
                    return !p_test_1_.m_5803_() && !p_test_1_.m_20163_();
                }
                return false;
            }
            return true;
        }
    }
}

