/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Basilemys;
import superlord.prehistoricfauna.common.entity.goal.AggressiveTempermentAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.HostileCarnivoreGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.PiscivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Brachychampsa
extends DinosaurEntity {
    private int maxHunger = 50;
    private int warningSoundTicks;
    private int grabTicks = 0;
    private int grabCooldownTicks = 0;
    public float ridingXZ;
    public float ridingY = 1.0f;

    public Brachychampsa(EntityType<? extends DinosaurEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new BrachychampsaMoveControl(this);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_6425_(pos.m_7495_()).m_76178_() && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_) ? 10.0f : super.m_5610_(pos, worldIn);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            if (this.m_21515_() && this.m_20069_()) {
                this.m_19920_(this.m_6113_(), travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
                if (this.m_5448_() == null) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                }
                if (this.m_20146_() < this.m_6062_() / 3) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                }
            } else {
                super.m_7023_(travelVector);
            }
        }
    }

    public boolean m_275843_() {
        return false;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.BRACHYCHAMPSA.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.BRACHYCHAMPSA.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.brachychampsa_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    private Vec3 func_234236_a_(Vec3 p_234236_1_, LivingEntity p_234236_2_) {
        double d0 = this.m_20185_() + p_234236_1_.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + p_234236_1_.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : p_234236_2_.m_7431_()) {
            blockpos$mutable.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                double d4 = this.m_9236_().m_45573_((BlockPos)blockpos$mutable);
                if ((double)blockpos$mutable.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4)) {
                    AABB axisalignedbb = p_234236_2_.m_21270_(pose);
                    Vec3 vector3d = new Vec3(d0, (double)blockpos$mutable.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)p_234236_2_, (AABB)axisalignedbb.m_82383_(vector3d))) {
                        p_234236_2_.m_20124_(pose);
                        return vector3d;
                    }
                }
                blockpos$mutable.m_122173_(Direction.UP);
            } while ((double)blockpos$mutable.m_123342_() < d3);
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity living) {
        Vec3 vector3d = Brachychampsa.m_19903_((double)this.m_20205_(), (double)living.m_20205_(), (float)(this.f_19857_ + (living.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vector3d1 = this.func_234236_a_(vector3d, living);
        if (vector3d1 != null) {
            return vector3d1;
        }
        Vec3 vector3d2 = Brachychampsa.m_19903_((double)this.m_20205_(), (double)living.m_20205_(), (float)(this.f_19857_ + (living.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vector3d3 = this.func_234236_a_(vector3d2, living);
        return vector3d3 != null ? vector3d3 : this.m_20182_();
    }

    protected boolean func_212800_dy() {
        return true;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new CathemeralSleepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new GrabAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BrachychampsaPanicGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BrachychampsaGoToWaterGoal(this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new BrachychampsaRandomStrollGoal(this, 1.0, 100));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HostileCarnivoreGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(0, (Goal)new PiscivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(3, (Goal)new SwimGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BrachychampsaHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.BRACHYCHAMPSA_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.BRACHYCHAMPSA_BABY_HUNTING)));
        this.f_21346_.m_25352_(1, (Goal)new BrachychampsaNoHungerHuntGoal(this, LivingEntity.class, 10, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.BRACHYCHAMPSA_HUNTING)));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.BRACHYCHAMPSA_AVOIDING)));
        this.f_21346_.m_25352_(2, (Goal)new AggressiveTempermentAttackGoal(this));
    }

    public boolean m_6063_() {
        return false;
    }

    public static boolean canDinosaurSpawn(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return (worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || worldIn.m_8055_(pos).m_60713_(Blocks.f_49990_) || worldIn.m_8055_(pos.m_7495_()).m_204336_(Tags.Blocks.SAND)) && worldIn.m_45524_(pos, 0) > 8;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.BRACHYCHAMPSA_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.BRACHYCHAMPSA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.BRACHYCHAMPSA_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.m_6162_()) {
            if (!blockIn.m_278721_()) {
                BlockState blockstate = this.m_9236_().m_8055_(pos.m_7494_());
                SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this) : blockIn.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.BRACHYCHAMPSA_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    public int m_6062_() {
        return 4800;
    }

    protected int m_7305_(int p_28389_) {
        return this.m_6062_();
    }

    protected float m_6108_() {
        return 0.95f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.CRASSOSTREA_OYSTER.get();
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
        }
    }

    protected void handleAirSupply(int p_28326_) {
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setTerritorial(true);
        } else if (temperment >= 80) {
            this.m_21561_(true);
        }
        this.setCarnivorous(true);
        this.setPiscivorous(true);
        this.m_20301_(this.m_6062_());
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 5.0);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction p_289531_) {
        super.m_19956_(passenger, p_289531_);
        float radius = this.ridingXZ * 0.7f * -3.0f + 2.0f;
        float angle = (float)Math.PI / 180 * this.f_20884_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = this.m_20069_() ? (double)(this.ridingY * 3.0f) : (double)(this.ridingY * 4.1f);
        ((Entity)this.m_20197_().get(0)).m_6034_(this.m_20185_() + extraX, this.m_20186_() + extraY - 3.75, this.m_20189_() + extraZ);
    }

    public Player getRidingPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        return null;
    }

    public boolean canBeControlledByRider() {
        return this.m_6688_() instanceof Player && this.m_21824_();
    }

    public boolean m_6469_(DamageSource dmg, float i) {
        if (this.m_20160_()) {
            this.m_20153_();
        }
        return super.m_6469_(dmg, i);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21824_() && this.m_146895_() != null) {
            ++this.grabTicks;
            if (this.grabTicks == 100) {
                this.m_146895_().m_8127_();
                this.grabCooldownTicks = 500;
                this.grabTicks = 0;
            }
        }
        if (this.grabCooldownTicks != 0) {
            --this.grabCooldownTicks;
        }
    }

    @Override
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        Brachychampsa entity = new Brachychampsa((EntityType<? extends DinosaurEntity>)((EntityType)PFEntities.BRACHYCHAMPSA.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)level, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.BRACHYCHAMPSA_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.BRACHYCHAMPSA_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.BRACHYCHAMPSA_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    protected PathNavigation m_6037_(Level level) {
        return new BrachychampsaPathNavigation(this, level);
    }

    static class BrachychampsaMoveControl
    extends MoveControl {
        private final Brachychampsa brachychampsa;

        BrachychampsaMoveControl(Brachychampsa brachychampsa) {
            super((Mob)brachychampsa);
            this.brachychampsa = brachychampsa;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.brachychampsa.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.brachychampsa.m_20185_();
                double d1 = this.f_24976_ - this.brachychampsa.m_20186_();
                double d2 = this.f_24977_ - this.brachychampsa.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.brachychampsa.m_146922_(this.m_24991_(this.brachychampsa.m_146908_(), f, 90.0f));
                this.brachychampsa.f_20883_ = this.brachychampsa.m_146908_();
                float f1 = (float)(this.f_24978_ * this.brachychampsa.m_21133_(Attributes.f_22279_));
                this.brachychampsa.m_7910_(Mth.m_14179_((float)0.125f, (float)this.brachychampsa.m_6113_(), (float)f1));
                this.brachychampsa.m_20256_(this.brachychampsa.m_20184_().m_82520_(0.0, (double)this.brachychampsa.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.brachychampsa.m_7910_(0.0f);
            }
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Brachychampsa.this, 1.25, true);
        }

        protected void CheckAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.f_25540_.m_20160_();
        }

        public void m_8037_() {
            super.m_8037_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && (Brachychampsa.this.m_20160_() || Brachychampsa.this.grabCooldownTicks != 0);
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    class GrabAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public GrabAttackGoal() {
            super((PathfinderMob)Brachychampsa.this, 1.25, true);
        }

        protected void CheckAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
            if (enemy.m_20205_() <= 2.0f && Brachychampsa.this.m_20197_().isEmpty()) {
                enemy.m_20329_((Entity)this.f_25540_);
            }
        }

        public boolean m_8045_() {
            return super.m_8045_() && !Brachychampsa.this.m_20160_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Brachychampsa.this.m_20160_() && Brachychampsa.this.grabCooldownTicks == 0;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.f_25540_.m_5448_().m_20205_() < 2.0f && !this.f_25540_.m_20160_()) {
                this.f_25540_.m_5448_().m_20329_((Entity)this.f_25540_);
            }
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class BrachychampsaPanicGoal
    extends BabyPanicGoal {
        BrachychampsaPanicGoal(Brachychampsa brachychampsa) {
            super(brachychampsa);
        }

        @Override
        public boolean m_8036_() {
            if (!this.m_202729_() || !this.f_25684_.m_6162_()) {
                return false;
            }
            BlockPos blockpos = this.m_198172_((BlockGetter)this.f_25684_.m_9236_(), (Entity)this.f_25684_, 7);
            if (blockpos != null) {
                this.f_25686_ = blockpos.m_123341_();
                this.f_25687_ = blockpos.m_123342_();
                this.f_25688_ = blockpos.m_123343_();
                return true;
            }
            return this.m_25702_();
        }
    }

    static class BrachychampsaGoToWaterGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final Brachychampsa brachychampsa;

        BrachychampsaGoToWaterGoal(Brachychampsa brachychampsa, double speed) {
            super((PathfinderMob)brachychampsa, brachychampsa.m_6162_() ? 2.0 : speed, 24);
            this.brachychampsa = brachychampsa;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.brachychampsa.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.brachychampsa.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            if (this.brachychampsa.m_6162_() && !this.brachychampsa.m_20069_()) {
                return super.m_8036_();
            }
            return !this.brachychampsa.m_20069_() && !this.brachychampsa.hasBaby() ? super.m_8036_() : false;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return level.m_8055_(pos).m_60713_(Blocks.f_49990_);
        }
    }

    static class BrachychampsaRandomStrollGoal
    extends RandomStrollGoal {
        private final Brachychampsa brachychampsa;

        BrachychampsaRandomStrollGoal(Brachychampsa brachychampsa, double speed, int interval) {
            super((PathfinderMob)brachychampsa, speed, interval);
            this.brachychampsa = brachychampsa;
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && !this.brachychampsa.hasBaby() ? super.m_8036_() : false;
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final Brachychampsa brachychampsa;

        public SwimGoal(Brachychampsa brachychampsa) {
            super((PathfinderMob)brachychampsa, 1.0, 40);
            this.brachychampsa = brachychampsa;
        }

        public boolean m_8036_() {
            return this.brachychampsa.func_212800_dy() && super.m_8036_();
        }
    }

    class BrachychampsaHuntGoal
    extends NearestAttackableTargetGoal {
        double huntSpeed;
        Predicate<LivingEntity> targetPredicate;
        DinosaurEntity dinosaur;

        public BrachychampsaHuntGoal(DinosaurEntity goalOwnerIn, Class targetClassIn, int targetChanceIn, double huntSpeed, boolean checkSight, @Nullable boolean nearbyOnly, Predicate<LivingEntity> targetPredicate) {
            super((Mob)goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnly, targetPredicate);
            this.huntSpeed = huntSpeed;
            this.targetPredicate = targetPredicate;
            this.dinosaur = goalOwnerIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.dinosaur.getCurrentHunger() <= this.dinosaur.getHalfHunger() && !this.dinosaur.m_6162_() && PrehistoricFaunaConfig.advancedHunger && !this.targetPredicate.test((LivingEntity)this.dinosaur) && !this.dinosaur.trusts(this.f_26050_.m_20148_()) && !this.dinosaur.isOpportunist();
        }

        public boolean m_8045_() {
            return this.dinosaur.getCurrentHunger() < this.dinosaur.maxHunger && PrehistoricFaunaConfig.advancedHunger;
        }

        public void m_8037_() {
            this.dinosaur.m_21573_().m_26517_(this.huntSpeed);
            if (this.dinosaur.m_5448_() != null) {
                LivingEntity target = this.dinosaur.m_5448_();
                if (!target.m_7306_(null)) {
                    if (target.m_6095_().m_204039_(PFTags.INSECTS_2_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 2 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 2);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_3_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 3 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 3);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_4_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 4 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 4);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_6_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 6 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 6);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_8_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 8 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 8);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_10_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 10 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 10);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_15_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 15 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 15);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_20_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 20 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 20);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_30_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 30 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 30);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_40_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 40 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 40);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_60_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 60 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 60);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_80_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 80 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 80);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_100_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 100 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 100);
                        }
                    }
                    if (target.m_6095_().m_204039_(PFTags.ANIMALS_200_HUNGER) && target.m_21223_() == 0.0f) {
                        if (this.dinosaur.getCurrentHunger() + 200 >= this.dinosaur.maxHunger) {
                            this.dinosaur.setHunger(this.dinosaur.maxHunger);
                        } else {
                            this.dinosaur.setHunger(this.dinosaur.currentHunger + 200);
                        }
                    }
                    if ((target instanceof Turtle || target instanceof Basilemys) && target.m_21223_() == 0.0f) {
                        ItemEntity item = new ItemEntity(target.m_9236_(), target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)Items.f_42355_));
                        item.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                        this.dinosaur.m_9236_().m_7967_((Entity)item);
                    }
                } else {
                    this.m_8041_();
                }
            } else {
                this.m_8041_();
            }
            super.m_8037_();
        }
    }

    class BrachychampsaNoHungerHuntGoal
    extends NearestAttackableTargetGoal {
        Predicate<LivingEntity> targetPredicate;
        DinosaurEntity dinosaur;

        public BrachychampsaNoHungerHuntGoal(DinosaurEntity goalOwnerIn, Class targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn, Predicate<LivingEntity> targetPredicate) {
            super((Mob)goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnlyIn, targetPredicate);
            this.targetPredicate = targetPredicate;
            this.dinosaur = goalOwnerIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.f_26135_.m_217043_().m_188503_(249) == 0 && !this.f_26135_.m_6162_() && !PrehistoricFaunaConfig.advancedHunger && !this.targetPredicate.test((LivingEntity)this.f_26135_) && !this.dinosaur.trusts(this.f_26050_.m_20148_());
        }

        public void m_8037_() {
            super.m_8037_();
            if ((this.f_26050_ instanceof Turtle || this.f_26050_ instanceof Basilemys) && this.f_26050_.m_21223_() == 0.0f) {
                ItemEntity item = new ItemEntity(this.f_26050_.m_9236_(), this.f_26050_.m_20185_(), this.f_26050_.m_20186_(), this.f_26050_.m_20189_(), new ItemStack((ItemLike)Items.f_42355_));
                item.m_6034_(this.f_26050_.m_20185_(), this.f_26050_.m_20186_(), this.f_26050_.m_20189_());
                this.dinosaur.m_9236_().m_7967_((Entity)item);
            }
        }

        public void m_8041_() {
            super.m_8041_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.f_26135_.m_217043_().m_188503_(500) != 0 || this.f_26135_.m_5448_() != null && this.f_26135_.m_217043_().m_188503_(500) != 0;
        }
    }

    static class BrachychampsaPathNavigation
    extends WaterBoundPathNavigation {
        BrachychampsaPathNavigation(Brachychampsa brachychampsa, Level level) {
            super((Mob)brachychampsa, level);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int maxNodes) {
            this.f_26508_ = new AmphibiousNodeEvaluator(true);
            return new PathFinder(this.f_26508_, maxNodes);
        }

        public boolean m_6342_(BlockPos pos) {
            return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
        }
    }
}

