/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Basilemys
extends DinosaurEntity {
    private static final EntityDataAccessor<Boolean> IS_PANICING = SynchedEntityData.m_135353_(Basilemys.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)PFBlocks.HORSETAIL.get()).m_5456_()});
    private int maxHunger = 20;

    public Basilemys(EntityType<? extends Basilemys> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean isPanicing() {
        return (Boolean)this.f_19804_.m_135370_(IS_PANICING);
    }

    private void setPanicing(boolean isPanicing) {
        this.f_19804_.m_135381_(IS_PANICING, (Object)isPanicing);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.HORSETAIL.get()).m_5456_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_PANICING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsPanicing", this.isPanicing());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPanicing(compound.m_128471_("IsPanicing"));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal(this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(2, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.BASILEMYS_AVOIDING)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.BASILEMYS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.BASILEMYS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.basilemys_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.BASILEMYS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.BASILEMYS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.BASILEMYS_DEATH.get();
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22285_, 2.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Basilemys entity = new Basilemys((EntityType<? extends Basilemys>)((EntityType)PFEntities.BASILEMYS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.BASILEMYS_SPAWN_EGG.get());
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setPassive(true);
        } else {
            this.setSkittish(true);
        }
        this.setHerbivorous(true);
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.BASILEMYS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.BASILEMYS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class PanicGoal
    extends net.minecraft.world.entity.ai.goal.PanicGoal {
        PanicGoal(Basilemys turtle, double speedIn) {
            super((PathfinderMob)turtle, speedIn);
        }

        public boolean m_8036_() {
            return Basilemys.this.m_21188_() != null || Basilemys.this.m_6060_();
        }

        public void m_8056_() {
            Basilemys.this.setPanicing(true);
            Basilemys.this.m_21051_(Attributes.f_22278_).m_22100_(100.0);
            Basilemys.this.m_21051_(Attributes.f_22284_).m_22100_(100.0);
            Basilemys.this.m_21051_(Attributes.f_22285_).m_22100_(100.0);
        }

        public void m_8041_() {
            Basilemys.this.setPanicing(false);
            Basilemys.this.m_21051_(Attributes.f_22278_).m_22100_(0.0);
            Basilemys.this.m_21051_(Attributes.f_22284_).m_22100_(0.0);
            Basilemys.this.m_21051_(Attributes.f_22285_).m_22100_(0.0);
        }
    }
}

