/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.hellcreek;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.AggressiveTempermentAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Ankylosaurus
extends DinosaurEntity {
    private static final EntityDataAccessor<Boolean> TUBER_DIGGING = SynchedEntityData.m_135353_(Ankylosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int warningSoundTicks = 200;
    private int maxHunger = 200;

    public Ankylosaurus(EntityType<? extends Ankylosaurus> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Ankylosaurus entity = new Ankylosaurus((EntityType<? extends Ankylosaurus>)((EntityType)PFEntities.ANKYLOSAURUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public int getMaxAir() {
        return 0;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 85) {
            this.setTerritorial(true);
        } else {
            this.m_21561_(true);
        }
        this.setHerbivorous(true);
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean isTuberDigging() {
        return (Boolean)this.f_19804_.m_135370_(TUBER_DIGGING);
    }

    private void setTuberDigging(boolean isTuberDigging) {
        this.f_19804_.m_135381_(TUBER_DIGGING, (Object)isTuberDigging);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.CLUBMOSS.get()).m_5456_();
    }

    @Override
    public int getCurrentHunger() {
        return this.currentHunger;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.76f;
        }
        return 1.5f;
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(80.0);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new DiggingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AggressiveTempermentAttackGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ProtectBabyGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.ANKYLOSAURUS_AVOIDING)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.ANKYLOSAURUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.ANKYLOSAURUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.ankylosaurus_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? (SoundEvent)PFSounds.ANKYLOSAURUS_SNORES.get() : (SoundEvent)PFSounds.ANKYLOSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.ANKYLOSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.ANKYLOSAURUS_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_6162_()) {
            if (!state.m_278721_()) {
                BlockState blockstate = this.m_9236_().m_8055_(pos.m_7494_());
                SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this) : state.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.ANKYLOSAURUS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TUBER_DIGGING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("TuberDigging", this.isTuberDigging());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setTuberDigging(compound.m_128471_("TuberDigging"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource p_33421_, float p_33422_) {
        Entity entity = p_33421_.m_7640_();
        if (entity instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(p_33421_, p_33422_);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.ANKYLOSAURUS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.ANKYLOSAURUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.ANKYLOSAURUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Ankylosaurus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Ankylosaurus.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }

    static class DiggingGoal
    extends Goal {
        private static final ResourceLocation DIGGING_LOOT = new ResourceLocation("prehistoricfauna", "entities/ankylosaurus_digging");
        private final Ankylosaurus ankylosaurus;
        private int diggingTimer;
        private int digTimer2;

        public DiggingGoal(Ankylosaurus entity) {
            this.ankylosaurus = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.digTimer2 > 0) {
                --this.digTimer2;
                return false;
            }
            if (this.ankylosaurus.m_217043_().m_188503_(this.ankylosaurus.m_6162_() ? 100 : 1000) != 0) {
                return false;
            }
            BlockPos blockpos = this.ankylosaurus.m_20183_();
            BlockState state = this.ankylosaurus.m_9236_().m_8055_(blockpos);
            if (state.m_204336_(BlockTags.f_144274_)) {
                return true;
            }
            return this.ankylosaurus.m_9236_().m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_144274_);
        }

        public void m_8056_() {
            this.diggingTimer = 40;
            this.digTimer2 = 6000;
            this.ankylosaurus.m_9236_().m_7605_((Entity)this.ankylosaurus, (byte)10);
            this.ankylosaurus.setTuberDigging(true);
            this.ankylosaurus.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.diggingTimer = 0;
            this.ankylosaurus.setTuberDigging(false);
        }

        public boolean m_8045_() {
            return this.diggingTimer > 0;
        }

        public void m_8037_() {
            if (this.digTimer2 > 0) {
                --this.digTimer2;
            }
            if (this.diggingTimer > 0) {
                --this.diggingTimer;
            }
            if (this.diggingTimer == 25) {
                BlockPos blockpos = this.ankylosaurus.m_20183_();
                BlockPos blockpos1 = blockpos.m_7495_();
                if (this.ankylosaurus.m_9236_().m_8055_(blockpos1).m_204336_(BlockTags.f_144274_)) {
                    BlockState state = this.ankylosaurus.m_9236_().m_8055_(blockpos1);
                    this.ankylosaurus.m_9236_().m_46796_(2001, blockpos1, Block.m_49956_((BlockState)state));
                    MinecraftServer server = this.ankylosaurus.m_9236_().m_7654_();
                    if (server != null) {
                        ObjectArrayList items = server.m_278653_().m_278676_(DIGGING_LOOT).m_287195_(new LootParams.Builder((ServerLevel)this.ankylosaurus.m_9236_()).m_287235_(LootContextParamSets.f_81410_));
                        Containers.m_19010_((Level)this.ankylosaurus.m_9236_(), (BlockPos)blockpos, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])items.toArray(new ItemStack[0])));
                    }
                }
            }
        }
    }
}

