/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.djadochta;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.BurrowingDinosaur;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistBabyHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.OpportunistHuntingGoal;
import superlord.prehistoricfauna.common.entity.goal.OvivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Allosaurus;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Camarasaurus;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Telmasaurus
extends BurrowingDinosaur {
    private int maxHunger = 15;
    int timer = 0;

    public Telmasaurus(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        ((BurrowingDinosaur)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(PFTags.EGGS_5_HUNGER) || stack.m_204117_(PFTags.EGGS_10_HUNGER) || stack.m_204117_(PFTags.EGGS_15_HUNGER);
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)itemEntity);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.25f;
        }
        return 0.5f;
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(3.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(6.0);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        ItemStack stack = this.m_21205_();
        ItemStack newStack = new ItemStack((ItemLike)Items.f_41852_);
        if (stack.m_41720_() != Items.f_41852_) {
            ++this.timer;
            if (this.timer == 600) {
                if (PrehistoricFaunaConfig.advancedHunger) {
                    if (stack.m_204117_(PFTags.EGGS_5_HUNGER)) {
                        if (this.getCurrentHunger() + 5 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(this.currentHunger + 5);
                        }
                    }
                    if (stack.m_204117_(PFTags.EGGS_10_HUNGER)) {
                        if (this.getCurrentHunger() + 10 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(this.currentHunger + 10);
                        }
                    }
                    if (stack.m_204117_(PFTags.EGGS_15_HUNGER)) {
                        if (this.getCurrentHunger() + 15 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(this.currentHunger + 15);
                        }
                    }
                }
                this.m_21008_(InteractionHand.MAIN_HAND, newStack);
            }
            if (this.m_21188_() != null && this.timer < 600) {
                this.spawnItem(stack);
                this.m_21008_(InteractionHand.MAIN_HAND, newStack);
            }
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new EatEggGoal(1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HungerEatEggGoal(1.2f, 12, 2));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Camarasaurus.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Allosaurus.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(8, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21346_.m_25352_(2, (Goal)new OpportunistAttackGoal(this, Player.class, true));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.TELMASAURUS_AVOIDING)));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new OvivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new OpportunistHuntingGoal(this, LivingEntity.class, 10, 1.75, true, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.TELMASAURUS_HUNTING)));
        this.f_21345_.m_25352_(0, (Goal)new OpportunistBabyHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.TELMASAURUS_BABY_HUNTING)));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.TELMASAURUS_HUNTING)));
        this.f_21345_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.TELMASAURUS_BABY_HUNTING)));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.TELMASAURUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.TELMASAURUS.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.telmasaurus_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 20.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.TELMASAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.TELMASAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.TELMASAURUS_DEATH.get();
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setOpportunist(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setSkittish(true);
        } else if (temperment >= 95) {
            this.setProtective(true);
        }
        this.setOvivorous(true);
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 0, false, false));
        }
        return flag;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Telmasaurus entity = new Telmasaurus((EntityType<? extends TamableAnimal>)((EntityType)PFEntities.TELMASAURUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.TELMASAURUS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.TELMASAURUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.TELMASAURUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Telmasaurus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }

    class EatEggGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public EatEggGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((PathfinderMob)Telmasaurus.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean shouldMove() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.m_8055_(pos);
            Block eggs = blockstate.m_60734_();
            return blockstate.m_60713_(Blocks.f_50578_) && (Integer)blockstate.m_61143_((Property)TurtleEggBlock.f_57754_) >= 1 || eggs instanceof DinosaurEggBlock && (Integer)blockstate.m_61143_((Property)DinosaurEggBlock.EGGS) >= 1 && blockstate.m_60734_() != PFBlocks.TELMASAURUS_EGG.get();
        }

        public void m_8037_() {
            ItemStack stack = Telmasaurus.this.m_21205_();
            if (this.m_25625_() && stack.m_41720_() == Items.f_41852_) {
                if (this.field_220731_g >= 40) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                }
            }
            super.m_8037_();
        }

        protected void eatBerry() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)Telmasaurus.this.m_9236_(), (Entity)Telmasaurus.this)) {
                Block eggs;
                BlockState blockstate = Telmasaurus.this.m_9236_().m_8055_(this.f_25602_);
                Telmasaurus.this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), (double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_(), 0.0, 0.0, 0.0);
                if (blockstate.m_60713_(Blocks.f_50578_)) {
                    int i = (Integer)blockstate.m_61143_((Property)TurtleEggBlock.f_57754_);
                    blockstate.m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)Integer.valueOf(1));
                    ItemStack itemstack = Telmasaurus.this.m_6844_(EquipmentSlot.MAINHAND);
                    if (itemstack.m_41619_()) {
                        Telmasaurus.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42279_));
                    }
                    if (i > 1) {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)Integer.valueOf(i - 1)));
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, Blocks.f_50016_.m_49966_());
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if ((eggs = blockstate.m_60734_()) instanceof DinosaurEggBlock) {
                    int i = (Integer)blockstate.m_61143_((Property)DinosaurEggBlock.EGGS);
                    blockstate.m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(1));
                    ItemStack itemstack = Telmasaurus.this.m_6844_(EquipmentSlot.MAINHAND);
                    if (itemstack.m_41619_()) {
                        Telmasaurus.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)eggs.m_5456_()));
                    }
                    if (i > 1) {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(i - 1)));
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, Blocks.f_50016_.m_49966_());
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
            }
        }

        public boolean m_8036_() {
            ItemStack stack = Telmasaurus.this.m_21205_();
            return !Telmasaurus.this.m_5803_() && super.m_8036_() && stack.m_41720_() == Items.f_41852_ && !PrehistoricFaunaConfig.advancedHunger;
        }

        public void m_8056_() {
            this.field_220731_g = 0;
            super.m_8056_();
        }

        public boolean m_8045_() {
            ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
            return Telmasaurus.this.m_21205_() == stack;
        }
    }

    class HungerEatEggGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public HungerEatEggGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((PathfinderMob)Telmasaurus.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean shouldMove() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.m_8055_(pos);
            Block eggs = blockstate.m_60734_();
            return blockstate.m_60713_(Blocks.f_50578_) && (Integer)blockstate.m_61143_((Property)TurtleEggBlock.f_57754_) >= 1 || eggs instanceof DinosaurEggBlock && (Integer)blockstate.m_61143_((Property)DinosaurEggBlock.EGGS) >= 1 && blockstate.m_60734_() != PFBlocks.TELMASAURUS_EGG.get();
        }

        public void m_8037_() {
            ItemStack stack = Telmasaurus.this.m_21205_();
            if (this.m_25625_() && stack.m_41720_() == Items.f_41852_) {
                if (this.field_220731_g >= 40) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                }
            }
            super.m_8037_();
        }

        protected void eatBerry() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)Telmasaurus.this.m_9236_(), (Entity)Telmasaurus.this)) {
                Block eggs;
                BlockState blockstate = Telmasaurus.this.m_9236_().m_8055_(this.f_25602_);
                Telmasaurus.this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), (double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_(), 0.0, 0.0, 0.0);
                if (blockstate.m_60713_(Blocks.f_50578_)) {
                    int i = (Integer)blockstate.m_61143_((Property)TurtleEggBlock.f_57754_);
                    blockstate.m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)Integer.valueOf(1));
                    ItemStack itemstack = Telmasaurus.this.m_6844_(EquipmentSlot.MAINHAND);
                    if (itemstack.m_41619_()) {
                        Telmasaurus.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42279_));
                    }
                    if (i > 1) {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)Integer.valueOf(i - 1)));
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, Blocks.f_50016_.m_49966_());
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if ((eggs = blockstate.m_60734_()) instanceof DinosaurEggBlock) {
                    int i = (Integer)blockstate.m_61143_((Property)DinosaurEggBlock.EGGS);
                    blockstate.m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(1));
                    ItemStack itemstack = Telmasaurus.this.m_6844_(EquipmentSlot.MAINHAND);
                    if (itemstack.m_41619_()) {
                        Telmasaurus.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)eggs.m_5456_()));
                    }
                    if (i > 1) {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(i - 1)));
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        Telmasaurus.this.m_9236_().m_46597_(this.f_25602_, Blocks.f_50016_.m_49966_());
                        Telmasaurus.this.m_9236_().m_5594_((Player)null, this.f_25602_, SoundEvents.f_12533_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
            }
        }

        public boolean m_8036_() {
            ItemStack stack = Telmasaurus.this.m_21205_();
            return !Telmasaurus.this.m_5803_() && super.m_8036_() && stack.m_41720_() == Items.f_41852_ && PrehistoricFaunaConfig.advancedHunger && Telmasaurus.this.getCurrentHunger() <= Telmasaurus.this.getHalfHunger();
        }

        public void m_8056_() {
            this.field_220731_g = 0;
            super.m_8056_();
        }

        public boolean m_8045_() {
            ItemStack stack = new ItemStack((ItemLike)Items.f_41852_);
            return Telmasaurus.this.m_21205_() == stack || Telmasaurus.this.getCurrentHunger() <= Telmasaurus.this.maxHunger;
        }
    }
}

