/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.djadochta;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.HerdDinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Plesiohadros
extends HerdDinosaurEntity {
    private static final EntityDataAccessor<Boolean> DEOXIDATED = SynchedEntityData.m_135353_(Plesiohadros.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(Plesiohadros.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(Plesiohadros.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int maxHunger = 100;
    private int warningSoundTicks;
    public float ridingXZ;
    public float ridingY = 1.0f;

    public Plesiohadros(EntityType<? extends Plesiohadros> type, Level worldIn) {
        super((EntityType<? extends HerdDinosaurEntity>)type, worldIn);
        this.m_274367_(1.0f);
        ((HerdDinosaurEntity)this).maxHunger = this.maxHunger;
    }

    @Override
    public double moveToRange() {
        return 10.0;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Plesiohadros entity = new Plesiohadros((EntityType<? extends Plesiohadros>)((EntityType)PFEntities.PLESIOHADROS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public void m_8038_(ServerLevel p_241841_1_, LightningBolt p_241841_2_) {
        super.m_8038_(p_241841_1_, p_241841_2_);
        this.setDeoxidated(true);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    private void setSaddled(boolean isSaddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)isSaddled);
    }

    public boolean isDeoxidated() {
        return (Boolean)this.f_19804_.m_135370_(DEOXIDATED);
    }

    private void setDeoxidated(boolean isDeoxidated) {
        this.f_19804_.m_135381_(DEOXIDATED, (Object)isDeoxidated);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ((Block)PFBlocks.TROCHODENDROIDES_SAPLING.get()).m_5456_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.PLESIOHADROS_AVOIDING)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.PLESIOHADROS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.PLESIOHADROS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.PLESIOHADROS_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.m_6162_()) {
            if (!blockIn.m_278721_()) {
                BlockState blockstate = this.m_9236_().m_8055_(pos.m_7494_());
                SoundType soundtype = blockstate.m_60713_(Blocks.f_50125_) ? blockstate.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this) : blockIn.getSoundType((LevelReader)this.m_9236_(), pos, (Entity)this);
                this.m_5496_(soundtype.m_56776_(), soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.PLESIOHADROS_WARNING.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DEOXIDATED, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(BOOST_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsDeoxidated", this.isDeoxidated());
        compound.m_128379_("IsSaddled", this.isSaddled());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDeoxidated(compound.m_128471_("IsDeoxidated"));
        this.setSaddled(compound.m_128471_("IsSaddled"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 85) {
            this.setProtective(true);
        } else {
            this.setTerritorial(true);
        }
        this.setHerbivorous(this.f_19850_);
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        int ticks = 0;
        if (this.isDeoxidated() && ++ticks == 12000) {
            ticks = 0;
            this.setDeoxidated(false);
        }
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Override
    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.PLESIOHADROS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.PLESIOHADROS.ordinal()), itemstack);
            p_230254_1_.m_5661_((Component)Component.m_237115_((String)"paleopedia.plesiohadros_added"), true);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_21824_() && item == ((Block)PFBlocks.COBBANIA.get()).m_5456_()) {
            if (!p_230254_1_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_230254_1_)) {
                this.m_21828_(p_230254_1_);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.isSaddled() && !this.m_6162_() && this.m_21824_() && item == Items.f_42450_) {
            if (!p_230254_1_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.setSaddled(true);
            this.m_9236_().m_6263_(p_230254_1_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12236_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.isSaddled() && !this.m_20160_() && !this.m_6162_()) {
            p_230254_1_.m_20329_((Entity)this);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isSaddled()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            if (this.m_20160_() && this.canBeControlledByRider() && this.isSaddled()) {
                LivingEntity livingentity = this.m_6688_();
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (this.canBeControlledByRider()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.m_7023_(new Vec3((double)f, travelVector.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    // empty if block
                }
                this.m_267651_(false);
            } else {
                super.m_7023_(travelVector);
            }
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        if (this.isSaddled() && (entity = this.m_146895_()) instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public boolean canBeControlledByRider() {
        return this.m_6688_() instanceof LivingEntity;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction p_289531_) {
        super.m_19956_(passenger, p_289531_);
        float radius = this.ridingXZ * 0.7f * -3.0f + 0.5f;
        float angle = (float)Math.PI / 180 * this.f_20884_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = this.m_20069_() ? (double)(this.ridingY * 3.0f) : (double)(this.ridingY * 4.1f);
        this.getRidingPlayer().m_6034_(this.m_20185_() + extraX, this.m_20186_() + extraY - 2.75, this.m_20189_() + extraZ);
    }

    protected void func_230273_eI_() {
    }

    public Player getRidingPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    @Nullable
    private Vec3 func_234236_a_(Vec3 p_234236_1_, LivingEntity p_234236_2_) {
        double d0 = this.m_20185_() + p_234236_1_.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + p_234236_1_.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : p_234236_2_.m_7431_()) {
            blockpos$mutable.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                double d4 = this.m_9236_().m_45573_((BlockPos)blockpos$mutable);
                if ((double)blockpos$mutable.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4)) {
                    AABB axisalignedbb = p_234236_2_.m_21270_(pose);
                    Vec3 vector3d = new Vec3(d0, (double)blockpos$mutable.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)p_234236_2_, (AABB)axisalignedbb.m_82383_(vector3d))) {
                        p_234236_2_.m_20124_(pose);
                        return vector3d;
                    }
                }
                blockpos$mutable.m_122173_(Direction.UP);
            } while ((double)blockpos$mutable.m_123342_() < d3);
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity living) {
        Vec3 vector3d = Plesiohadros.m_19903_((double)this.m_20205_(), (double)living.m_20205_(), (float)(this.f_19857_ + (living.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vector3d1 = this.func_234236_a_(vector3d, living);
        if (vector3d1 != null) {
            return vector3d1;
        }
        Vec3 vector3d2 = Plesiohadros.m_19903_((double)this.m_20205_(), (double)living.m_20205_(), (float)(this.f_19857_ + (living.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vector3d3 = this.func_234236_a_(vector3d2, living);
        return vector3d3 != null ? vector3d3 : this.m_20182_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.PLESIOHADROS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.PLESIOHADROS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.PLESIOHADROS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Plesiohadros.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Plesiohadros.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }
}

