/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.djadochta;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.OmnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Oviraptor
extends DinosaurEntity {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)PFItems.RAW_SMALL_REPTILE_MEAT.get()});
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(Oviraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int maxHunger = 20;

    public Oviraptor(EntityType<? extends Oviraptor> type, Level world) {
        super(type, world);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.RAW_SMALL_REPTILE_MEAT.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.425f;
        }
        return 0.85f;
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    private void setSitting(boolean isSitting) {
        this.f_19804_.m_135381_(SITTING, (Object)isSitting);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(4, (Goal)new HuntGoal(this, LivingEntity.class, 10, false, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.OVIRAPTOR_HUNTING)));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.OVIRAPTOR_AVOIDING)));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new OmnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.OVIRAPTOR_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_237491_0_ -> p_237491_0_.m_6095_().m_204039_(PFTags.OVIRAPTOR_BABY_HUNTING)));
        this.f_21345_.m_25352_(5, (Goal)new SitOnEggGoal(1.2f, 12, 2));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.OVIRAPTOR.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.OVIRAPTOR.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.oviraptor_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.26).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.OVIRAPTOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.OVIRAPTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.OVIRAPTOR_DEATH.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsSitting", this.isSitting());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSitting(compound.m_128471_("IsSitting"));
    }

    public boolean onLivingFall(float distance, float damageMultiplier) {
        return false;
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entity) {
        boolean flag = super.onAttackAnimationFinish(entity);
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return flag;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        this.setOmnivorous(true);
        if (temperment < 85) {
            this.setSkittish(true);
        } else {
            this.setPassive(true);
        }
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Oviraptor entity = new Oviraptor((EntityType<? extends Oviraptor>)((EntityType)PFEntities.OVIRAPTOR.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.OVIRAPTOR_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.OVIRAPTOR_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.OVIRAPTOR_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Oviraptor.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    class SitOnEggGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public SitOnEggGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((PathfinderMob)Oviraptor.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean shouldMove() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.m_8055_(pos);
            Block egg = blockstate.m_60734_();
            return egg instanceof DinosaurEggBlock && (Integer)blockstate.m_61143_((Property)DinosaurEggBlock.EGGS) >= 1;
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.field_220731_g >= 40) {
                    this.eatBerry();
                } else {
                    ++this.field_220731_g;
                }
            }
            if (Oviraptor.this.f_19797_ % 80 != 0) {
                this.m_8041_();
            }
            super.m_8037_();
        }

        public void m_8041_() {
            super.m_8041_();
            Oviraptor.this.setSitting(false);
        }

        protected void eatBerry() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)Oviraptor.this.m_9236_(), (Entity)Oviraptor.this)) {
                BlockState blockstate = Oviraptor.this.m_9236_().m_8055_(this.f_25602_);
                Oviraptor.this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), (double)this.f_25602_.m_123341_(), (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_(), 0.0, 0.0, 0.0);
                Block egg = blockstate.m_60734_();
                if (egg instanceof DinosaurEggBlock) {
                    int eggs = (Integer)blockstate.m_61143_((Property)DinosaurEggBlock.EGGS);
                    int hatch = (Integer)blockstate.m_61143_((Property)DinosaurEggBlock.HATCH);
                    blockstate.m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(1));
                    Oviraptor.this.m_9236_().m_7731_(this.f_25602_, (BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(eggs))).m_61124_((Property)DinosaurEggBlock.HATCH, (Comparable)Integer.valueOf(hatch))).m_61124_((Property)DinosaurEggBlock.CITIPATIFIED, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
        }

        public boolean m_8036_() {
            return !Oviraptor.this.m_5803_() && super.m_8036_() && Oviraptor.this.f_19797_ % 60 == 0;
        }

        public void m_8056_() {
            this.field_220731_g = 0;
            super.m_8056_();
            Oviraptor.this.setSitting(true);
        }

        public boolean m_8045_() {
            return Oviraptor.this.f_19797_ % 80 != 0;
        }
    }
}

