/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.djadochta;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.PiscivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Halszkaraptor
extends DinosaurEntity {
    public int ticksSinceEaten;
    private int maxHunger = 10;

    public Halszkaraptor(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.f_21342_ = new HalszkaraptorMoveControl(this);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.HARENAICHTHYS.get();
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)itemEntity);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SwimGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new PiscivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new HalszkaraptorGoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.HALSZKARAPTOR_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.HALSZKARAPTOR_BABY_HUNTING)));
        this.f_21346_.m_25352_(1, (Goal)new HuntGoal(this, LivingEntity.class, 10, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.HALSZKARAPTOR_HUNTING)));
        this.f_21345_.m_25352_(7, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.HALSZKARAPTOR_AVOIDING)));
    }

    public int m_6062_() {
        return 4800;
    }

    protected int m_7305_(int p_28389_) {
        return this.m_6062_();
    }

    protected float m_6108_() {
        return 0.8f;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_6425_(pos.m_7495_()).m_76178_() && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_) ? 10.0f : super.m_5610_(pos, worldIn);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(2.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(4.0);
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        this.setPiscivorous(true);
        if (temperment < 85) {
            this.setSkittish(true);
        } else {
            this.setPassive(true);
        }
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 15.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.HALSZKARAPTOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.HALSZKARAPTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.HALSZKARAPTOR_DEATH.get();
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Halszkaraptor entity = new Halszkaraptor((EntityType<? extends TamableAnimal>)((EntityType)PFEntities.HALSZKARAPTOR.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.spawnItem(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(itemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
            this.ticksSinceEaten = 0;
        }
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, p_28602_);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_9236_().m_7967_((Entity)itementity);
        }
    }

    protected boolean func_212800_dy() {
        return true;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.HALSZKARAPTOR.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.HALSZKARAPTOR.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.halszkaraptor_added"), true);
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() == PFItems.HARENAICHTHYS.get() && this.m_6084_() && this.m_21033_(EquipmentSlot.MAINHAND)) {
            ItemStack halszkaraptorItem = this.m_21205_();
            heldItem.m_41774_(1);
            int dropChance = this.f_19796_.m_188503_(2);
            if (dropChance == 0) {
                this.spawnItem(halszkaraptorItem);
                this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)PFItems.HARENAICHTHYS.get()));
            }
        }
        return super.m_6071_(player, hand);
    }

    protected PathNavigation m_6037_(Level level) {
        return new HalszkaraptorPathNavigation(this, level);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.HALSZKARAPTOR_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.HALSZKARAPTOR_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.HALSZKARAPTOR_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_21515_()) {
            ++this.ticksSinceEaten;
            ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEatItem(itemstack)) {
                if (this.ticksSinceEaten > 100) {
                    ItemStack itemstack1 = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
                    if (!itemstack1.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.ticksSinceEaten = 0;
                    itemstack.m_41774_(1);
                }
            } else if (!itemstack.m_41619_() && this.ticksSinceEaten > 100) {
                this.spawnItem(itemstack);
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
                this.ticksSinceEaten = 0;
                itemstack.m_41774_(1);
            }
        }
        super.m_8107_();
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.m_204117_(PFTags.FISH_2_HUNGER) || itemStackIn.m_204117_(PFTags.FISH_4_HUNGER);
    }

    public boolean canEquipItem(ItemStack stack) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() && !this.m_5803_();
    }

    static class HalszkaraptorMoveControl
    extends MoveControl {
        private final Halszkaraptor halszkaraptor;

        HalszkaraptorMoveControl(Halszkaraptor halszkaraptor) {
            super((Mob)halszkaraptor);
            this.halszkaraptor = halszkaraptor;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.halszkaraptor.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.halszkaraptor.m_20185_();
                double d1 = this.f_24976_ - this.halszkaraptor.m_20186_();
                double d2 = this.f_24977_ - this.halszkaraptor.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.halszkaraptor.m_146922_(this.m_24991_(this.halszkaraptor.m_146908_(), f, 90.0f));
                this.halszkaraptor.f_20883_ = this.halszkaraptor.m_146908_();
                float f1 = (float)(this.f_24978_ * this.halszkaraptor.m_21133_(Attributes.f_22279_));
                this.halszkaraptor.m_7910_(Mth.m_14179_((float)0.125f, (float)this.halszkaraptor.m_6113_(), (float)f1));
                this.halszkaraptor.m_20256_(this.halszkaraptor.m_20184_().m_82520_(0.0, (double)this.halszkaraptor.m_6113_() * d1 * 0.1, 0.0));
            } else {
                this.halszkaraptor.m_7910_(0.0f);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final Halszkaraptor halszkaraptor;

        public SwimGoal(Halszkaraptor halszkaraptor) {
            super((PathfinderMob)halszkaraptor, 1.0, 40);
            this.halszkaraptor = halszkaraptor;
        }

        public boolean m_8036_() {
            return this.halszkaraptor.func_212800_dy() && super.m_8036_();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Halszkaraptor.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class HalszkaraptorGoToWaterGoal
    extends MoveToBlockGoal {
        private static final int GIVE_UP_TICKS = 1200;
        private final Halszkaraptor halszkaraptor;

        HalszkaraptorGoToWaterGoal(Halszkaraptor halszkaraptor, double speed) {
            super((PathfinderMob)halszkaraptor, halszkaraptor.m_6162_() ? 2.0 : speed, 24);
            this.halszkaraptor = halszkaraptor;
            this.f_25603_ = -1;
        }

        public boolean m_8045_() {
            return !this.halszkaraptor.m_20069_() && this.f_25601_ <= 1200 && this.m_6465_((LevelReader)this.halszkaraptor.m_9236_(), this.f_25602_);
        }

        public boolean m_8036_() {
            if (this.halszkaraptor.m_6162_() && !this.halszkaraptor.m_20069_()) {
                return super.m_8036_();
            }
            return !this.halszkaraptor.m_20069_() && !this.halszkaraptor.hasBaby() ? super.m_8036_() : false;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 160 == 0;
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            return level.m_8055_(pos).m_60713_(Blocks.f_49990_);
        }
    }

    static class HalszkaraptorPathNavigation
    extends WaterBoundPathNavigation {
        HalszkaraptorPathNavigation(Halszkaraptor halszkaraptor, Level level) {
            super((Mob)halszkaraptor, level);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int maxNodes) {
            this.f_26508_ = new AmphibiousNodeEvaluator(true);
            return new PathFinder(this.f_26508_, maxNodes);
        }

        public boolean m_6342_(BlockPos pos) {
            return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
        }
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!Halszkaraptor.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (Halszkaraptor.this.m_217043_().m_188503_(FindItemsGoal.m_186073_((int)10)) != 0) {
                return false;
            }
            List list = Halszkaraptor.this.m_9236_().m_45976_(ItemEntity.class, Halszkaraptor.this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            return !list.isEmpty() && Halszkaraptor.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        public void m_8037_() {
            List list = Halszkaraptor.this.m_9236_().m_45976_(ItemEntity.class, Halszkaraptor.this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            ItemStack itemstack = Halszkaraptor.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                Halszkaraptor.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = Halszkaraptor.this.m_9236_().m_45976_(ItemEntity.class, Halszkaraptor.this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            if (!list.isEmpty()) {
                Halszkaraptor.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    static class FishingGoal
    extends Goal {
        private static final ResourceLocation FISHING_LOOT = new ResourceLocation("gameplay/fishing");
        private static final BlockStatePredicate IS_WATER = BlockStatePredicate.m_61287_((Block)Blocks.f_49990_);
        private final Halszkaraptor entity;
        private int fishingTimer;
        private int fishTimer;

        public FishingGoal(Halszkaraptor entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.fishTimer > 0) {
                --this.fishTimer;
                return false;
            }
            if (this.entity.m_217043_().m_188503_(this.entity.m_6162_() ? 100 : 1000) != 0) {
                return false;
            }
            BlockPos blockpos = this.entity.m_20183_();
            if (IS_WATER.test(this.entity.m_9236_().m_8055_(blockpos))) {
                return true;
            }
            return this.entity.m_9236_().m_8055_(blockpos.m_7495_()).m_60713_(Blocks.f_49990_);
        }

        public void m_8056_() {
            this.fishingTimer = 40;
            this.fishTimer = 6000;
            this.entity.m_9236_().m_7605_((Entity)this.entity, (byte)10);
            this.entity.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.fishingTimer = 0;
        }

        public boolean m_8045_() {
            return this.fishingTimer > 0;
        }

        public void m_8037_() {
            if (this.fishTimer > 0) {
                --this.fishTimer;
            }
            if (this.fishingTimer > 0) {
                --this.fishingTimer;
            }
            if (this.fishingTimer == 25) {
                MinecraftServer server;
                BlockPos blockpos = this.entity.m_20183_();
                BlockPos blockpos1 = blockpos.m_7495_();
                if (this.entity.m_9236_().m_8055_(blockpos1).m_60713_(Blocks.f_49990_) && (server = this.entity.m_9236_().m_7654_()) != null) {
                    ObjectArrayList items = server.m_278653_().m_278676_(FISHING_LOOT).m_287195_(new LootParams.Builder((ServerLevel)this.entity.m_9236_()).m_287235_(LootContextParamSet.m_165477_().m_81405_()));
                    Containers.m_19010_((Level)this.entity.m_9236_(), (BlockPos)blockpos, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])items.toArray(new ItemStack[0])));
                }
            }
        }
    }

    static class HalszkaraptorRandomStrollGoal
    extends RandomStrollGoal {
        private final Halszkaraptor halszkaraptor;

        HalszkaraptorRandomStrollGoal(Halszkaraptor halszkaraptor, double speed, int interval) {
            super((PathfinderMob)halszkaraptor, speed, interval);
            this.halszkaraptor = halszkaraptor;
        }

        public boolean m_8036_() {
            return !this.f_25725_.m_20069_() && !this.halszkaraptor.hasBaby() ? super.m_8036_() : false;
        }
    }
}

