/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.cretaceous.djadochta;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.DiurnalSleepingGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.HerbivoreEatGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.PassivePanicGoal;
import superlord.prehistoricfauna.common.entity.goal.SkittishFleeGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEffects;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Goyocephale
extends DinosaurEntity {
    public int maxHunger = 25;
    private static final EntityDataAccessor<Boolean> RAMMING = SynchedEntityData.m_135353_(Goyocephale.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int rammingTime = 0;

    public Goyocephale(EntityType<? extends Goyocephale> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.GINKGO_BERRY.get();
    }

    public boolean isRamming() {
        return (Boolean)this.f_19804_.m_135370_(RAMMING);
    }

    public void setRamming(boolean isRamming) {
        this.f_19804_.m_135381_(RAMMING, (Object)isRamming);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RAMMING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsRamming", false);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRamming(compound.m_128471_("IsRamming"));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PassivePanicGoal(this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DiurnalSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RamGoal());
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(0, (Goal)new HerbivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21345_.m_25352_(7, (Goal)new SkittishFleeGoal(this, Player.class, 10.0f, 1.5, 1.75));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.GOYOCEPHALE_AVOIDING)));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.GOYOCEPHALE.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.GOYOCEPHALE.ordinal()), itemstack);
            player.m_5661_((Component)Component.m_237115_((String)"paleopedia.goyocephale_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
            if (!entity.m_21023_((MobEffect)PFEffects.GINKGO_SPLATTERED.get())) continue;
            this.m_6710_(entity);
        }
        int ramTime = this.f_19796_.m_188503_(5400) + 600;
        for (int i = this.rammingTime; i < ramTime; ++i) {
            if (i != ramTime) continue;
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                if (!((double)entity.m_20205_() <= 0.1) || !((double)entity.m_20206_() <= 0.1)) continue;
                this.setRamming(true);
                this.m_6710_(entity);
            }
            this.rammingTime = 0;
        }
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.GOYOCEPHALE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.GOYOCEPHALE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.GOYOCEPHALE_DEATH.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(5.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        this.setHerbivorous(true);
        if (temperment < 75) {
            this.setPassive(true);
        } else if (temperment > 90) {
            this.setSkittish(true);
        } else {
            this.setProtective(true);
        }
        this.setDiurnal(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.GOYOCEPHALE_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.GOYOCEPHALE_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Goyocephale entity = new Goyocephale((EntityType<? extends Goyocephale>)((EntityType)PFEntities.GOYOCEPHALE.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.GOYOCEPHALE_SPAWN_EGG.get());
    }

    class RamGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public RamGoal() {
            super((PathfinderMob)Goyocephale.this, 1.25, true);
        }

        public boolean m_8036_() {
            return Goyocephale.this.isRamming() && super.m_8036_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.strongKnockback((Entity)enemy);
                this.f_25540_.m_7327_((Entity)enemy);
                this.f_25540_.m_6710_(null);
                this.m_8041_();
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        private void strongKnockback(Entity p_33340_) {
            double d0 = p_33340_.m_20185_() - Goyocephale.this.m_20185_();
            double d1 = p_33340_.m_20189_() - Goyocephale.this.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            p_33340_.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            Goyocephale.this.setRamming(false);
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Goyocephale.this, 1.25, true);
        }

        public boolean m_8036_() {
            return !Goyocephale.this.isRamming() && super.m_8036_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 8.0f + attackTarget.m_20205_();
        }
    }
}

