/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.block.messages;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import superlord.prehistoricfauna.PrehistoricFauna;
import superlord.prehistoricfauna.common.entity.block.PaleoscribeBlockEntity;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.init.PFItems;

public class MessageUpdatePaleoscribe {
    public long blockPos;
    public int selectedPages1;
    public int selectedPages2;
    public int selectedPages3;
    public boolean updateStack;
    public int pageOrdinal;

    public MessageUpdatePaleoscribe(long blockPos, int selectedPages1, int selectedPages2, int selectedPages3, boolean updateStack, int pageOrdinal) {
        this.blockPos = blockPos;
        this.selectedPages1 = selectedPages1;
        this.selectedPages2 = selectedPages2;
        this.selectedPages3 = selectedPages3;
        this.updateStack = updateStack;
        this.pageOrdinal = pageOrdinal;
    }

    public MessageUpdatePaleoscribe() {
    }

    public static MessageUpdatePaleoscribe read(FriendlyByteBuf buf) {
        return new MessageUpdatePaleoscribe(buf.readLong(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readInt());
    }

    public static void write(MessageUpdatePaleoscribe message, FriendlyByteBuf buf) {
        buf.writeLong(message.blockPos);
        buf.writeInt(message.selectedPages1);
        buf.writeInt(message.selectedPages2);
        buf.writeInt(message.selectedPages3);
        buf.writeBoolean(message.updateStack);
        buf.writeInt(message.pageOrdinal);
    }

    public static class Handler {
        public static void handle(MessageUpdatePaleoscribe message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> Handler.lambda$handle$1(message, (Supplier)ctx)));
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$handle$4(message, (Supplier)ctx)));
            ctx.get().setPacketHandled(true);
        }

        public static void handlePacket(MessageUpdatePaleoscribe message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    player = PrehistoricFauna.PROXY.getClientSidePlayer();
                }
                if (player != null) {
                    BlockEntity patt3228$temp;
                    BlockPos pos = BlockPos.m_122022_((long)message.blockPos);
                    if (player.m_9236_().m_46805_(pos) && (patt3228$temp = player.m_9236_().m_7702_(pos)) instanceof PaleoscribeBlockEntity) {
                        PaleoscribeBlockEntity paleoscribe = (PaleoscribeBlockEntity)patt3228$temp;
                        if (message.updateStack) {
                            ItemStack bookStack = paleoscribe.m_8020_(0);
                            if (bookStack.m_41720_() == PFItems.PALEOPEDIA.get()) {
                                EnumPaleoPages.addPage(EnumPaleoPages.fromInt(message.pageOrdinal), bookStack);
                            }
                            paleoscribe.randomizePages(bookStack, paleoscribe.m_8020_(1));
                        } else {
                            paleoscribe.selectedPages[0] = EnumPaleoPages.fromInt(message.selectedPages1);
                            paleoscribe.selectedPages[1] = EnumPaleoPages.fromInt(message.selectedPages2);
                            paleoscribe.selectedPages[2] = EnumPaleoPages.fromInt(message.selectedPages3);
                        }
                    }
                }
            });
            context.setPacketHandled(true);
        }

        private static /* synthetic */ Runnable lambda$handle$4(MessageUpdatePaleoscribe message, Supplier ctx) {
            return () -> Handler.lambda$handle$3(message, (Supplier)ctx);
        }

        private static /* synthetic */ void lambda$handle$3(MessageUpdatePaleoscribe message, Supplier ctx) {
            Handler.handlePacket(message, ctx);
        }

        private static /* synthetic */ Runnable lambda$handle$1(MessageUpdatePaleoscribe message, Supplier ctx) {
            return () -> Handler.lambda$handle$0(message, (Supplier)ctx);
        }

        private static /* synthetic */ void lambda$handle$0(MessageUpdatePaleoscribe message, Supplier ctx) {
            Handler.handlePacket(message, ctx);
        }
    }
}

