/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import superlord.prehistoricfauna.common.entity.BurrowingDinosaur;
import superlord.prehistoricfauna.init.PFBlockEntities;
import superlord.prehistoricfauna.init.PFTags;

public class BurrowBlockEntity
extends BlockEntity {
    public static final String MIN_OCCUPATION_TICKS = "MinOccupationTicks";
    public static final String ENTITY_DATA = "EntityData";
    public static final String TICKS_IN_BURROW = "TicksInBurrow";
    public static final String BURROWERS = "Burrowers";
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_BURROW = 400;
    private final List<BurrowerData> stored = Lists.newArrayList();

    public BurrowBlockEntity(BlockPos p_155134_, BlockState p_155135_) {
        super((BlockEntityType)PFBlockEntities.BURROW.get(), p_155134_, p_155135_);
    }

    public void m_6596_() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromBurrow(null, this.f_58857_.m_8055_(this.m_58899_()), BurrowerReleaseStatus.EMERGENCY);
        }
        super.m_6596_();
    }

    public boolean isFireNearby() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, -1, -1), (BlockPos)this.f_58858_.m_7918_(1, 1, 1))) {
            if (!(this.f_58857_.m_8055_(blockpos).m_60734_() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == 3;
    }

    public void emptyAllLivingFromBurrow(@Nullable Player p_58749_, BlockState p_58750_, BurrowerReleaseStatus p_58751_) {
        List<Entity> list = this.releaseAllOccupants(p_58750_, p_58751_);
        if (p_58749_ != null) {
            for (Entity entity : list) {
                if (!entity.m_6095_().m_204039_(PFTags.BURROWERS)) continue;
                BurrowingDinosaur burrower = (BurrowingDinosaur)entity;
                if (!(p_58749_.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                burrower.setStayOutOfBurrowCountdown(400);
            }
        }
    }

    private List<Entity> releaseAllOccupants(BlockState p_58760_, BurrowerReleaseStatus p_58761_) {
        ArrayList list = Lists.newArrayList();
        this.stored.removeIf(p_272556_ -> BurrowBlockEntity.releaseOccupant(this.f_58857_, this.f_58858_, p_58760_, p_272556_, list, p_58761_));
        if (!list.isEmpty()) {
            super.m_6596_();
        }
        return list;
    }

    public void addOccupant(Entity p_58742_) {
        this.addOccupantWithPresetTicks(p_58742_, 0);
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public void addOccupantWithPresetTicks(Entity p_58745_, int p_58747_) {
        if (this.stored.size() < 3) {
            p_58745_.m_8127_();
            p_58745_.m_20153_();
            CompoundTag compoundtag = new CompoundTag();
            p_58745_.m_20223_(compoundtag);
            this.storeBurrower(compoundtag, p_58747_);
            if (this.f_58857_ != null) {
                BlockPos blockpos = this.m_58899_();
                this.f_58857_.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)p_58745_, (BlockState)this.m_58900_()));
            }
            p_58745_.m_146870_();
            super.m_6596_();
        }
    }

    public void storeBurrower(CompoundTag p_155158_, int p_155159_) {
        this.stored.add(new BurrowerData(p_155158_, p_155159_, 600));
    }

    private static boolean releaseOccupant(Level p_155137_, BlockPos p_155138_, BlockState p_155139_, BurrowerData p_155140_, @Nullable List<Entity> p_155141_, BurrowerReleaseStatus p_155142_) {
        boolean flag;
        if ((p_155137_.m_46462_() || p_155137_.m_46471_()) && p_155142_ != BurrowerReleaseStatus.EMERGENCY) {
            return false;
        }
        CompoundTag compoundtag = p_155140_.entityData.m_6426_();
        compoundtag.m_128365_("BurrowPos", (Tag)NbtUtils.m_129224_((BlockPos)p_155138_));
        BlockPos blockpos = p_155138_.m_121945_(Direction.UP);
        boolean bl = flag = !p_155137_.m_8055_(blockpos).m_60812_((BlockGetter)p_155137_, blockpos).m_83281_();
        if (flag && p_155142_ != BurrowerReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)p_155137_, p_58740_ -> p_58740_);
        if (entity != null) {
            if (!entity.m_6095_().m_204039_(PFTags.BURROWERS)) {
                return false;
            }
            if (entity instanceof BurrowingDinosaur) {
                BurrowingDinosaur burrower = (BurrowingDinosaur)entity;
                BurrowBlockEntity.setBurrowerReleaseData(p_155140_.ticksInBurrow, burrower);
                if (p_155141_ != null) {
                    p_155141_.add((Entity)burrower);
                }
                float f = entity.m_20205_();
                double d3 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
                double d0 = (double)p_155138_.m_123341_() + 0.5 + d3 * 1.0;
                double d1 = (double)p_155138_.m_123342_() + 0.5 - (double)(entity.m_20206_() / 2.0f);
                double d2 = (double)p_155138_.m_123343_() + 0.5 + d3 * 1.0;
                entity.m_7678_(d0, d1, d2, entity.m_146908_(), entity.m_146909_());
            }
            p_155137_.m_220407_(GameEvent.f_157792_, p_155138_, GameEvent.Context.m_223719_((Entity)entity, (BlockState)p_155137_.m_8055_(p_155138_)));
            return p_155137_.m_7967_(entity);
        }
        return false;
    }

    private static void setBurrowerReleaseData(int p_58737_, BurrowingDinosaur p_58738_) {
        int i = p_58738_.m_146764_();
        if (i < 0) {
            p_58738_.m_146762_(Math.min(0, i + p_58737_));
        } else if (i > 0) {
            p_58738_.m_146762_(Math.max(0, i - p_58737_));
        }
        p_58738_.m_27601_(Math.max(0, p_58738_.m_27591_() - p_58737_));
    }

    private static void tickOccupants(Level p_155150_, BlockPos p_155151_, BlockState p_155152_, List<BurrowerData> p_155153_) {
        boolean flag = false;
        Iterator<BurrowerData> iterator = p_155153_.iterator();
        while (iterator.hasNext()) {
            BurrowerReleaseStatus burrowblockentity$burrowerreleasestatus;
            BurrowerData burrowblockentity$burrowerdata = iterator.next();
            if (burrowblockentity$burrowerdata.ticksInBurrow > burrowblockentity$burrowerdata.minOccupationTicks && BurrowBlockEntity.releaseOccupant(p_155150_, p_155151_, p_155152_, burrowblockentity$burrowerdata, null, burrowblockentity$burrowerreleasestatus = BurrowerReleaseStatus.BURROWER_RELEASED)) {
                flag = true;
                iterator.remove();
            }
            ++burrowblockentity$burrowerdata.ticksInBurrow;
        }
        if (flag) {
            BurrowBlockEntity.m_155232_((Level)p_155150_, (BlockPos)p_155151_, (BlockState)p_155152_);
        }
    }

    public static void serverTick(Level p_155145_, BlockPos p_155146_, BlockState p_155147_, BurrowBlockEntity p_155148_) {
        BurrowBlockEntity.tickOccupants(p_155145_, p_155146_, p_155147_, p_155148_.stored);
    }

    public void m_142466_(CompoundTag p_155156_) {
        super.m_142466_(p_155156_);
        this.stored.clear();
        ListTag listtag = p_155156_.m_128437_(BURROWERS, 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            BurrowerData burrowblockentity$burrowerdata = new BurrowerData(compoundtag.m_128469_(ENTITY_DATA), compoundtag.m_128451_(TICKS_IN_BURROW), compoundtag.m_128451_(MIN_OCCUPATION_TICKS));
            this.stored.add(burrowblockentity$burrowerdata);
        }
    }

    protected void m_183515_(CompoundTag p_187467_) {
        super.m_183515_(p_187467_);
        p_187467_.m_128365_(BURROWERS, (Tag)this.writeBurrowers());
    }

    public ListTag writeBurrowers() {
        ListTag listtag = new ListTag();
        for (BurrowerData burrowblockentity$burrowerdata : this.stored) {
            CompoundTag compoundtag = burrowblockentity$burrowerdata.entityData.m_6426_();
            compoundtag.m_128473_("UUID");
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_(ENTITY_DATA, (Tag)compoundtag);
            compoundtag1.m_128405_(TICKS_IN_BURROW, burrowblockentity$burrowerdata.ticksInBurrow);
            compoundtag1.m_128405_(MIN_OCCUPATION_TICKS, burrowblockentity$burrowerdata.minOccupationTicks);
            listtag.add((Object)compoundtag1);
        }
        return listtag;
    }

    public static enum BurrowerReleaseStatus {
        BURROWER_RELEASED,
        EMERGENCY;

    }

    static class BurrowerData {
        final CompoundTag entityData;
        int ticksInBurrow;
        final int minOccupationTicks;

        BurrowerData(CompoundTag p_58786_, int p_58787_, int p_58788_) {
            this.entityData = p_58786_;
            this.ticksInBurrow = p_58787_;
            this.minOccupationTicks = p_58788_;
        }
    }
}

