/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;

public class WallFossil
extends HangingEntity
implements IEntityAdditionalSpawnData {
    public WallFossilType wallfossil;

    public WallFossil(EntityType<? extends WallFossil> type, Level world) {
        super(type, world);
    }

    public WallFossil(Level world, BlockPos pos, Direction facing) {
        super((EntityType)PFEntities.WALL_FOSSIL.get(), world, pos);
        ArrayList<WallFossilType> list = new ArrayList<WallFossilType>();
        int i = 0;
        WallFossilType[] wallFossilTypeArray = WallFossilType.VALUES;
        int n = wallFossilTypeArray.length;
        for (int j = 0; j < n; ++j) {
            WallFossilType wallfossil;
            this.wallfossil = wallfossil = wallFossilTypeArray[j];
            this.m_6022_(facing);
            if (!this.m_7088_()) continue;
            list.add(wallfossil);
            int j2 = wallfossil.getWidth() * wallfossil.getHeight();
            if (j2 <= i) continue;
            i = j2;
        }
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                WallFossilType wallfossil = (WallFossilType)((Object)iterator.next());
                if (wallfossil.getWidth() * wallfossil.getHeight() >= i) continue;
                iterator.remove();
            }
            this.wallfossil = (WallFossilType)((Object)list.get(this.f_19796_.m_188503_(list.size())));
        }
        this.m_6022_(facing);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("Type", this.wallfossil.ordinal());
        compound.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        this.wallfossil = WallFossilType.VALUES[compound.m_128451_("Type")];
        this.f_31699_ = Direction.m_122407_((int)compound.m_128445_("Facing"));
        super.m_7378_(compound);
        this.m_6022_(this.f_31699_);
    }

    public int m_7076_() {
        return this.wallfossil == null ? 1 : this.wallfossil.getWidth();
    }

    public int m_7068_() {
        return this.wallfossil == null ? 1 : this.wallfossil.getHeight();
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (brokenEntity instanceof Player) {
                Player playerentity = (Player)brokenEntity;
                if (playerentity.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19998_((ItemLike)PFItems.WALL_FOSSIL.get());
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
        this.m_6034_(x, y, z);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        BlockPos blockpos = this.f_31698_;
        this.m_6034_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)PFItems.WALL_FOSSIL.get());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.wallfossil);
        buffer.m_130064_(this.f_31698_);
        if (this.f_31699_ == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130068_((Enum)this.f_31699_);
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.wallfossil = (WallFossilType)additionalData.m_130066_(WallFossilType.class);
        this.f_31698_ = additionalData.m_130135_();
        if (additionalData.readBoolean()) {
            this.m_6022_((Direction)additionalData.m_130066_(Direction.class));
        }
    }

    public static enum WallFossilType {
        ARCHAEOPTERYX(32, 32),
        CLAMS(16, 16),
        CRAB(16, 16),
        COELOPHYSIS(48, 32),
        ICHTHYOSAUR(64, 32),
        JAW(32, 16),
        LEAVES(16, 32),
        LONG_FISH(32, 16),
        LOTS_OF_FISH(32, 32),
        PTEROSAUR(48, 32),
        SHELLS(48, 32),
        SMALL_AMMONITE(16, 16),
        SMALL_FISH(16, 16),
        TRILOBITE(16, 16),
        XIPHACTINUS(96, 32),
        YUTYRANNUS(112, 64),
        PSITTACOSAURUS(32, 16),
        HORSESHOE(32, 16),
        LONGISQUAMA(32, 32),
        SHAROVIPTERYX(32, 32),
        HYPHALOSAURUS(16, 32),
        TULLIMONSTRUM(32, 16),
        SINOSAUROPTERYX(32, 48);

        public static final WallFossilType[] VALUES;
        private final int width;
        private final int height;

        private WallFossilType(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        static {
            VALUES = WallFossilType.values();
        }
    }
}

