/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class PrehistoricEntity
extends Animal {
    private int inLove;
    private UUID playerInLove;

    protected PrehistoricEntity(EntityType<? extends PrehistoricEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8024_() {
        if (this.m_146764_() != 0) {
            this.inLove = 0;
        }
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_146764_() != 0) {
            this.inLove = 0;
        }
        if (this.inLove > 0) {
            --this.inLove;
            if (this.inLove % 10 == 0) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == null;
    }

    public boolean m_6469_(DamageSource p_27567_, float p_27568_) {
        if (this.m_6673_(p_27567_)) {
            return false;
        }
        this.inLove = 0;
        return super.m_6469_(p_27567_, p_27568_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("InLove", this.inLove);
        if (this.playerInLove != null) {
            compound.m_128362_("LoveCause", this.playerInLove);
        }
    }

    public double getYOffset() {
        return 0.14;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.inLove = compound.m_128451_("InLove");
        this.playerInLove = compound.m_128403_("LoveCause") ? compound.m_128342_("LoveCause") : null;
    }

    public static boolean m_218104_(EntityType<? extends Animal> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50440_ && worldIn.m_45524_(pos, 0) > 8;
    }

    public int m_8100_() {
        return 120;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected int getExperienceReward(Player player) {
        return 1 + this.m_9236_().f_46441_.m_188503_(3);
    }

    protected void usePlayerItem(Player player, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
    }

    public boolean m_35506_() {
        return this.inLove <= 0;
    }

    public void m_27595_(@Nullable Player player) {
        this.inLove = 600;
        if (player != null) {
            this.playerInLove = player.m_20148_();
        }
        this.m_9236_().m_7605_((Entity)this, (byte)18);
    }

    public void setInLove(int ticks) {
        this.inLove = ticks;
    }

    @Nullable
    public ServerPlayer m_27592_() {
        if (this.playerInLove == null) {
            return null;
        }
        Player playerentity = this.m_9236_().m_46003_(this.playerInLove);
        return playerentity instanceof ServerPlayer ? (ServerPlayer)playerentity : null;
    }

    public boolean m_27593_() {
        return this.inLove > 0;
    }

    public void resetInLove() {
        this.inLove = 0;
    }

    public boolean canMateWith(PrehistoricEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (((Object)((Object)otherAnimal)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.m_27593_() && otherAnimal.m_27593_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
        } else {
            super.m_7822_(id);
        }
    }
}

