/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;

public class PFRaft
extends Boat {
    private static final EntityDataAccessor<Integer> RAFT_TYPE = SynchedEntityData.m_135353_(PFRaft.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PFRaft(EntityType<? extends Entity> entityType, Level level) {
        super((EntityType)PFEntities.RAFT.get(), level);
    }

    public PFRaft(Level level, double positionX, double positionY, double positionZ) {
        super((EntityType)PFEntities.RAFT.get(), level);
        this.m_6034_(positionX, positionY, positionZ);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = positionX;
        this.f_19855_ = positionY;
        this.f_19856_ = positionZ;
    }

    public PFRaft(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends Entity>)((EntityType)PFEntities.RAFT.get()), level);
    }

    public double m_6048_() {
        return this.getPFRaftType() == PFRaftTypes.NEOCALAMITES ? 0.25 : -0.1;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("WoodType", this.getPFRaftType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("WoodType", 8)) {
            this.setPFRaftType(PFRaftTypes.byName(compound.m_128461_("WoodType")));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RAFT_TYPE, (Object)PFRaftTypes.NEOCALAMITES.ordinal());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setPFRaftType(PFRaftTypes type) {
        this.f_19804_.m_135381_(RAFT_TYPE, (Object)type.ordinal());
    }

    public PFRaftTypes getPFRaftType() {
        return PFRaftTypes.byId((Integer)this.f_19804_.m_135370_(RAFT_TYPE));
    }

    public Boat.Type m_28554_() {
        return Boat.Type.OAK;
    }

    public void m_28464_(Boat.Type boatType) {
    }

    public Item m_38369_() {
        switch (this.getPFRaftType()) {
            default: 
        }
        return (Item)PFItems.NEOCALAMITES_BOAT.get();
    }

    public static enum PFRaftTypes {
        NEOCALAMITES((Block)PFBlocks.NEOCALAMITES_PLANKS.get(), "neocalamites");

        private final String name;
        private final Block planks;

        private PFRaftTypes(Block planks, String name) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static PFRaftTypes byId(int id) {
            PFRaftTypes[] boatEntityType = PFRaftTypes.values();
            if (id < 0 || id >= boatEntityType.length) {
                id = 0;
            }
            return boatEntityType[id];
        }

        public static PFRaftTypes byName(String name) {
            PFRaftTypes[] boatEntityType = PFRaftTypes.values();
            for (int i = 0; i < boatEntityType.length; ++i) {
                if (!boatEntityType[i].getName().equals(name)) continue;
                return boatEntityType[i];
            }
            return boatEntityType[0];
        }
    }
}

