/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import superlord.prehistoricfauna.common.entity.PFBoat;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;

public class PFChestBoat
extends ChestBoat {
    private static final EntityDataAccessor<Integer> CHEST_BOAT_TYPE = SynchedEntityData.m_135353_(PFChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PFChestBoat(EntityType<? extends Entity> entityType, Level world) {
        super((EntityType)PFEntities.CHEST_BOAT.get(), world);
    }

    public PFChestBoat(Level world, double positionX, double positionY, double positionZ) {
        super((EntityType)PFEntities.CHEST_BOAT.get(), world);
        this.m_6034_(positionX, positionY, positionZ);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = positionX;
        this.f_19855_ = positionY;
        this.f_19856_ = positionZ;
    }

    public PFChestBoat(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends Entity>)((EntityType)PFEntities.CHEST_BOAT.get()), world);
    }

    public double m_6048_() {
        return this.getPFChestBoatType() == PFBoat.PFBoatTypes.NEOCALAMITES ? 0.25 : -0.1;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("WoodType", this.getPFChestBoatType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("WoodType", 8)) {
            this.setPFChestBoatType(PFBoat.PFBoatTypes.byName(compound.m_128461_("WoodType")));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHEST_BOAT_TYPE, (Object)PFBoat.PFBoatTypes.ARAUCARIA.ordinal());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setPFChestBoatType(PFBoat.PFBoatTypes type) {
        this.f_19804_.m_135381_(CHEST_BOAT_TYPE, (Object)type.ordinal());
    }

    public PFBoat.PFBoatTypes getPFChestBoatType() {
        return PFBoat.PFBoatTypes.byId((Integer)this.f_19804_.m_135370_(CHEST_BOAT_TYPE));
    }

    public Boat.Type m_28554_() {
        return Boat.Type.OAK;
    }

    public void m_28464_(Boat.Type boatType) {
    }

    public Item m_38369_() {
        switch (this.getPFChestBoatType()) {
            default: {
                return (Item)PFItems.ARAUCARIA_CHEST_BOAT.get();
            }
            case METASEQUOIA: {
                return (Item)PFItems.METASEQUOIA_CHEST_BOAT.get();
            }
            case PROTOPICEOXYLON: {
                return (Item)PFItems.PROTOPICEOXYLON_CHEST_BOAT.get();
            }
            case HEIDIPHYLLUM: {
                return (Item)PFItems.HEIDIPHYLLUM_CHEST_BOAT.get();
            }
            case LIRIODENDRITES: {
                return (Item)PFItems.LIRIODENDRITES_CHEST_BOAT.get();
            }
            case ZAMITES: {
                return (Item)PFItems.ZAMITES_CHEST_BOAT.get();
            }
            case PROTOJUNIPEROXYLON: {
                return (Item)PFItems.PROTOJUNIPEROXYLON_CHEST_BOAT.get();
            }
            case GINKGO: {
                return (Item)PFItems.GINKGO_CHEST_BOAT.get();
            }
            case TROCHODENDROIDES: {
                return (Item)PFItems.TROCHODENDROIDES_CHEST_BOAT.get();
            }
            case BRACHYPHYLLUM: {
                return (Item)PFItems.BRACHYPHYLLUM_CHEST_BOAT.get();
            }
            case AGATHOXYLON: {
                return (Item)PFItems.AGATHOXYLON_CHEST_BOAT.get();
            }
            case WOODWORTHIA: {
                return (Item)PFItems.WOODWORTHIA_CHEST_BOAT.get();
            }
            case SCHILDERIA: {
                return (Item)PFItems.SCHILDERIA_CHEST_BOAT.get();
            }
            case DRYOPHYLLUM: {
                return (Item)PFItems.DRYOPHYLLUM_CHEST_BOAT.get();
            }
            case TAXODIUM: {
                return (Item)PFItems.TAXODIUM_CHEST_BOAT.get();
            }
            case SABALITES: {
                return (Item)PFItems.SABALITES_CHEST_BOAT.get();
            }
            case PLATANITES: {
                return (Item)PFItems.PLATANITES_CHEST_BOAT.get();
            }
            case TAXUS: {
                return (Item)PFItems.TAXUS_CHEST_BOAT.get();
            }
            case CZEKANOWSKIA: {
                return (Item)PFItems.CZEKANOWSKIA_CHEST_BOAT.get();
            }
            case SCHIZOLEPIDOPSIS: {
                return (Item)PFItems.SCHIZOLEPIDOPSIS_CHEST_BOAT.get();
            }
            case PODOZAMITES: {
                return (Item)PFItems.PODOZAMITES_CHEST_BOAT.get();
            }
            case NEOCALAMITES: 
        }
        return (Item)PFItems.NEOCALAMITES_CHEST_BOAT.get();
    }
}

