/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;

public class PFBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(PFBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PFBoat(EntityType<? extends Entity> entityType, Level level) {
        super((EntityType)PFEntities.BOAT.get(), level);
    }

    public PFBoat(Level level, double positionX, double positionY, double positionZ) {
        super((EntityType)PFEntities.BOAT.get(), level);
        this.m_6034_(positionX, positionY, positionZ);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = positionX;
        this.f_19855_ = positionY;
        this.f_19856_ = positionZ;
    }

    public PFBoat(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends Entity>)((EntityType)PFEntities.BOAT.get()), level);
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("WoodType", this.getPFBoatType().getName());
    }

    public double m_6048_() {
        return this.getPFBoatType() == PFBoatTypes.NEOCALAMITES ? 0.25 : -0.1;
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("WoodType", 8)) {
            this.setPFBoatType(PFBoatTypes.byName(compound.m_128461_("WoodType")));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)PFBoatTypes.ARAUCARIA.ordinal());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setPFBoatType(PFBoatTypes type) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)type.ordinal());
    }

    public PFBoatTypes getPFBoatType() {
        return PFBoatTypes.byId((Integer)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    public Boat.Type m_28554_() {
        return Boat.Type.OAK;
    }

    public void m_28464_(Boat.Type boatType) {
    }

    public Item m_38369_() {
        switch (this.getPFBoatType()) {
            default: {
                return (Item)PFItems.ARAUCARIA_BOAT.get();
            }
            case METASEQUOIA: {
                return (Item)PFItems.METASEQUOIA_BOAT.get();
            }
            case PROTOPICEOXYLON: {
                return (Item)PFItems.PROTOPICEOXYLON_BOAT.get();
            }
            case HEIDIPHYLLUM: {
                return (Item)PFItems.HEIDIPHYLLUM_BOAT.get();
            }
            case LIRIODENDRITES: {
                return (Item)PFItems.LIRIODENDRITES_BOAT.get();
            }
            case ZAMITES: {
                return (Item)PFItems.ZAMITES_BOAT.get();
            }
            case PROTOJUNIPEROXYLON: {
                return (Item)PFItems.PROTOJUNIPEROXYLON_BOAT.get();
            }
            case GINKGO: {
                return (Item)PFItems.GINKGO_BOAT.get();
            }
            case TROCHODENDROIDES: {
                return (Item)PFItems.TROCHODENDROIDES_BOAT.get();
            }
            case BRACHYPHYLLUM: {
                return (Item)PFItems.BRACHYPHYLLUM_BOAT.get();
            }
            case AGATHOXYLON: {
                return (Item)PFItems.AGATHOXYLON_BOAT.get();
            }
            case WOODWORTHIA: {
                return (Item)PFItems.WOODWORTHIA_BOAT.get();
            }
            case SCHILDERIA: {
                return (Item)PFItems.SCHILDERIA_BOAT.get();
            }
            case DRYOPHYLLUM: {
                return (Item)PFItems.DRYOPHYLLUM_BOAT.get();
            }
            case TAXODIUM: {
                return (Item)PFItems.TAXODIUM_BOAT.get();
            }
            case SABALITES: {
                return (Item)PFItems.SABALITES_BOAT.get();
            }
            case PLATANITES: {
                return (Item)PFItems.PLATANITES_BOAT.get();
            }
            case TAXUS: {
                return (Item)PFItems.TAXUS_BOAT.get();
            }
            case CZEKANOWSKIA: {
                return (Item)PFItems.CZEKANOWSKIA_BOAT.get();
            }
            case SCHIZOLEPIDOPSIS: {
                return (Item)PFItems.SCHIZOLEPIDOPSIS_BOAT.get();
            }
            case PODOZAMITES: 
        }
        return (Item)PFItems.PODOZAMITES_BOAT.get();
    }

    public static enum PFBoatTypes {
        ARAUCARIA((Block)PFBlocks.ARAUCARIA_PLANKS.get(), "araucaria"),
        METASEQUOIA((Block)PFBlocks.METASEQUOIA_PLANKS.get(), "metasequoia"),
        PROTOPICEOXYLON((Block)PFBlocks.PROTOPICEOXYLON_PLANKS.get(), "protopiceoxylon"),
        HEIDIPHYLLUM((Block)PFBlocks.HEIDIPHYLLUM_PLANKS.get(), "heidiphyllum"),
        LIRIODENDRITES((Block)PFBlocks.LIRIODENDRITES_PLANKS.get(), "liriodendrites"),
        ZAMITES((Block)PFBlocks.ZAMITES_PLANKS.get(), "zamites"),
        PROTOJUNIPEROXYLON((Block)PFBlocks.PROTOJUNIPEROXYLON_PLANKS.get(), "protojuniperoxylon"),
        GINKGO((Block)PFBlocks.GINKGO_PLANKS.get(), "ginkgo"),
        TROCHODENDROIDES((Block)PFBlocks.TROCHODENDROIDES_PLANKS.get(), "trochodendroides"),
        BRACHYPHYLLUM((Block)PFBlocks.BRACHYPHYLLUM_PLANKS.get(), "brachyphyllum"),
        AGATHOXYLON((Block)PFBlocks.AGATHOXYLON_PLANKS.get(), "agathoxylon"),
        WOODWORTHIA((Block)PFBlocks.WOODWORTHIA_PLANKS.get(), "woodworthia"),
        SCHILDERIA((Block)PFBlocks.SCHILDERIA_PLANKS.get(), "schilderia"),
        DRYOPHYLLUM((Block)PFBlocks.DRYOPHYLLUM_PLANKS.get(), "dryophyllum"),
        TAXODIUM((Block)PFBlocks.TAXODIUM_PLANKS.get(), "taxodium"),
        SABALITES((Block)PFBlocks.SABALITES_PLANKS.get(), "sabalites"),
        PLATANITES((Block)PFBlocks.PLATANITES_PLANKS.get(), "platanites"),
        TAXUS((Block)PFBlocks.TAXUS_PLANKS.get(), "taxus"),
        CZEKANOWSKIA((Block)PFBlocks.CZEKANOWSKIA_PLANKS.get(), "czekanowskia"),
        SCHIZOLEPIDOPSIS((Block)PFBlocks.SCHIZOLEPIDOPSIS_PLANKS.get(), "schizolepidopsis"),
        PODOZAMITES((Block)PFBlocks.PODOZAMITES_PLANKS.get(), "podozamites"),
        NEOCALAMITES((Block)PFBlocks.NEOCALAMITES_PLANKS.get(), "neocalamites");

        private final String name;
        private final Block planks;

        private PFBoatTypes(Block planks, String name) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static PFBoatTypes byId(int id) {
            PFBoatTypes[] boatEntityType = PFBoatTypes.values();
            if (id < 0 || id >= boatEntityType.length) {
                id = 0;
            }
            return boatEntityType[id];
        }

        public static PFBoatTypes byName(String name) {
            PFBoatTypes[] boatEntityType = PFBoatTypes.values();
            for (int i = 0; i < boatEntityType.length; ++i) {
                if (!boatEntityType[i].getName().equals(name)) continue;
                return boatEntityType[i];
            }
            return boatEntityType[0];
        }
    }
}

