/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;

public class HerdDinosaurEntity
extends DinosaurEntity {
    private HerdDinosaurEntity groupLeader;
    private int groupSize = 1;

    protected HerdDinosaurEntity(EntityType<? extends HerdDinosaurEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public int m_5792_() {
        return this.getMaxGroupSize();
    }

    public int getMaxGroupSize() {
        return super.m_5792_();
    }

    protected boolean canRandomWalk() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.groupLeader != null && this.groupLeader.m_6084_();
    }

    public HerdDinosaurEntity startFollowing(HerdDinosaurEntity groupLeaderIn) {
        this.groupLeader = groupLeaderIn;
        groupLeaderIn.addFollower();
        return groupLeaderIn;
    }

    public void stopFollowing() {
        this.groupLeader.removeFollower();
        this.groupLeader = null;
    }

    private void addFollower() {
        ++this.groupSize;
    }

    private void removeFollower() {
        --this.groupSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.groupSize < this.getMaxGroupSize();
    }

    @Override
    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_217043_().m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.groupSize = 1;
        }
    }

    public boolean hasFollowers() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.groupLeader) <= 121.0;
    }

    public double moveToRange() {
        return 1.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.groupLeader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends HerdDinosaurEntity> p_212810_1_) {
        p_212810_1_.limit(this.getMaxGroupSize() - this.groupSize).filter(p_212801_1_ -> p_212801_1_ != this).forEach(p_212804_1_ -> p_212804_1_.startFollowing(this));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_27528_, DifficultyInstance p_27529_, MobSpawnType p_27530_, @Nullable SchoolSpawnGroupData p_27531_, @Nullable CompoundTag p_27532_) {
        super.m_6518_(p_27528_, p_27529_, p_27530_, p_27531_, p_27532_);
        if (p_27531_ == null) {
            p_27531_ = new SchoolSpawnGroupData(this);
        } else {
            this.startFollowing(p_27531_.leader);
        }
        return p_27531_;
    }

    public static class SchoolSpawnGroupData
    implements SpawnGroupData {
        public final HerdDinosaurEntity leader;

        public SchoolSpawnGroupData(HerdDinosaurEntity p_27553_) {
            this.leader = p_27553_;
        }
    }
}

