/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import superlord.prehistoricfauna.common.entity.cretaceous.yixian.Psittacosaurus;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFTags;

public class DinosaurEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> HAS_BABY = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_BIRTHING = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ASLEEP = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SLEEP_TICK = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACK_DIR = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALBINO = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MELANISTIC = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NATURAL_LOVE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SKITTISH = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PASSIVE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PROTECTIVE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TERRITORIAL = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> OPPORTUNIST = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AGGRESSIVE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HERBIVORE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CARNIVORE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> OMNIVORE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> OVIVORE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PISCIVORE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MOLLUSCIVORE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INSECTIVORE = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NOCTURNAL = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIURNAL = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CREPUSCULAR = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(DinosaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final Predicate<Entity> AVOID_PLAYERS = p_28463_ -> !p_28463_.m_20163_() && EntitySelector.f_20406_.test(p_28463_);
    private float sleepProgress = 0.0f;
    private float prevSleepProgress = 0.0f;
    private float meleeProgress = 0.0f;
    private float prevMeleeProgress = 0.0f;
    public int isBirthing;
    int loveTick = 0;
    public int maxHunger;
    private int lastInLove = 0;
    public int currentHunger;
    public int warryTicks = 0;
    int hungerTick = 0;

    public DinosaurEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
    }

    public static boolean canDinosaurSpawn(EntityType<? extends Animal> animal, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return (worldIn.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_) || worldIn.m_8055_(pos.m_7495_()).m_204336_(Tags.Blocks.SAND)) && worldIn.m_45524_(pos, 0) > 8;
    }

    public boolean isAsleep() {
        return (Boolean)this.f_19804_.m_135370_(ASLEEP);
    }

    public void setAsleep(boolean isAsleep) {
        this.f_19804_.m_135381_(ASLEEP, (Object)isAsleep);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean isEating) {
        this.f_19804_.m_135381_(EATING, (Object)isEating);
    }

    public boolean isAlbino() {
        return (Boolean)this.f_19804_.m_135370_(ALBINO);
    }

    private void setAlbino(boolean isAlbino) {
        this.f_19804_.m_135381_(ALBINO, (Object)isAlbino);
    }

    public boolean isMelanistic() {
        return (Boolean)this.f_19804_.m_135370_(MELANISTIC);
    }

    private void setMelanistic(boolean isMelanistic) {
        this.f_19804_.m_135381_(MELANISTIC, (Object)isMelanistic);
    }

    public boolean hasBaby() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BABY);
    }

    public void setHasBaby(boolean hasBaby) {
        this.f_19804_.m_135381_(HAS_BABY, (Object)hasBaby);
    }

    public boolean isBirthing() {
        return (Boolean)this.f_19804_.m_135370_(IS_BIRTHING);
    }

    public void setBirthing(boolean isBirthing) {
        this.isBirthing = isBirthing ? 1 : 0;
        this.f_19804_.m_135381_(IS_BIRTHING, (Object)isBirthing);
    }

    public boolean isInLoveNaturally() {
        return (Boolean)this.f_19804_.m_135370_(NATURAL_LOVE);
    }

    private void setInLoveNaturally(boolean isInLoveNaturally) {
        this.f_19804_.m_135381_(NATURAL_LOVE, (Object)isInLoveNaturally);
    }

    public int getCurrentHunger() {
        return this.currentHunger;
    }

    public void setHunger(int currentHunger) {
        this.currentHunger = currentHunger;
    }

    public int getHalfHunger() {
        return this.maxHunger / 2;
    }

    public int getThreeQuartersHunger() {
        return this.maxHunger / 4 * 3;
    }

    public boolean isSkittish() {
        return (Boolean)this.f_19804_.m_135370_(SKITTISH);
    }

    public void setSkittish(boolean isSkittish) {
        this.f_19804_.m_135381_(SKITTISH, (Object)isSkittish);
    }

    public boolean isPassive() {
        return (Boolean)this.f_19804_.m_135370_(PASSIVE);
    }

    public void setPassive(boolean isPassive) {
        this.f_19804_.m_135381_(PASSIVE, (Object)isPassive);
    }

    public boolean isProtective() {
        return (Boolean)this.f_19804_.m_135370_(PROTECTIVE);
    }

    public void setProtective(boolean isProtective) {
        this.f_19804_.m_135381_(PROTECTIVE, (Object)isProtective);
    }

    public boolean isTerritorial() {
        return (Boolean)this.f_19804_.m_135370_(TERRITORIAL);
    }

    public void setTerritorial(boolean isTerritorial) {
        this.f_19804_.m_135381_(TERRITORIAL, (Object)isTerritorial);
    }

    public boolean isOpportunist() {
        return (Boolean)this.f_19804_.m_135370_(OPPORTUNIST);
    }

    public void setOpportunist(boolean isOpportunist) {
        this.f_19804_.m_135381_(OPPORTUNIST, (Object)isOpportunist);
    }

    public boolean m_5912_() {
        return (Boolean)this.f_19804_.m_135370_(AGGRESSIVE);
    }

    public void m_21561_(boolean isAggressive) {
        this.f_19804_.m_135381_(AGGRESSIVE, (Object)isAggressive);
    }

    public boolean isHerbivorous() {
        return (Boolean)this.f_19804_.m_135370_(HERBIVORE);
    }

    public void setHerbivorous(boolean isHerbivorous) {
        this.f_19804_.m_135381_(HERBIVORE, (Object)isHerbivorous);
    }

    public boolean isCarnivorous() {
        return (Boolean)this.f_19804_.m_135370_(CARNIVORE);
    }

    public void setCarnivorous(boolean isCarnivorous) {
        this.f_19804_.m_135381_(CARNIVORE, (Object)isCarnivorous);
    }

    public boolean isOmnivorous() {
        return (Boolean)this.f_19804_.m_135370_(OMNIVORE);
    }

    public void setOmnivorous(boolean isOmnivorous) {
        this.f_19804_.m_135381_(OMNIVORE, (Object)isOmnivorous);
    }

    public boolean isOvivorous() {
        return (Boolean)this.f_19804_.m_135370_(OVIVORE);
    }

    public void setOvivorous(boolean isOvivorous) {
        this.f_19804_.m_135381_(OVIVORE, (Object)isOvivorous);
    }

    public boolean isMolluscivorous() {
        return (Boolean)this.f_19804_.m_135370_(MOLLUSCIVORE);
    }

    public void setMolluscivorous(boolean isMolluscivorous) {
        this.f_19804_.m_135381_(MOLLUSCIVORE, (Object)isMolluscivorous);
    }

    public boolean isInsectivorous() {
        return (Boolean)this.f_19804_.m_135370_(INSECTIVORE);
    }

    public void setInsectivorous(boolean isInsctivorous) {
        this.f_19804_.m_135381_(INSECTIVORE, (Object)isInsctivorous);
    }

    public boolean isPiscivorous() {
        return (Boolean)this.f_19804_.m_135370_(PISCIVORE);
    }

    public void setPiscivorous(boolean isPiscivorous) {
        this.f_19804_.m_135381_(PISCIVORE, (Object)isPiscivorous);
    }

    public boolean isDiurnal() {
        return (Boolean)this.f_19804_.m_135370_(DIURNAL);
    }

    public void setDiurnal(boolean isDiurnal) {
        this.f_19804_.m_135381_(DIURNAL, (Object)isDiurnal);
    }

    public boolean isNocturnal() {
        return (Boolean)this.f_19804_.m_135370_(NOCTURNAL);
    }

    public void setNocturnal(boolean isNocturnal) {
        this.f_19804_.m_135381_(NOCTURNAL, (Object)isNocturnal);
    }

    public boolean isCrepuscular() {
        return (Boolean)this.f_19804_.m_135370_(CREPUSCULAR);
    }

    public void setCrepuscular(boolean isCrepuscular) {
        this.f_19804_.m_135381_(CREPUSCULAR, (Object)isCrepuscular);
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList list = Lists.newArrayList();
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        list.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return list;
    }

    public void addTrustedUUID(@Nullable UUID p_28516_) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(p_28516_));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(p_28516_));
        }
    }

    public void removeTrustedUUID(@Nullable UUID p_28516_) {
        this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.empty());
        this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.empty());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ASLEEP, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
        this.f_19804_.m_135372_(SLEEP_TICK, (Object)0);
        this.f_19804_.m_135372_(ATTACK_DIR, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(ALBINO, (Object)false);
        this.f_19804_.m_135372_(MELANISTIC, (Object)false);
        this.f_19804_.m_135372_(HAS_BABY, (Object)false);
        this.f_19804_.m_135372_(IS_BIRTHING, (Object)false);
        this.f_19804_.m_135372_(NATURAL_LOVE, (Object)false);
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.f_19804_.m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.f_19804_.m_135372_(SKITTISH, (Object)false);
        this.f_19804_.m_135372_(PASSIVE, (Object)false);
        this.f_19804_.m_135372_(PROTECTIVE, (Object)false);
        this.f_19804_.m_135372_(TERRITORIAL, (Object)false);
        this.f_19804_.m_135372_(OPPORTUNIST, (Object)false);
        this.f_19804_.m_135372_(AGGRESSIVE, (Object)false);
        this.f_19804_.m_135372_(HERBIVORE, (Object)false);
        this.f_19804_.m_135372_(CARNIVORE, (Object)false);
        this.f_19804_.m_135372_(OMNIVORE, (Object)false);
        this.f_19804_.m_135372_(OVIVORE, (Object)false);
        this.f_19804_.m_135372_(MOLLUSCIVORE, (Object)false);
        this.f_19804_.m_135372_(PISCIVORE, (Object)false);
        this.f_19804_.m_135372_(INSECTIVORE, (Object)false);
        this.f_19804_.m_135372_(DIURNAL, (Object)false);
        this.f_19804_.m_135372_(CREPUSCULAR, (Object)false);
        this.f_19804_.m_135372_(NOCTURNAL, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listtag = new ListTag();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listtag.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        compound.m_128365_("Trusted", (Tag)listtag);
        compound.m_128379_("IsAsleep", this.isAsleep());
        compound.m_128379_("IsEating", this.isEating());
        compound.m_128379_("IsAlbino", this.isAlbino());
        compound.m_128379_("IsMelanistic", this.isMelanistic());
        compound.m_128379_("HasBaby", this.hasBaby());
        compound.m_128405_("MaxHunger", this.currentHunger);
        compound.m_128379_("InNaturalLove", this.isInLoveNaturally());
        compound.m_128379_("IsSkittish", this.isSkittish());
        compound.m_128379_("IsPassive", this.isPassive());
        compound.m_128379_("IsProtective", this.isProtective());
        compound.m_128379_("IsTerritorial", this.isTerritorial());
        compound.m_128379_("IsOpportunist", this.isOpportunist());
        compound.m_128379_("IsAggressive", this.m_5912_());
        compound.m_128379_("IsHerbivorous", this.isHerbivorous());
        compound.m_128379_("IsCarnivorous", this.isCarnivorous());
        compound.m_128379_("IsOmnivorous", this.isOmnivorous());
        compound.m_128379_("IsOvivorous", this.isOvivorous());
        compound.m_128379_("IsMolluscivorous", this.isMolluscivorous());
        compound.m_128379_("IsPiscivorous", this.isPiscivorous());
        compound.m_128379_("IsInsectivorous", this.isInsectivorous());
        compound.m_128379_("IsDiurnal", this.isDiurnal());
        compound.m_128379_("IsNocturnal", this.isNocturnal());
        compound.m_128379_("IsCrepuscular", this.isCrepuscular());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ListTag listtag = compound.m_128437_("Trusted", 11);
        for (int i = 0; i < listtag.size(); ++i) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)listtag.get(i)));
        }
        this.setAsleep(compound.m_128471_("IsAsleep"));
        this.setEating(compound.m_128471_("IsEating"));
        this.setAlbino(compound.m_128471_("IsAlbino"));
        this.setMelanistic(compound.m_128471_("IsMelanistic"));
        this.setHasBaby(compound.m_128471_("HasBaby"));
        this.setHunger(compound.m_128451_("MaxHunger"));
        this.setInLoveNaturally(compound.m_128471_("InNaturalLove"));
        this.setSkittish(compound.m_128471_("IsSkittish"));
        this.setPassive(compound.m_128471_("IsPassive"));
        this.setProtective(compound.m_128471_("IsProtective"));
        this.setTerritorial(compound.m_128471_("IsTerritorial"));
        this.setOpportunist(compound.m_128471_("IsOpportunist"));
        this.m_21561_(compound.m_128471_("IsAggressive"));
        this.setHerbivorous(compound.m_128471_("IsHerbivorous"));
        this.setCarnivorous(compound.m_128471_("IsCarnivorous"));
        this.setOmnivorous(compound.m_128471_("IsOmniivorous"));
        this.setOvivorous(compound.m_128471_("IsOvivorous"));
        this.setMolluscivorous(compound.m_128471_("IsMolluscivorous"));
        this.setPiscivorous(compound.m_128471_("IsPiscivorous"));
        this.setInsectivorous(compound.m_128471_("IsInsectivorous"));
        this.setDiurnal(compound.m_128471_("IsDiurnal"));
        this.setNocturnal(compound.m_128471_("IsNocturnal"));
        this.setCrepuscular(compound.m_128471_("IsCrepuscular"));
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (PrehistoricFaunaConfig.advancedHunger) {
            int hunger = this.getCurrentHunger();
            if (hunger < this.maxHunger) {
                if (!(!this.m_6898_(itemstack) || this.m_27593_() && this.isInLoveNaturally())) {
                    this.m_27595_(p_230254_1_);
                    itemstack.m_41774_(1);
                } else {
                    if (this.isInsectivorous() && itemstack.m_204117_(PFTags.INSECTS_2_HUNGER_ITEM)) {
                        if (hunger + 2 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 2);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (this.isHerbivorous() || this.isOmnivorous()) {
                        if (itemstack.m_204117_(PFTags.PLANTS_2_HUNGER_ITEM)) {
                            if (hunger + 2 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 2);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_4_HUNGER_ITEM)) {
                            if (hunger + 4 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 4);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_6_HUNGER_ITEM)) {
                            if (hunger + 6 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 6);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_8_HUNGER_ITEM)) {
                            if (hunger + 8 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 8);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_10_HUNGER_ITEM)) {
                            if (hunger + 10 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 10);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_12_HUNGER_ITEM)) {
                            if (hunger + 12 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 12);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_15_HUNGER_ITEM)) {
                            if (hunger + 15 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 15);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_20_HUNGER_ITEM)) {
                            if (hunger + 20 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 20);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_25_HUNGER_ITEM)) {
                            if (hunger + 25 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 25);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.PLANTS_30_HUNGER_ITEM)) {
                            if (hunger + 30 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 30);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_150930_((Item)PFItems.MARMARTHIA_BERRIES.get())) {
                            if (hunger + 2 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 2);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                            this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 300));
                        }
                    }
                    if (this.isCarnivorous() || this.isOvivorous() || this.isOmnivorous() || this.isMolluscivorous() || this.isPiscivorous()) {
                        if (itemstack.m_204117_(PFTags.MEATS_2_HUNGER)) {
                            if (hunger + 2 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 2);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.MEATS_4_HUNGER)) {
                            if (hunger + 4 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 4);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.MEATS_6_HUNGER)) {
                            if (hunger + 6 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 6);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.MEATS_8_HUNGER)) {
                            if (hunger + 8 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 8);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.MEATS_10_HUNGER)) {
                            if (hunger + 10 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 10);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.MEATS_12_HUNGER)) {
                            if (hunger + 12 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 12);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                    }
                    if (this.isOvivorous()) {
                        if (itemstack.m_204117_(PFTags.EGGS_5_HUNGER)) {
                            if (this.getCurrentHunger() + 5 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(this.currentHunger + 5);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.EGGS_10_HUNGER)) {
                            if (this.getCurrentHunger() + 10 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(this.currentHunger + 10);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                        if (itemstack.m_204117_(PFTags.EGGS_15_HUNGER)) {
                            if (this.getCurrentHunger() + 15 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(this.currentHunger + 15);
                            }
                            if (!p_230254_1_.m_7500_()) {
                                itemstack.m_41774_(1);
                            }
                        }
                    }
                    if (this.isMolluscivorous() && itemstack.m_204117_(PFTags.SHELLFISH_3_HUNGER)) {
                        if (hunger + 3 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 3);
                        }
                        if (!p_230254_1_.m_7500_()) {
                            itemstack.m_41774_(1);
                        }
                    }
                    if (this.isPiscivorous()) {
                        if (itemstack.m_204117_(PFTags.FISH_2_HUNGER)) {
                            if (hunger + 2 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 2);
                            }
                            itemstack.m_41774_(1);
                        }
                        if (itemstack.m_204117_(PFTags.FISH_4_HUNGER)) {
                            if (hunger + 4 >= this.maxHunger) {
                                this.setHunger(this.maxHunger);
                            } else {
                                this.setHunger(hunger + 4);
                            }
                            itemstack.m_41774_(1);
                        }
                    }
                }
            } else {
                if (this.isMolluscivorous() && itemstack.m_204117_(PFTags.SHELLFISH_3_HUNGER)) {
                    p_230254_1_.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
                }
                if (this.isOvivorous() && (itemstack.m_204117_(PFTags.EGGS_5_HUNGER) || itemstack.m_204117_(PFTags.EGGS_10_HUNGER) || itemstack.m_204117_(PFTags.EGGS_15_HUNGER))) {
                    p_230254_1_.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
                }
                if ((this.isCarnivorous() || this.isOmnivorous() || this.isPiscivorous() || this.isOvivorous() || this.isMolluscivorous()) && (itemstack.m_204117_(PFTags.MEATS_2_HUNGER) || itemstack.m_204117_(PFTags.MEATS_4_HUNGER) || itemstack.m_204117_(PFTags.MEATS_6_HUNGER) || itemstack.m_204117_(PFTags.MEATS_8_HUNGER) || itemstack.m_204117_(PFTags.MEATS_10_HUNGER) || itemstack.m_204117_(PFTags.MEATS_12_HUNGER))) {
                    p_230254_1_.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
                }
                if ((this.isHerbivorous() || this.isOmnivorous()) && (itemstack.m_204117_(PFTags.PLANTS_2_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_4_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_6_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_8_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_10_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_12_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_15_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_20_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_25_HUNGER_ITEM) || itemstack.m_204117_(PFTags.PLANTS_30_HUNGER_ITEM))) {
                    p_230254_1_.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
                }
                if (this.isPiscivorous() && (itemstack.m_204117_(PFTags.FISH_2_HUNGER) || itemstack.m_204117_(PFTags.FISH_4_HUNGER))) {
                    p_230254_1_.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
                }
            }
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isAsleep()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (!this.m_21525_()) {
            if (this.isAsleep()) {
                if (this.isDiurnal() && this.m_9236_().m_46468_() % 24000L > 0L && this.m_9236_().m_46468_() % 24000L < 12000L) {
                    this.setAsleep(false);
                    this.setAwakeTicks(100);
                    this.setFallingAsleep();
                }
                if (this.isNocturnal() && this.m_9236_().m_46468_() % 24000L > 12000L && this.m_9236_().m_46468_() % 24000L < 24000L) {
                    this.setAsleep(false);
                    this.setAwakeTicks(100);
                    this.setFallingAsleep();
                }
                if (this.isCrepuscular() && (this.m_9236_().m_46468_() % 24000L < 2000L || this.m_9236_().m_46468_() % 24000L > 9000L && this.m_9236_().m_46468_() % 24000L < 14000L || this.m_9236_().m_46468_() % 24000L > 21000L)) {
                    this.setAsleep(false);
                    this.setAwakeTicks(100);
                    this.setFallingAsleep();
                }
                if (this.m_21188_() != null || this.m_20069_() || this.m_20077_() || this.m_6060_() || this.m_5830_() || this.f_146808_) {
                    this.setAsleep(false);
                    this.setAwakeTicks(100);
                    this.setFallingAsleep();
                }
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(2.0, 2.0, 2.0))) {
                    if (player.m_6144_()) continue;
                    this.setAsleep(false);
                    this.setAwakeTicks(100);
                    this.setFallingAsleep();
                }
            }
            for (Psittacosaurus psittacosaurus : this.m_9236_().m_45976_(Psittacosaurus.class, this.m_20191_().m_82400_(5.0))) {
                if (!this.m_6162_() || psittacosaurus.m_6162_()) continue;
                int i = this.m_146764_();
                if (this.m_146764_() >= -1) continue;
                this.m_146762_(i + 2);
            }
            List list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(48.0, 48.0, 48.0));
            if (PrehistoricFaunaConfig.advancedHunger) {
                ++this.hungerTick;
                if (this.hungerTick == 600 && !this.m_6162_() || this.hungerTick == 300 && this.m_6162_()) {
                    if (!this.isAsleep()) {
                        if (this.currentHunger != 0) {
                            this.setHunger(this.currentHunger - 1);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.m_21223_() > this.m_21233_() / 2.0f) {
                            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
                        }
                        if (this.currentHunger == 0 && PrehistoricFaunaConfig.hungerDamage && this.m_9236_().m_46791_() == Difficulty.HARD && this.m_21223_() <= this.m_21233_() / 2.0f) {
                            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
                        }
                    }
                    this.hungerTick = 0;
                }
                if (this.currentHunger == 0 && !this.m_6162_() && !this.getTrustedUUIDs().isEmpty()) {
                    this.getTrustedUUIDs().clear();
                }
                if (this.getCurrentHunger() >= this.getThreeQuartersHunger() && this.hungerTick % 150 == 0 && this.m_21223_() < this.m_21233_() && this.m_21223_() != 0.0f && this.m_5448_() == null && this.m_21188_() == null) {
                    float currentHealth = this.m_21223_();
                    this.m_21153_(currentHealth + 1.0f);
                }
                if (PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) {
                    if (!(this.lastInLove != 0 || this.currentHunger < this.getThreeQuartersHunger() || this.f_19797_ % 900 != 0 || this.m_6162_() || this.m_27593_() || this.isAsleep() || list.size() >= 10)) {
                        this.loveTick = 600;
                        this.setInLoveNaturally(true);
                        this.m_27601_(600);
                        this.lastInLove = 28800;
                    }
                    if (this.loveTick != 0) {
                        --this.loveTick;
                    } else {
                        this.setInLoveNaturally(false);
                    }
                }
            } else if ((PrehistoricFaunaConfig.naturalEggBlockLaying || PrehistoricFaunaConfig.naturalEggItemLaying) && !PrehistoricFaunaConfig.advancedHunger) {
                int naturalBreedingChance = this.f_19796_.m_188503_(1000);
                if (!(this.lastInLove != 0 || naturalBreedingChance != 0 || this.m_6162_() || this.m_27593_() || this.isAsleep() || list.size() >= 20)) {
                    this.loveTick = 600;
                    this.setInLoveNaturally(true);
                    this.m_27601_(600);
                    this.lastInLove = 28800;
                }
                if (this.loveTick != 0) {
                    --this.loveTick;
                } else {
                    this.setInLoveNaturally(false);
                }
            }
            if (this.lastInLove != 0) {
                --this.lastInLove;
            }
        }
        if (!this.m_9236_().m_5776_() && this.warryTicks != 0) {
            --this.warryTicks;
        }
    }

    public void setAwakeTicks(int ticks) {
        if (!this.m_9236_().m_5776_()) {
            this.warryTicks = ticks;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevSleepProgress = this.sleepProgress;
        this.prevMeleeProgress = this.meleeProgress;
        if ((Integer)this.f_19804_.m_135370_(SLEEP_TICK) > 0) {
            this.f_19804_.m_135381_(SLEEP_TICK, (Object)((Integer)this.f_19804_.m_135370_(SLEEP_TICK) - 1));
            if (this.sleepProgress < 1.0f) {
                this.sleepProgress = Math.min(this.sleepProgress + 0.1f, 1.0f);
            }
        } else if (this.sleepProgress > 0.0f) {
            this.sleepProgress = Math.max(this.sleepProgress - 0.2f, 0.0f);
        }
        if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) > 0) {
            LivingEntity target = this.m_5448_();
            if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) == 1 && target != null && this.m_142582_((Entity)target) && this.m_20270_((Entity)target) < this.getMeleeRange() + this.m_20205_() + target.m_20205_()) {
                this.onAttackAnimationFinish((Entity)target);
            }
            this.f_19804_.m_135381_(ATTACK_TICK, (Object)((Integer)this.f_19804_.m_135370_(ATTACK_TICK) - 1));
            if (this.meleeProgress < 1.0f) {
                this.meleeProgress = Math.min(this.meleeProgress + 0.2f, 1.0f);
            }
        } else if (this.meleeProgress > 0.0f) {
            this.meleeProgress = Math.max(this.meleeProgress - 0.2f, 0.0f);
        }
    }

    public float getMeleeRange() {
        return 1.5f;
    }

    public boolean getMeleeDirection() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK_DIR);
    }

    protected void m_5502_(Player p_28481_, Mob p_28482_) {
        ((DinosaurEntity)p_28482_).addTrustedUUID(p_28481_.m_20148_());
    }

    public boolean trusts(UUID p_28530_) {
        return this.getTrustedUUIDs().contains(p_28530_);
    }

    public void setFallingAsleep() {
        this.f_19804_.m_135381_(SLEEP_TICK, (Object)15);
    }

    public boolean m_7327_(Entity entityIn) {
        if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) == 0) {
            this.f_19804_.m_135381_(ATTACK_DIR, (Object)this.f_19796_.m_188499_());
        }
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)7);
        return true;
    }

    public boolean onAttackAnimationFinish(Entity target) {
        return target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
    }

    public float getSleepProgress(float partialTick) {
        return this.prevSleepProgress + (this.sleepProgress - this.prevSleepProgress) * partialTick;
    }

    public float getMeleeProgress(float partialTick) {
        return this.prevMeleeProgress + (this.meleeProgress - this.prevMeleeProgress) * partialTick;
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Random random = new Random();
        int birthNumber = random.nextInt(799);
        if (birthNumber >= 0 && birthNumber < 4) {
            this.setAlbino(true);
        } else if (birthNumber >= 4 && birthNumber < 7) {
            this.setMelanistic(true);
        }
        this.setHunger(this.maxHunger);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public Item getEggItem() {
        return null;
    }

    public BlockState getEggBlock(Level world, BlockPos pos) {
        return null;
    }
}

