/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import superlord.prehistoricfauna.common.blocks.BurrowBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.block.BurrowBlockEntity;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFTags;

public class BurrowingDinosaur
extends DinosaurEntity {
    private static final int TOO_FAR_DISTANCE = 32;
    private static final int PATHFIND_TO_BURROW_WHEN_CLOSER_THAN = 16;
    private static final int BURROW_SEARCH_DISTANCE = 20;
    public static final String TAG_BURROW_POS = "BurrowPos";
    private int stayOutOfBurrowCountdown;
    private static final int COOLDOWN_BEFORE_LOCATING_NEW_BURROW = 200;
    public int remainingCooldownBeforeLocatingNewBurrow;
    @Nullable
    public BlockPos burrowPos;
    GoToBurrowGoal goToBurrowGoal;

    public BurrowingDinosaur(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
    }

    protected void m_8099_() {
        this.goToBurrowGoal = new GoToBurrowGoal();
        this.f_21345_.m_25352_(5, (Goal)this.goToBurrowGoal);
        this.f_21345_.m_25352_(1, (Goal)new BurrowingDinosaurEnterBurrowGoal());
        this.f_21345_.m_25352_(5, (Goal)new BurrowingDinosaurLocateBurrowGoal());
        this.f_21345_.m_25352_(0, (Goal)new BurrowingDinosaurCreateBurrowGoal());
    }

    @Override
    public void m_7380_(CompoundTag p_27823_) {
        super.m_7380_(p_27823_);
        if (this.hasBurrow()) {
            p_27823_.m_128365_(TAG_BURROW_POS, (Tag)NbtUtils.m_129224_((BlockPos)this.getBurrowPos()));
        }
        p_27823_.m_128405_("CannotEnterBurrowTicks", this.stayOutOfBurrowCountdown);
    }

    @Override
    public void m_7378_(CompoundTag p_27793_) {
        this.burrowPos = null;
        if (p_27793_.m_128441_(TAG_BURROW_POS)) {
            this.burrowPos = NbtUtils.m_129239_((CompoundTag)p_27793_.m_128469_(TAG_BURROW_POS));
        }
        super.m_7378_(p_27793_);
        this.stayOutOfBurrowCountdown = p_27793_.m_128451_("CannotEnterBurrowTicks");
    }

    public boolean wantsToEnterBurrow() {
        if (this.stayOutOfBurrowCountdown <= 0 && this.m_5448_() == null) {
            boolean flag = false;
            if (this.isDiurnal()) {
                boolean bl = flag = this.m_9236_().m_46471_() || this.m_9236_().m_46462_();
            }
            if (this.isNocturnal()) {
                boolean bl = flag = this.m_9236_().m_46471_() || !this.m_9236_().m_46462_();
            }
            if (this.isCrepuscular()) {
                flag = this.m_9236_().m_46471_() || this.m_9236_().m_46468_() % 24000L >= 2000L && this.m_9236_().m_46468_() % 24000L <= 9000L || this.m_9236_().m_46468_() % 24000L >= 14000L && this.m_9236_().m_46468_() % 24000L <= 21000L;
            }
            return flag && !this.isBurrowNearFire();
        }
        return false;
    }

    public void setStayOutOfBurrowCountdown(int p_27916_) {
        this.stayOutOfBurrowCountdown = p_27916_;
    }

    private boolean isBurrowNearFire() {
        if (this.burrowPos == null) {
            return false;
        }
        BlockEntity blockentity = this.m_9236_().m_7702_(this.burrowPos);
        return blockentity instanceof BurrowBlockEntity && ((BurrowBlockEntity)blockentity).isFireNearby();
    }

    private boolean doesBurrowHaveSpace(BlockPos p_27885_) {
        BlockEntity blockentity = this.m_9236_().m_7702_(p_27885_);
        if (blockentity instanceof BurrowBlockEntity) {
            return !((BurrowBlockEntity)blockentity).isFull();
        }
        return false;
    }

    @VisibleForDebug
    public boolean hasBurrow() {
        return this.burrowPos != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPos getBurrowPos() {
        return this.burrowPos;
    }

    @VisibleForDebug
    public GoalSelector getGoalSelector() {
        return this.f_21345_;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            if (this.stayOutOfBurrowCountdown > 0) {
                --this.stayOutOfBurrowCountdown;
            }
            if (this.remainingCooldownBeforeLocatingNewBurrow > 0) {
                --this.remainingCooldownBeforeLocatingNewBurrow;
            }
            if (this.f_19797_ % 20 == 0 && !this.isBurrowValid()) {
                this.burrowPos = null;
            }
        }
    }

    boolean isBurrowValid() {
        if (!this.hasBurrow()) {
            return false;
        }
        if (this.isTooFarAway(this.burrowPos)) {
            return false;
        }
        BlockEntity blockentity = this.m_9236_().m_7702_(this.burrowPos);
        return blockentity instanceof BurrowBlockEntity;
    }

    public boolean closerThan(BlockPos p_27817_, int p_27818_) {
        return p_27817_.m_123314_((Vec3i)this.m_20183_(), (double)p_27818_);
    }

    public boolean isTooFarAway(BlockPos p_27890_) {
        return !this.closerThan(p_27890_, 32);
    }

    public void pathfindRandomlyTowards(BlockPos p_27881_) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)p_27881_);
        int i = 0;
        BlockPos blockpos = this.m_20183_();
        int j = (int)vec3.f_82480_ - blockpos.m_123342_();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.m_123333_((Vec3i)p_27881_);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec31 = AirRandomPos.m_148387_((PathfinderMob)this, (int)k, (int)l, (int)i, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1.0);
        }
    }

    @VisibleForDebug
    public class GoToBurrowGoal
    extends BaseBurrowerGoal {
        public static final int MAX_TRAVELLING_TICKS = 600;
        int travellingTicks;
        private static final int MAX_BLACKLISTED_TARGETS = 3;
        final List<BlockPos> blacklistedTargets;
        @Nullable
        private Path lastPath;
        private static final int TICKS_BEFORE_HIVE_DROP = 60;
        private int ticksStuck;

        GoToBurrowGoal() {
            this.travellingTicks = BurrowingDinosaur.this.m_217043_().m_188503_(10);
            this.blacklistedTargets = Lists.newArrayList();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canBurrowingDinosaurUse() {
            return BurrowingDinosaur.this.burrowPos != null && !BurrowingDinosaur.this.m_21536_() && BurrowingDinosaur.this.wantsToEnterBurrow() && !this.hasReachedTarget(BurrowingDinosaur.this.burrowPos) && BurrowingDinosaur.this.m_9236_().m_8055_(BurrowingDinosaur.this.burrowPos).m_204336_(PFTags.BURROW_BLOCKS);
        }

        @Override
        public boolean canBurrowingDinosaurContinueToUse() {
            return this.canBurrowingDinosaurUse();
        }

        public void m_8056_() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            this.travellingTicks = 0;
            this.ticksStuck = 0;
            BurrowingDinosaur.this.f_21344_.m_26573_();
            BurrowingDinosaur.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (BurrowingDinosaur.this.burrowPos != null) {
                ++this.travellingTicks;
                if (this.travellingTicks > this.m_183277_(600)) {
                    this.dropAndBlacklistBurrow();
                } else if (!BurrowingDinosaur.this.f_21344_.m_26572_()) {
                    if (!BurrowingDinosaur.this.closerThan(BurrowingDinosaur.this.burrowPos, 16)) {
                        if (BurrowingDinosaur.this.isTooFarAway(BurrowingDinosaur.this.burrowPos)) {
                            this.dropBurrow();
                        } else {
                            BurrowingDinosaur.this.pathfindRandomlyTowards(BurrowingDinosaur.this.burrowPos);
                        }
                    } else {
                        boolean flag = this.pathfindDirectlyTowards(BurrowingDinosaur.this.burrowPos);
                        if (!flag) {
                            this.dropAndBlacklistBurrow();
                        } else if (this.lastPath != null && BurrowingDinosaur.this.f_21344_.m_26570_().m_77385_(this.lastPath)) {
                            ++this.ticksStuck;
                            if (this.ticksStuck > 60) {
                                this.dropBurrow();
                                this.ticksStuck = 0;
                            }
                        } else {
                            this.lastPath = BurrowingDinosaur.this.f_21344_.m_26570_();
                        }
                    }
                }
            }
        }

        private boolean pathfindDirectlyTowards(BlockPos p_27991_) {
            BurrowingDinosaur.this.f_21344_.m_26529_(10.0f);
            BurrowingDinosaur.this.f_21344_.m_26519_((double)p_27991_.m_123341_(), (double)p_27991_.m_123342_(), (double)p_27991_.m_123343_(), 1.0);
            return BurrowingDinosaur.this.f_21344_.m_26570_() != null && BurrowingDinosaur.this.f_21344_.m_26570_().m_77403_();
        }

        boolean isTargetBlacklisted(BlockPos p_27994_) {
            return this.blacklistedTargets.contains(p_27994_);
        }

        private void blacklistTarget(BlockPos p_27999_) {
            this.blacklistedTargets.add(p_27999_);
            while (this.blacklistedTargets.size() > 3) {
                this.blacklistedTargets.remove(0);
            }
        }

        void clearBlacklist() {
            this.blacklistedTargets.clear();
        }

        private void dropAndBlacklistBurrow() {
            if (BurrowingDinosaur.this.burrowPos != null) {
                this.blacklistTarget(BurrowingDinosaur.this.burrowPos);
            }
            this.dropBurrow();
        }

        private void dropBurrow() {
            BurrowingDinosaur.this.burrowPos = null;
            BurrowingDinosaur.this.remainingCooldownBeforeLocatingNewBurrow = 200;
        }

        private boolean hasReachedTarget(BlockPos p_28002_) {
            if (BurrowingDinosaur.this.closerThan(p_28002_, 2)) {
                return true;
            }
            Path path = BurrowingDinosaur.this.f_21344_.m_26570_();
            return path != null && path.m_77406_().equals((Object)p_28002_) && path.m_77403_() && path.m_77392_();
        }
    }

    class BurrowingDinosaurEnterBurrowGoal
    extends BaseBurrowerGoal {
        BurrowingDinosaurEnterBurrowGoal() {
        }

        @Override
        public boolean canBurrowingDinosaurUse() {
            BlockEntity blockentity;
            if (BurrowingDinosaur.this.hasBurrow() && BurrowingDinosaur.this.wantsToEnterBurrow() && BurrowingDinosaur.this.burrowPos.m_203195_((Position)BurrowingDinosaur.this.m_20182_(), 2.0) && (blockentity = BurrowingDinosaur.this.m_9236_().m_7702_(BurrowingDinosaur.this.burrowPos)) instanceof BurrowBlockEntity) {
                BurrowBlockEntity beeburrowblockentity = (BurrowBlockEntity)blockentity;
                if (!beeburrowblockentity.isFull()) {
                    return true;
                }
                BurrowingDinosaur.this.burrowPos = null;
            }
            return false;
        }

        @Override
        public boolean canBurrowingDinosaurContinueToUse() {
            return false;
        }

        public void m_8056_() {
            BlockEntity blockentity = BurrowingDinosaur.this.m_9236_().m_7702_(BurrowingDinosaur.this.burrowPos);
            if (blockentity instanceof BurrowBlockEntity) {
                BurrowBlockEntity burrowblockentity = (BurrowBlockEntity)blockentity;
                burrowblockentity.addOccupant((Entity)BurrowingDinosaur.this);
            }
        }
    }

    class BurrowingDinosaurLocateBurrowGoal
    extends BaseBurrowerGoal {
        BurrowingDinosaurLocateBurrowGoal() {
        }

        @Override
        public boolean canBurrowingDinosaurUse() {
            return BurrowingDinosaur.this.remainingCooldownBeforeLocatingNewBurrow == 0 && !BurrowingDinosaur.this.hasBurrow() && BurrowingDinosaur.this.wantsToEnterBurrow();
        }

        @Override
        public boolean canBurrowingDinosaurContinueToUse() {
            return false;
        }

        public void m_8056_() {
            BurrowingDinosaur.this.remainingCooldownBeforeLocatingNewBurrow = 200;
            List<BlockPos> list = this.findNearbyBurrowsWithSpace();
            if (!list.isEmpty()) {
                for (BlockPos blockpos : list) {
                    if (BurrowingDinosaur.this.goToBurrowGoal.isTargetBlacklisted(blockpos)) continue;
                    BurrowingDinosaur.this.burrowPos = blockpos;
                    return;
                }
                BurrowingDinosaur.this.goToBurrowGoal.clearBlacklist();
                BurrowingDinosaur.this.burrowPos = list.get(0);
            }
        }

        private List<BlockPos> findNearbyBurrowsWithSpace() {
            BlockPos blockpos = BurrowingDinosaur.this.m_20183_();
            PoiManager poimanager = ((ServerLevel)BurrowingDinosaur.this.m_9236_()).m_8904_();
            Stream stream = poimanager.m_27181_(p_218130_ -> p_218130_.m_203656_(PFTags.BURROWS), blockpos, 20, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::m_27257_).filter(BurrowingDinosaur.this::doesBurrowHaveSpace).sorted(Comparator.comparingDouble(p_148811_ -> p_148811_.m_123331_((Vec3i)blockpos))).collect(Collectors.toList());
        }
    }

    class BurrowingDinosaurCreateBurrowGoal
    extends Goal {
        private int digTicks = 0;

        public boolean m_8036_() {
            return BurrowingDinosaur.this.burrowPos == null && BurrowingDinosaur.this.wantsToEnterBurrow() && BurrowingDinosaur.this.m_20075_().m_204336_(PFTags.SOIL);
        }

        public boolean m_8045_() {
            return BurrowingDinosaur.this.burrowPos == null && BurrowingDinosaur.this.wantsToEnterBurrow() && BurrowingDinosaur.this.m_20075_().m_204336_(PFTags.SOIL);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.digTicks == 51) {
                BurrowingDinosaur.this.m_9236_().m_46597_(BurrowingDinosaur.this.m_20097_().m_7494_(), (BlockState)((Block)PFBlocks.BURROW.get()).m_49966_().m_61124_((Property)BurrowBlock.getFaceProperty(Direction.DOWN), (Comparable)Boolean.valueOf(true)));
                this.m_8041_();
            } else {
                ++this.digTicks;
                double d0 = (double)BurrowingDinosaur.this.m_20183_().m_123341_() + BurrowingDinosaur.this.f_19796_.m_188500_();
                double d1 = (double)BurrowingDinosaur.this.m_20183_().m_123342_() + 0.5;
                double d2 = (double)BurrowingDinosaur.this.m_20183_().m_123343_() + BurrowingDinosaur.this.f_19796_.m_188500_();
                if (this.digTicks % 2 == 0) {
                    BurrowingDinosaur.this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, BurrowingDinosaur.this.m_9236_().m_8055_(BurrowingDinosaur.this.m_20183_().m_7495_())), d0, d1, d2, 0.0, 0.0, 0.0);
                    BurrowingDinosaur.this.m_9236_().m_5594_((Player)null, BurrowingDinosaur.this.m_20183_(), SoundEvents.f_11995_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
        }

        public void m_8041_() {
            this.digTicks = 0;
        }

        public void m_8056_() {
        }

        BurrowingDinosaurCreateBurrowGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }
    }

    abstract class BaseBurrowerGoal
    extends Goal {
        BaseBurrowerGoal() {
        }

        public abstract boolean canBurrowingDinosaurUse();

        public abstract boolean canBurrowingDinosaurContinueToUse();

        public boolean m_8036_() {
            return this.canBurrowingDinosaurUse();
        }

        public boolean m_8045_() {
            return this.canBurrowingDinosaurContinueToUse();
        }
    }
}

