/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import superlord.prehistoricfauna.common.blocks.ZamitesFrondsBlock;
import superlord.prehistoricfauna.init.PFBlocks;

public class ZamitesSaplingBlock
extends BushBlock
implements BonemealableBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final IntegerProperty STAGE = BlockStateProperties.f_61405_;

    public ZamitesSaplingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState p_56008_, BlockGetter p_56009_, BlockPos p_56010_, CollisionContext p_56011_) {
        return SHAPE;
    }

    public boolean isSoilBlock(LevelReader world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_() == Blocks.f_50546_ || world.m_8055_(pos).m_60734_() == PFBlocks.PACKED_LOAM.get() || world.m_8055_(pos).m_60734_() == PFBlocks.SILT.get() || world.m_8055_(pos).m_60734_() == Blocks.f_49992_ || world.m_8055_(pos).m_60734_() == Blocks.f_49994_ || world.m_8055_(pos).m_60734_() == Blocks.f_50129_ || world.m_8055_(pos).m_60734_() == Blocks.f_50493_ || world.m_8055_(pos).m_60734_() == PFBlocks.MOSSY_DIRT.get() || world.m_8055_(pos).m_60734_() == Blocks.f_50599_ || world.m_8055_(pos).m_60734_() == PFBlocks.HARDENED_SILT.get() || world.m_8055_(pos).m_60734_() == PFBlocks.LOAM.get() || world.m_8055_(pos).m_60734_() == Blocks.f_49993_ || world.m_8055_(pos).m_60734_() == Blocks.f_50440_;
    }

    public boolean m_7898_(BlockState p_51028_, LevelReader p_51029_, BlockPos p_51030_) {
        BlockPos blockpos = p_51030_.m_7495_();
        return this.isSoilBlock(p_51029_, blockpos);
    }

    public void m_213898_(BlockState p_56003_, ServerLevel p_56004_, BlockPos p_56005_, RandomSource p_56006_) {
        if (p_56004_.m_46803_(p_56005_.m_7494_()) >= 9 && p_56006_.m_188503_(7) == 0) {
            if (!p_56004_.isAreaLoaded(p_56005_, 1)) {
                return;
            }
            this.advanceTree(p_56004_, p_56005_, p_56003_, p_56006_);
        }
    }

    public static boolean isAir(LevelSimulatedReader worldgenlevel, BlockPos pos) {
        if (worldgenlevel instanceof BlockGetter) {
            return worldgenlevel.m_7433_(pos, state -> state.m_60795_());
        }
        return worldgenlevel.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState p_55983_, RandomSource rand) {
        if ((Integer)p_55983_.m_61143_((Property)STAGE) == 0) {
            level.m_7731_(pos, (BlockState)p_55983_.m_61122_((Property)STAGE), 4);
        } else {
            int height = rand.m_188503_(3) + 2;
            int frondsChance = rand.m_188503_(2);
            int secondFrondsChance = rand.m_188503_(2);
            int secondFrondsHeight = rand.m_188503_(3) + 1;
            int secondFrondsDirection = rand.m_188503_(4);
            int frondsHeight = rand.m_188503_(3) + 1;
            int frondsDirection = rand.m_188503_(4);
            int x = pos.m_123341_();
            int z = pos.m_123343_();
            for (int i = pos.m_123342_(); i <= pos.m_123342_() + height; ++i) {
                level.m_7731_(new BlockPos(x, i, z), ((Block)PFBlocks.ZAMITES_LOG.get()).m_49966_(), 2);
                if (frondsChance == 0) {
                    if (frondsDirection == 0 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x + 1, pos.m_123342_() + frondsHeight, z))) {
                        level.m_7731_(new BlockPos(x + 1, pos.m_123342_() + frondsHeight, z), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.WEST), 2);
                    }
                    if (frondsDirection == 1 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x + 0, pos.m_123342_() + frondsHeight, z + 1))) {
                        level.m_7731_(new BlockPos(x + 0, pos.m_123342_() + frondsHeight, z + 1), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.NORTH), 2);
                    }
                    if (frondsDirection == 2 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x + 0, pos.m_123342_() + frondsHeight, z - 1))) {
                        level.m_7731_(new BlockPos(x + 0, pos.m_123342_() + frondsHeight, z - 1), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.SOUTH), 2);
                    }
                    if (frondsDirection == 3 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x - 1, pos.m_123342_() + frondsHeight, z - 0))) {
                        level.m_7731_(new BlockPos(x - 1, pos.m_123342_() + frondsHeight, z - 0), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.EAST), 2);
                    }
                }
                if (secondFrondsChance == 2) {
                    if (secondFrondsDirection == 0 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x + 1, pos.m_123342_() + secondFrondsHeight, z))) {
                        level.m_7731_(new BlockPos(x + 1, pos.m_123342_() + secondFrondsHeight, z), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.WEST), 2);
                    }
                    if (secondFrondsDirection == 1 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x + 0, pos.m_123342_() + secondFrondsHeight, z + 1))) {
                        level.m_7731_(new BlockPos(x + 0, pos.m_123342_() + secondFrondsHeight, z + 1), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.NORTH), 2);
                    }
                    if (secondFrondsDirection == 2 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x + 0, pos.m_123342_() + secondFrondsHeight, z - 1))) {
                        level.m_7731_(new BlockPos(x + 0, pos.m_123342_() + secondFrondsHeight, z - 1), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.SOUTH), 2);
                    }
                    if (secondFrondsDirection == 3 && ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x - 1, pos.m_123342_() + secondFrondsHeight, z - 0))) {
                        level.m_7731_(new BlockPos(x - 1, pos.m_123342_() + secondFrondsHeight, z - 0), (BlockState)((Block)PFBlocks.ZAMITES_FROND.get()).m_49966_().m_61124_((Property)ZamitesFrondsBlock.f_54117_, (Comparable)Direction.EAST), 2);
                    }
                }
                if (!ZamitesSaplingBlock.isAir((LevelSimulatedReader)level, new BlockPos(x, pos.m_123342_() + height + 1, z))) continue;
                level.m_7731_(new BlockPos(x, pos.m_123342_() + height + 1, z), ((Block)PFBlocks.ZAMITES_LEAVES.get()).m_49966_(), 2);
            }
        }
    }

    public boolean m_7370_(LevelReader p_55991_, BlockPos p_55992_, BlockState p_55993_, boolean p_55994_) {
        return true;
    }

    public boolean m_214167_(Level p_55996_, RandomSource p_55997_, BlockPos p_55998_, BlockState p_55999_) {
        return (double)p_55996_.f_46441_.m_188501_() < 0.45;
    }

    public void m_214148_(ServerLevel p_55986_, RandomSource p_55987_, BlockPos p_55988_, BlockState p_55989_) {
        this.advanceTree(p_55986_, p_55988_, p_55989_, p_55987_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56001_) {
        p_56001_.m_61104_(new Property[]{STAGE});
    }
}

