/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import superlord.prehistoricfauna.init.PFDamageSources;

public class TrapBlock
extends Block {
    protected static final VoxelShape PRESSED_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape UNPRESSED_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    protected static final AABB PRESSURE_AABB = new AABB(0.125, 0.0, 0.125, 15.0, 16.0, 15.0);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final Sensitivity sensitivity;

    public TrapBlock(Sensitivity sensitivity, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = sensitivity;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getRedstoneStrength(state) > 0 ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public int tickRate() {
        return 20;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        int i = this.getRedstoneStrength(state);
        if (i > 0) {
            this.updateState((Level)worldIn, pos, state, i);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        int i = this.getRedstoneStrength(state);
        if (i == 0) {
            this.updateState(worldIn, pos, state, i);
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            entityIn.m_6469_(PFDamageSources.causeHenostoneTrapDamage(entityIn.m_9236_().m_9598_()), 2.0f);
        }
    }

    protected void updateState(Level worldIn, BlockPos pos, BlockState state, int oldRedstoneStrength) {
        boolean flag1;
        int i = this.computeRedstoneStrength(worldIn, pos);
        boolean flag = oldRedstoneStrength > 0;
        boolean bl = flag1 = i > 0;
        if (oldRedstoneStrength != i) {
            BlockState blockstate = this.setRedstoneStrength(state, i);
            worldIn.m_7731_(pos, blockstate, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.m_6550_(pos, state, blockstate);
        }
        if (!flag1 && flag) {
            this.playClickOffSound((LevelAccessor)worldIn, pos);
        } else if (flag1 && !flag) {
            this.playClickOnSound((LevelAccessor)worldIn, pos);
        }
        if (flag1) {
            worldIn.m_186460_(new BlockPos((Vec3i)pos), (Block)this, this.tickRate());
        }
    }

    protected void playClickOnSound(LevelAccessor worldIn, BlockPos pos) {
        worldIn.m_5594_((Player)null, pos, SoundEvents.f_12449_, SoundSource.BLOCKS, 0.3f, 0.6f);
    }

    protected void playClickOffSound(LevelAccessor worldIn, BlockPos pos) {
        worldIn.m_5594_((Player)null, pos, SoundEvents.f_12448_, SoundSource.BLOCKS, 0.3f, 0.5f);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            if (this.getRedstoneStrength(state) > 0) {
                this.updateNeighbors(worldIn, pos);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void updateNeighbors(Level worldIn, BlockPos pos) {
        worldIn.m_46672_(pos, (Block)this);
    }

    protected int getRedstoneStrength(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    protected BlockState setRedstoneStrength(BlockState state, int strength) {
        return (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected int computeRedstoneStrength(Level worldIn, BlockPos pos) {
        List list;
        AABB axisalignedbb = PRESSURE_AABB.m_82338_(pos);
        switch (this.sensitivity) {
            case MOBS: {
                list = worldIn.m_45976_(LivingEntity.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_6090_()) continue;
                return 15;
            }
        }
        return 0;
    }

    public static enum Sensitivity {
        MOBS;

    }
}

