/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import superlord.prehistoricfauna.init.PFBlocks;

public class TaxodiumKneeBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<KneeThickness> THICKNESS = EnumProperty.m_61587_((String)"thickness", KneeThickness.class);
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public TaxodiumKneeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(THICKNESS, (Comparable)((Object)KneeThickness.TOP)));
    }

    public BlockBehaviour.OffsetType getValueOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, THICKNESS});
    }

    public boolean isSoilBlock(LevelReader world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_() == Blocks.f_50546_ || world.m_8055_(pos).m_60734_() == PFBlocks.PACKED_LOAM.get() || world.m_8055_(pos).m_60734_() == PFBlocks.SILT.get() || world.m_8055_(pos).m_60734_() == Blocks.f_49992_ || world.m_8055_(pos).m_60734_() == Blocks.f_49994_ || world.m_8055_(pos).m_60734_() == Blocks.f_50129_ || world.m_8055_(pos).m_60734_() == Blocks.f_50493_ || world.m_8055_(pos).m_60734_() == PFBlocks.MOSSY_DIRT.get() || world.m_8055_(pos).m_60734_() == Blocks.f_50599_;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_8055_(pos.m_7495_()).m_60734_() == this || this.isSoilBlock(reader, pos.m_7495_());
    }

    public boolean m_7357_(BlockState p_154112_, BlockGetter p_154113_, BlockPos p_154114_, PathComputationType p_154115_) {
        return false;
    }

    public VoxelShape m_7952_(BlockState p_154170_, BlockGetter p_154171_, BlockPos p_154172_) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        KneeThickness kneeThickness = (KneeThickness)((Object)state.m_61143_(THICKNESS));
        VoxelShape voxelShape = kneeThickness == KneeThickness.BASE ? BASE_SHAPE : (kneeThickness == KneeThickness.MIDDLE ? MIDDLE_SHAPE : TOP_SHAPE);
        Vec3 vector3d = state.m_60824_(world, pos);
        return voxelShape.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        KneeThickness kneeThickness = (KneeThickness)((Object)state.m_61143_(THICKNESS));
        VoxelShape voxelShape = kneeThickness == KneeThickness.BASE ? BASE_SHAPE : (kneeThickness == KneeThickness.MIDDLE ? MIDDLE_SHAPE : TOP_SHAPE);
        Vec3 vector3d = state.m_60824_(world, pos);
        return voxelShape.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        BlockState currentState = worldIn.m_8055_(currentPos);
        if (this.getNumKneeBlocksAbove((BlockGetter)worldIn, currentPos) == 0) {
            worldIn.m_7731_(currentPos, (BlockState)currentState.m_61124_(THICKNESS, (Comparable)((Object)KneeThickness.TOP)), 0);
        } else if (this.getNumKneeBlocksAbove((BlockGetter)worldIn, currentPos) == 1) {
            worldIn.m_7731_(currentPos, (BlockState)currentState.m_61124_(THICKNESS, (Comparable)((Object)KneeThickness.MIDDLE)), 0);
        } else if (this.getNumKneeBlocksAbove((BlockGetter)worldIn, currentPos) > 1) {
            worldIn.m_7731_(currentPos, (BlockState)currentState.m_61124_(THICKNESS, (Comparable)((Object)KneeThickness.BASE)), 0);
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_56089_) {
        FluidState fluidstate = p_56089_.m_43725_().m_6425_(p_56089_.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(p_56089_).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected int getNumKneeBlocksAbove(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 3 && worldIn.m_8055_(pos.m_6630_(i + 1)).m_60713_((Block)PFBlocks.TAXODIUM_KNEE.get()); ++i) {
        }
        return i;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource p_54314_) {
        return 1;
    }

    public boolean m_7370_(LevelReader p_50897_, BlockPos p_50898_, BlockState p_50899_, boolean p_50900_) {
        return true;
    }

    public boolean m_214167_(Level p_50901_, RandomSource p_50902_, BlockPos p_50903_, BlockState p_50904_) {
        return true;
    }

    public boolean isAirBlock(ServerLevel world, BlockPos pos) {
        return world.m_8055_(pos) == Blocks.f_50016_.m_49966_() || world.m_8055_(pos) == Blocks.f_50627_.m_49966_() || world.m_8055_(pos) == Blocks.f_50626_.m_49966_();
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (this.isAirBlock(world, pos.m_7494_())) {
            world.m_46597_(pos.m_7494_(), ((Block)PFBlocks.TAXODIUM_KNEE.get()).m_49966_());
        }
    }

    public FluidState m_5888_(BlockState p_56131_) {
        return (Boolean)p_56131_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_56131_);
    }

    public static enum KneeThickness implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BASE("base");

        private final String name;

        private KneeThickness(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

