/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import superlord.prehistoricfauna.common.entity.block.FeederBlockEntity;
import superlord.prehistoricfauna.init.PFBlockEntities;
import superlord.prehistoricfauna.init.PFTags;

public class FeederBlock
extends BaseEntityBlock {
    public static final BooleanProperty MEAT = BooleanProperty.m_61465_((String)"meat");
    public static final BooleanProperty PLANT = BooleanProperty.m_61465_((String)"plant");
    public static final BooleanProperty EGG = BooleanProperty.m_61465_((String)"egg");
    public static final BooleanProperty SHELLFISH = BooleanProperty.m_61465_((String)"shellfish");
    public static final BooleanProperty FISH = BooleanProperty.m_61465_((String)"fish");
    public static final BooleanProperty INSECT = BooleanProperty.m_61465_((String)"insect");
    public static final IntegerProperty FOOD_LEVEL = IntegerProperty.m_61631_((String)"food_level", (int)0, (int)7);
    private static final VoxelShape OUTER_SHAPE = Shapes.m_83144_();
    private static final VoxelShape[] SHAPES = (VoxelShape[])Util.m_137469_((Object)new VoxelShape[9], p_51967_ -> {
        for (int i = 0; i < 8; ++i) {
            p_51967_[i] = Shapes.m_83113_((VoxelShape)OUTER_SHAPE, (VoxelShape)Block.m_49796_((double)2.0, (double)Math.max(2, 1 + i * 2), (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
        }
        p_51967_[8] = p_51967_[7];
    });

    public boolean m_7923_(BlockState p_56395_) {
        return true;
    }

    public FeederBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MEAT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PLANT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EGG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHELLFISH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FISH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INSECT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FOOD_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MEAT, PLANT, EGG, SHELLFISH, FISH, INSECT, FOOD_LEVEL});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockState foodState = world.m_8055_(pos);
        if (this.getFoodAmount(world, pos) == 0) {
            if (stack.m_204117_(PFTags.MEATS_2_HUNGER) || stack.m_204117_(PFTags.MEATS_4_HUNGER) || stack.m_204117_(PFTags.MEATS_6_HUNGER) || stack.m_204117_(PFTags.MEATS_8_HUNGER) || stack.m_204117_(PFTags.MEATS_10_HUNGER) || stack.m_204117_(PFTags.MEATS_12_HUNGER)) {
                world.m_7731_(pos, (BlockState)foodState.m_61124_((Property)MEAT, (Comparable)Boolean.valueOf(true)), 0);
                if (stack.m_204117_(PFTags.MEATS_2_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_4_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 20, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_6_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 30, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_8_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 40, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_10_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 50, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_12_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 60, world, pos);
                    world.m_8055_(pos);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (stack.m_204117_(PFTags.FISH_2_HUNGER) || stack.m_204117_(PFTags.FISH_4_HUNGER)) {
                world.m_7731_(pos, (BlockState)foodState.m_61124_((Property)FISH, (Comparable)Boolean.valueOf(true)), 0);
                if (stack.m_204117_(PFTags.FISH_2_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.FISH_4_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 20, world, pos);
                    world.m_8055_(pos);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (stack.m_204117_(PFTags.SHELLFISH_3_HUNGER)) {
                world.m_7731_(pos, (BlockState)foodState.m_61124_((Property)SHELLFISH, (Comparable)Boolean.valueOf(true)), 0);
                if (stack.m_204117_(PFTags.SHELLFISH_3_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 15, world, pos);
                    world.m_8055_(pos);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (stack.m_204117_(PFTags.EGGS_5_HUNGER) || stack.m_204117_(PFTags.EGGS_10_HUNGER) || stack.m_204117_(PFTags.EGGS_15_HUNGER)) {
                world.m_7731_(pos, (BlockState)foodState.m_61124_((Property)EGG, (Comparable)Boolean.valueOf(true)), 0);
                if (stack.m_204117_(PFTags.EGGS_5_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 25, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.EGGS_10_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 50, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.EGGS_15_HUNGER)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 75, world, pos);
                    world.m_8055_(pos);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (stack.m_204117_(PFTags.INSECTS_2_HUNGER_ITEM)) {
                world.m_7731_(pos, (BlockState)foodState.m_61124_((Property)INSECT, (Comparable)Boolean.valueOf(true)), 0);
                this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                world.m_8055_(pos);
            }
            if (stack.m_204117_(PFTags.PLANTS_2_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_4_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_6_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_8_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_10_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_12_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_15_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_20_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_25_HUNGER_ITEM) || stack.m_204117_(PFTags.PLANTS_30_HUNGER_ITEM)) {
                world.m_7731_(pos, (BlockState)foodState.m_61124_((Property)PLANT, (Comparable)Boolean.valueOf(true)), 0);
                if (stack.m_204117_(PFTags.PLANTS_2_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_4_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 20, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_6_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 30, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_8_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 40, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_10_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 50, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_12_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 60, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_15_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 75, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_20_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 100, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_25_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 125, world, pos);
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.PLANTS_30_HUNGER_ITEM)) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 150, world, pos);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        if (this.getFoodAmount(world, pos) < 1001) {
            BlockState currentState = world.m_8055_(pos);
            if (this.hasInsects(currentState) && this.getFoodAmount(world, pos) != 1001 && stack.m_204117_(PFTags.INSECTS_2_HUNGER_ITEM)) {
                if (this.getFoodAmount(world, pos) + 10 < 1001) {
                    this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                } else {
                    this.setFoodAmount(1001, world, pos);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                world.m_8055_(pos);
            }
            if (this.hasMeat(currentState) && this.getFoodAmount(world, pos) != 1001) {
                if (stack.m_204117_(PFTags.MEATS_2_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 10 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_4_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 20 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 20, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_6_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 30 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 30, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_8_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 40 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 40, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_10_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 50 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 50, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    world.m_8055_(pos);
                }
                if (stack.m_204117_(PFTags.MEATS_12_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 60 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 60, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    world.m_8055_(pos);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (this.hasPlants(currentState) && this.getFoodAmount(world, pos) != 1001) {
                if (stack.m_204117_(PFTags.PLANTS_2_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 10 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_4_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 20 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 20, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_6_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 30 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 30, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_8_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 40 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 40, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_10_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 50 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 50, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_12_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 60 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 60, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_15_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 75 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 75, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_20_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 100 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 100, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_25_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 125 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 125, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.PLANTS_30_HUNGER_ITEM)) {
                    if (this.getFoodAmount(world, pos) + 150 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 150, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (this.hasEggs(currentState) && this.getFoodAmount(world, pos) != 1001) {
                if (stack.m_204117_(PFTags.EGGS_5_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 25 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 25, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.EGGS_10_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 50 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 50, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.EGGS_15_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 75 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 75, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (this.hasFish(currentState) && this.getFoodAmount(world, pos) != 1001) {
                if (stack.m_204117_(PFTags.FISH_2_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 10 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 10, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                if (stack.m_204117_(PFTags.FISH_4_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 20 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 20, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (this.hasShellfish(currentState) && this.getFoodAmount(world, pos) != 1001) {
                if (stack.m_204117_(PFTags.SHELLFISH_3_HUNGER)) {
                    if (this.getFoodAmount(world, pos) + 15 < 1001) {
                        this.setFoodAmount(this.getFoodAmount(world, pos) + 15, world, pos);
                    } else {
                        this.setFoodAmount(1001, world, pos);
                    }
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : FeederBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)PFBlockEntities.FEEDER.get()), FeederBlockEntity::tick);
    }

    public int getFoodAmount(Level level, BlockPos pos) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof FeederBlockEntity) {
            return ((FeederBlockEntity)blockentity).getFoodAmount();
        }
        return 0;
    }

    public void setFoodAmount(int amount, Level level, BlockPos pos) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof FeederBlockEntity) {
            ((FeederBlockEntity)blockentity).setFoodAmount(amount);
            blockentity.m_6596_();
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FeederBlockEntity(pos, state);
    }

    public boolean hasMeat(BlockState state) {
        return (Boolean)state.m_61143_((Property)MEAT);
    }

    public boolean hasPlants(BlockState state) {
        return (Boolean)state.m_61143_((Property)PLANT);
    }

    public boolean hasEggs(BlockState state) {
        return (Boolean)state.m_61143_((Property)EGG);
    }

    public boolean hasShellfish(BlockState state) {
        return (Boolean)state.m_61143_((Property)SHELLFISH);
    }

    public boolean hasFish(BlockState state) {
        return (Boolean)state.m_61143_((Property)FISH);
    }

    public boolean hasInsects(BlockState state) {
        return (Boolean)state.m_61143_((Property)INSECT);
    }

    public VoxelShape m_5940_(BlockState p_51973_, BlockGetter p_51974_, BlockPos p_51975_, CollisionContext p_51976_) {
        return SHAPES[(Integer)p_51973_.m_61143_((Property)FOOD_LEVEL)];
    }

    public VoxelShape m_6079_(BlockState p_51969_, BlockGetter p_51970_, BlockPos p_51971_) {
        return OUTER_SHAPE;
    }

    public VoxelShape m_5909_(BlockState p_48735_, BlockGetter p_48736_, BlockPos p_48737_, CollisionContext p_48738_) {
        return SHAPES[(Integer)p_48735_.m_61143_((Property)FOOD_LEVEL)];
    }

    public VoxelShape m_5939_(BlockState p_51990_, BlockGetter p_51991_, BlockPos p_51992_, CollisionContext p_51993_) {
        return SHAPES[0];
    }
}

