/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Edmontosaurus;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Triceratops;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Tyrannosaurus;
import superlord.prehistoricfauna.common.entity.cretaceous.yixian.Dongbeititan;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Camarasaurus;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFTags;

public class DinosaurEggBlock
extends Block {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final int MIN_EGGS = 1;
    public static final int MAX_EGGS = 4;
    private static final VoxelShape ONE_EGG_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;
    public static final BooleanProperty CITIPATIFIED = BooleanProperty.m_61465_((String)"citipatified");
    private final Lazy<? extends EntityType<?>> entityTypeSupplier = Lazy.of(() -> entityTypeSupplier.get());

    public DinosaurEggBlock(RegistryObject<? extends EntityType<?>> entityTypeSupplier, BlockBehaviour.Properties p_57759_) {
        super(p_57759_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void m_141947_(Level p_154857_, BlockPos p_154858_, BlockState p_154859_, Entity p_154860_) {
        this.destroyEgg(p_154857_, p_154859_, p_154858_, p_154860_, 100);
        super.m_141947_(p_154857_, p_154858_, p_154859_, p_154860_);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        return blockstate.m_60783_((BlockGetter)worldIn, pos.m_7495_(), Direction.UP) && !blockstate.m_204336_(PFTags.NESTS) && !state.m_60713_(Blocks.f_49990_);
    }

    public void m_142072_(Level p_154845_, BlockState p_154846_, BlockPos p_154847_, Entity p_154848_, float p_154849_) {
        if (!(p_154848_ instanceof Zombie)) {
            this.destroyEgg(p_154845_, p_154846_, p_154847_, p_154848_, 3);
        }
        super.m_142072_(p_154845_, p_154846_, p_154847_, p_154848_, p_154849_);
    }

    private void destroyEgg(Level p_154851_, BlockState p_154852_, BlockPos p_154853_, Entity p_154854_, int p_154855_) {
        Entity dinosaurEntity = ((EntityType)this.entityTypeSupplier.get()).m_20615_(p_154851_);
        if (this.canDestroyEgg(p_154851_, p_154854_) && !p_154851_.f_46443_ && p_154851_.f_46441_.m_188503_(p_154855_) == 0 && p_154852_.m_60713_((Block)this)) {
            Player player;
            Entity parent;
            Object parentDinosaur;
            this.decreaseEggs(p_154851_, p_154853_, p_154852_);
            if (dinosaurEntity instanceof DinosaurEntity) {
                DinosaurEntity dinosaur = (DinosaurEntity)dinosaurEntity;
                for (Entity parentEntity : p_154851_.m_45933_(dinosaurEntity, new AABB((double)(p_154853_.m_123341_() - 4), (double)(p_154853_.m_123342_() - 4), (double)(p_154853_.m_123343_() - 4), (double)(p_154853_.m_123341_() + 4), (double)(p_154853_.m_123342_() + 4), (double)(p_154853_.m_123343_() + 4)))) {
                    if (!(parentEntity instanceof DinosaurEntity)) continue;
                    parentDinosaur = (DinosaurEntity)parentEntity;
                    parent = ((EntityType)this.entityTypeSupplier.get()).m_20615_(p_154851_);
                    if (!(p_154854_ instanceof Player)) continue;
                    player = (Player)p_154854_;
                    if (!parentDinosaur.m_21204_().m_22171_(Attributes.f_22281_) || parentDinosaur.m_6162_() || ((DinosaurEntity)((Object)parentDinosaur)).trusts(player.m_20148_()) || parentDinosaur.m_21824_() || parentDinosaur != parent || player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)PFItems.EGG_HELMET.get())) continue;
                    parentDinosaur.m_6710_((LivingEntity)player);
                }
            }
            if (dinosaurEntity instanceof Triceratops) {
                Triceratops triceratops = (Triceratops)dinosaurEntity;
                for (Entity parentEntity : p_154851_.m_45933_((Entity)triceratops, new AABB((double)(p_154853_.m_123341_() - 4), (double)(p_154853_.m_123342_() - 4), (double)(p_154853_.m_123343_() - 4), (double)(p_154853_.m_123341_() + 4), (double)(p_154853_.m_123342_() + 4), (double)(p_154853_.m_123343_() + 4)))) {
                    if (!(parentEntity instanceof Triceratops)) continue;
                    parentDinosaur = (Triceratops)parentEntity;
                    parent = ((EntityType)this.entityTypeSupplier.get()).m_20615_(p_154851_);
                    if (!(p_154854_ instanceof Player)) continue;
                    player = (Player)p_154854_;
                    if (!parentDinosaur.m_21204_().m_22171_(Attributes.f_22281_) || parentDinosaur.m_6162_() || ((Triceratops)((Object)parentDinosaur)).trusts(player.m_20148_()) || parentDinosaur.m_30614_() || parentDinosaur != parent || player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)PFItems.EGG_HELMET.get())) continue;
                    parentDinosaur.m_6710_((LivingEntity)player);
                }
            }
        }
    }

    public EntityType<?> getEntityType() {
        return (EntityType)this.entityTypeSupplier.get();
    }

    private void decreaseEggs(Level p_57792_, BlockPos p_57793_, BlockState p_57794_) {
        p_57792_.m_5594_((Player)null, p_57793_, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + p_57792_.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)p_57794_.m_61143_((Property)EGGS);
        if (i <= 1) {
            p_57792_.m_46961_(p_57793_, false);
        } else {
            p_57792_.m_7731_(p_57793_, (BlockState)p_57794_.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            p_57792_.m_46796_(2001, p_57793_, Block.m_49956_((BlockState)p_57794_));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Entity dinosaurEntity = ((EntityType)this.entityTypeSupplier.get()).m_20615_(world);
        ItemStack stack = player.m_21120_(hand);
        Item heldItem = stack.m_41720_();
        int i = (Integer)state.m_61143_((Property)EGGS);
        if (heldItem != this.m_5456_()) {
            if (i > 1) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            } else {
                world.m_46961_(pos, false);
            }
            if (dinosaurEntity instanceof DinosaurEntity) {
                DinosaurEntity dinosaur = (DinosaurEntity)dinosaurEntity;
                for (Entity parentEntity : world.m_45933_(dinosaurEntity, new AABB((double)(pos.m_123341_() - 4), (double)(pos.m_123342_() - 4), (double)(pos.m_123343_() - 4), (double)(pos.m_123341_() + 4), (double)(pos.m_123342_() + 4), (double)(pos.m_123343_() + 4)))) {
                    if (!(parentEntity instanceof DinosaurEntity)) continue;
                    DinosaurEntity parentDinosaur = (DinosaurEntity)parentEntity;
                    Entity parent = ((EntityType)this.entityTypeSupplier.get()).m_20615_(world);
                    if (!parentDinosaur.m_21204_().m_22171_(Attributes.f_22281_) || parentDinosaur.m_6162_() || parentDinosaur.trusts(player.m_20148_()) || parentDinosaur.m_21824_() || parentDinosaur != parent || player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)PFItems.EGG_HELMET.get())) continue;
                    parentDinosaur.m_6710_((LivingEntity)player);
                }
                ItemEntity item = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)dinosaur.getEggItem()));
                world.m_7967_((Entity)item);
            } else if (dinosaurEntity instanceof Triceratops) {
                Triceratops triceratops = (Triceratops)dinosaurEntity;
                for (Entity parentEntity : world.m_45933_((Entity)triceratops, new AABB((double)(pos.m_123341_() - 4), (double)(pos.m_123342_() - 4), (double)(pos.m_123343_() - 4), (double)(pos.m_123341_() + 4), (double)(pos.m_123342_() + 4), (double)(pos.m_123343_() + 4)))) {
                    if (!(parentEntity instanceof Triceratops)) continue;
                    Triceratops parentDinosaur = (Triceratops)parentEntity;
                    Entity parent = ((EntityType)this.entityTypeSupplier.get()).m_20615_(world);
                    if (!parentDinosaur.m_21204_().m_22171_(Attributes.f_22281_) || parentDinosaur.m_6162_() || parentDinosaur.trusts(player.m_20148_()) || parentDinosaur.m_30614_() || parentDinosaur != parent || player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)PFItems.EGG_HELMET.get())) continue;
                    parentDinosaur.m_6710_((LivingEntity)player);
                }
                ItemEntity item = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)PFItems.TRICERATOPS_EGG.get()));
                world.m_7967_((Entity)item);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (this.shouldUpdateHatchLevel((Level)worldIn, state, pos) && DinosaurEggBlock.onSand((BlockGetter)worldIn, pos)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                worldIn.m_5594_((Player)null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + rand.m_188501_() * 0.2f);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                worldIn.m_5594_((Player)null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + rand.m_188501_() * 0.2f);
                worldIn.m_7471_(pos, false);
                for (int j = 0; j < (Integer)state.m_61143_((Property)EGGS); ++j) {
                    Object dinosaur;
                    worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    Entity dinosaurEntity = ((EntityType)this.entityTypeSupplier.get()).m_20615_((Level)worldIn);
                    if (dinosaurEntity instanceof DinosaurEntity) {
                        dinosaur = (DinosaurEntity)dinosaurEntity;
                        for (Player player : dinosaur.m_9236_().m_45976_(Player.class, dinosaur.m_20191_().m_82377_(8.0, 8.0, 8.0))) {
                            ((DinosaurEntity)((Object)dinosaur)).addTrustedUUID(player.m_20148_());
                        }
                        if (dinosaur instanceof Camarasaurus) {
                            ((Animal)dinosaurEntity).m_146762_(-72000);
                        } else if (dinosaur instanceof Tyrannosaurus || dinosaur instanceof Edmontosaurus || dinosaur instanceof Dongbeititan) {
                            ((Animal)dinosaurEntity).m_146762_(-48000);
                        } else {
                            ((Animal)dinosaurEntity).m_146762_(-24000);
                        }
                    }
                    if (dinosaurEntity instanceof Triceratops) {
                        dinosaur = (Triceratops)dinosaurEntity;
                        for (Player player : dinosaur.m_9236_().m_45976_(Player.class, dinosaur.m_20191_().m_82377_(8.0, 8.0, 8.0))) {
                            ((Triceratops)((Object)dinosaur)).addTrustedUUID(player.m_20148_());
                        }
                        ((Animal)dinosaurEntity).m_146762_(-48000);
                    }
                    dinosaurEntity.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                    worldIn.m_7967_(dinosaurEntity);
                }
            }
        }
    }

    public static boolean onSand(BlockGetter blockReader, BlockPos pos) {
        return blockReader.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_49992_ || blockReader.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_49993_ || blockReader.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50546_ || blockReader.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50440_ || blockReader.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50493_ || blockReader.m_8055_(pos.m_7495_()).m_60734_() == PFBlocks.LOAM.get() || blockReader.m_8055_(pos.m_7495_()).m_60734_() == PFBlocks.PACKED_LOAM.get() || blockReader.m_8055_(pos.m_7495_()).m_60734_() == PFBlocks.SILT.get() || blockReader.m_8055_(pos.m_7495_()).m_60734_() == PFBlocks.HARDENED_SILT.get() || blockReader.m_8055_(pos.m_7495_()).m_60734_() == PFBlocks.MOSSY_DIRT.get() || blockReader.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50599_ || blockReader.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50195_ || blockReader.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13035_);
    }

    public void m_6807_(BlockState p_57814_, Level p_57815_, BlockPos p_57816_, BlockState p_57817_, boolean p_57818_) {
        if (DinosaurEggBlock.onSand((BlockGetter)p_57815_, p_57816_) && !p_57815_.f_46443_) {
            p_57815_.m_46796_(2005, p_57816_, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(Level world, BlockState state, BlockPos pos) {
        if (PrehistoricFaunaConfig.eggHeating) {
            long roundTime = world.m_46468_() % 24000L;
            boolean night = roundTime >= 13000L && roundTime <= 22000L;
            int i = world.m_45517_(LightLayer.SKY, pos);
            int j = world.m_45517_(LightLayer.BLOCK, pos);
            int hardshellDeathTime = 16000;
            int brightness = night ? j : Math.max(i, j);
            if (brightness < 7) {
                for (int l = hardshellDeathTime; l > 0; --l) {
                    if (l != 0) continue;
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
            } else {
                int l;
                boolean citipatified = (Boolean)state.m_61143_((Property)CITIPATIFIED);
                int regularTime = 24000;
                int citipatifiedTime = 12000;
                Random rand = new Random();
                for (l = regularTime + rand.nextInt(6000); l >= 0; --l) {
                    if (l != 0) continue;
                    return true;
                }
                if (citipatified) {
                    for (l = citipatifiedTime + rand.nextInt(6000); l >= 0; --l) {
                        if (l != 0) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void m_6240_(Level p_57771_, Player p_57772_, BlockPos p_57773_, BlockState p_57774_, @Nullable BlockEntity p_57775_, ItemStack p_57776_) {
        super.m_6240_(p_57771_, p_57772_, p_57773_, p_57774_, p_57775_, p_57776_);
        this.decreaseEggs(p_57771_, p_57773_, p_57774_);
    }

    public boolean m_6864_(BlockState p_57796_, BlockPlaceContext p_57797_) {
        return !p_57797_.m_7078_() && p_57797_.m_43722_().m_150930_(this.m_5456_()) && (Integer)p_57796_.m_61143_((Property)EGGS) < 4 ? true : super.m_6864_(p_57796_, p_57797_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_57761_) {
        BlockState blockstate = p_57761_.m_43725_().m_8055_(p_57761_.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(p_57761_);
    }

    public VoxelShape m_5940_(BlockState p_57809_, BlockGetter p_57810_, BlockPos p_57811_, CollisionContext p_57812_) {
        return (Integer)p_57809_.m_61143_((Property)EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57799_) {
        p_57799_.m_61104_(new Property[]{HATCH, EGGS, CITIPATIFIED});
    }

    private boolean canDestroyEgg(Level p_57768_, Entity trampler) {
        if (trampler.m_6095_() != this.entityTypeSupplier.get()) {
            if (!(trampler instanceof LivingEntity)) {
                return false;
            }
            return trampler instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)p_57768_, (Entity)trampler);
        }
        return false;
    }
}

