/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import superlord.prehistoricfauna.common.blocks.PortalFrameBlock;
import superlord.prehistoricfauna.common.teleporter.CretaceousTeleporter;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFDimensions;
import superlord.prehistoricfauna.init.PFParticles;
import superlord.prehistoricfauna.init.PFSounds;

public class CretaceousPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public CretaceousPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void updateNeighbors(Level worldIn, BlockPos pos) {
        worldIn.m_46672_(pos, (Block)this);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(AXIS) == Direction.Axis.Z ? Z_AABB : X_AABB;
    }

    public boolean tryToCreatePortal(Level world, BlockPos pos) {
        Size cretaceousPortalSize = this.isPortal((LevelAccessor)world, pos);
        if (cretaceousPortalSize != null && this.canCreatePortalByWorld(world, pos)) {
            cretaceousPortalSize.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(Level world, BlockPos pos) {
        if (world.m_46472_() == Level.f_46428_ || world.m_46472_() == PFDimensions.CRETACEOUS || world.m_46472_() == PFDimensions.TRIASSIC) {
            return true;
        }
        return world.m_46472_() == PFDimensions.CRETACEOUS;
    }

    @Nullable
    public Size isPortal(LevelAccessor world, BlockPos pos) {
        Size cretaceousPortalSizeX = new Size(world, pos, Direction.Axis.X);
        if (cretaceousPortalSizeX.isValid() && cretaceousPortalSizeX.portalBlockCount == 0) {
            return cretaceousPortalSizeX;
        }
        Size cretaceousPortalSizeZ = new Size(world, pos, Direction.Axis.Z);
        return cretaceousPortalSizeZ.isValid() && cretaceousPortalSizeZ.portalBlockCount == 0 ? cretaceousPortalSizeZ : null;
    }

    @Deprecated
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis directionAxis = facing.m_122434_();
        Direction.Axis directionAxis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = directionAxis1 != directionAxis && directionAxis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new Size(worldIn, currentPos, directionAxis1).canCreatePortal() ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Deprecated
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else {
                ResourceKey<Level> registryKey;
                ServerLevel serverWorld;
                MinecraftServer minecraftServer;
                ServerLevel serverWorld1;
                if (!entity.m_9236_().m_5776_() && !pos.equals((Object)entity.f_19819_)) {
                    entity.f_19819_ = pos.m_7949_();
                }
                if (entity.m_9236_() instanceof ServerLevel && (serverWorld1 = (minecraftServer = (serverWorld = (ServerLevel)entity.m_9236_()).m_7654_()).m_129880_(registryKey = entity.m_9236_().m_46472_() == PFDimensions.CRETACEOUS ? Level.f_46428_ : PFDimensions.CRETACEOUS)) != null && !entity.m_20159_()) {
                    entity.m_20091_();
                    entity.changeDimension(serverWorld1, (ITeleporter)new CretaceousTeleporter(serverWorld1));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (rand.m_188503_(100) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)PFSounds.PORTAL.get(), SoundSource.BLOCKS, 0.5f, rand.m_188501_() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 2; ++i) {
            double x = (float)pos.m_123341_() + rand.m_188501_();
            double y = (float)pos.m_123342_() + rand.m_188501_();
            double z = (float)pos.m_123343_() + rand.m_188501_();
            double sX = ((double)rand.m_188501_() - 0.5) * 0.5;
            double sY = ((double)rand.m_188501_() - 0.5) * 0.5;
            double sZ = ((double)rand.m_188501_() - 0.5) * 0.5;
            int mul = rand.m_188503_(2) * 2 - 1;
            if (world.m_8055_(pos.m_122024_()).m_60734_() != this && world.m_8055_(pos.m_122029_()).m_60734_() != this) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)mul;
                sX = rand.m_188501_() * 2.0f * (float)mul;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)mul;
                sZ = rand.m_188501_() * 2.0f * (float)mul;
            }
            world.m_7106_((ParticleOptions)PFParticles.PORTAL_PARTICLE.get(), x, y, z, sX, sY, sZ);
        }
    }

    @Deprecated
    public BlockState rotate(BlockState state, VariantProperties.Rotation rot) {
        return switch (rot) {
            case VariantProperties.Rotation.R270, VariantProperties.Rotation.R90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public static class Size {
        private final LevelAccessor world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private static final BlockBehaviour.StatePredicate FRAME_TEST = (state, reader, pos) -> state.m_60734_() == PFBlocks.PORTAL_FRAME.get();
        private final Block PORTAL = (Block)PFBlocks.CRETACEOUS_PORTAL.get();

        public Size(LevelAccessor world, BlockPos pos, Direction.Axis facing) {
            this.world = world;
            this.axis = facing;
            this.rightDir = facing == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.leftDir = facing == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
            this.bottomLeft = this.calculateBottomLeft(pos);
            if (this.bottomLeft == null) {
                this.bottomLeft = pos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculatePortalWidth();
                if (this.width > 0) {
                    this.height = this.calculatePortalHeight();
                }
            }
        }

        @Nullable
        private BlockPos calculateBottomLeft(BlockPos pos) {
            int i = Math.max(0, pos.m_123342_() - 21);
            while (pos.m_123342_() > i && this.isEmptyBlock(this.world.m_8055_(pos.m_7495_()))) {
                pos = pos.m_7495_();
            }
            Direction direction = this.rightDir.m_122424_();
            int j = this.getDistanceUntilEdge(pos, direction) - 1;
            return j < 0 ? null : pos.m_5484_(direction, j);
        }

        private int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 22; ++i) {
                mutable.m_122190_((Vec3i)pos).m_122175_(facing, i);
                BlockState state = this.world.m_8055_((BlockPos)mutable);
                if (!this.isEmptyBlock(state)) {
                    if (!FRAME_TEST.m_61035_(state, (BlockGetter)this.world, (BlockPos)mutable)) break;
                    return i;
                }
                BlockState state1 = this.world.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN));
                if (!FRAME_TEST.m_61035_(state1, (BlockGetter)this.world, (BlockPos)mutable)) break;
            }
            return 0;
        }

        private int calculatePortalWidth() {
            int dist = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            return dist >= 3 && dist <= 21 ? dist : 0;
        }

        private int calculatePortalHeight() {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int dist = this.getDistanceUntilTop(mutable);
            return dist >= 3 && dist <= 21 && this.hasTopFrame(mutable, dist) ? dist : 0;
        }

        private int getDistanceUntilTop(BlockPos.MutableBlockPos mutable) {
            for (int i = 0; i < 21; ++i) {
                mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
                if (!FRAME_TEST.m_61035_(this.world.m_8055_((BlockPos)mutable), (BlockGetter)this.world, (BlockPos)mutable)) {
                    return i;
                }
                mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
                if (!FRAME_TEST.m_61035_(this.world.m_8055_((BlockPos)mutable), (BlockGetter)this.world, (BlockPos)mutable)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                    BlockState blockstate = this.world.m_8055_((BlockPos)mutable);
                    if (!this.isEmptyBlock(blockstate)) {
                        return i;
                    }
                    if (blockstate.m_60734_() != this.PORTAL) continue;
                    ++this.portalBlockCount;
                }
            }
            return 21;
        }

        private boolean hasTopFrame(BlockPos.MutableBlockPos mutable, int offset) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.MutableBlockPos mutablePos = mutable.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, offset).m_122175_(this.rightDir, i);
                if (FRAME_TEST.m_61035_(this.world.m_8055_((BlockPos)mutablePos), (BlockGetter)this.world, (BlockPos)mutablePos)) continue;
                return false;
            }
            return true;
        }

        private boolean isEmptyBlock(BlockState state) {
            Block block = state.m_60734_();
            return state.m_60795_() || block == PFBlocks.CRETACEOUS_TIME_BLOCK.get() || block == this.PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 3 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            BlockState state = (BlockState)this.PORTAL.m_49966_().m_61124_(AXIS, (Comparable)this.axis);
            BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(pos -> this.world.m_7731_(pos, state, 18));
            BlockPos.m_121940_((BlockPos)this.bottomLeft.m_5484_(Direction.DOWN, this.height - (this.height - 1)).m_5484_(this.leftDir, this.width - (this.width - 1)), (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height).m_5484_(this.rightDir, this.width)).forEach(pos -> {
                if (this.world.m_8055_(pos).m_60713_((Block)PFBlocks.PORTAL_FRAME.get())) {
                    this.world.m_7731_(pos, (BlockState)((Block)PFBlocks.PORTAL_FRAME.get()).m_49966_().m_61124_((Property)PortalFrameBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)), 18);
                }
            });
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount == this.width * this.height;
        }
    }
}

