/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import superlord.prehistoricfauna.init.PFBlocks;

public class CrassostreaOysterBlock
extends BushBlock
implements BonemealableBlock,
LiquidBlockContainer {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public CrassostreaOysterBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60783_(worldIn, pos, Direction.UP) && (state.m_60734_() == Blocks.f_49992_ || state.m_60734_() == Blocks.f_49994_);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 2;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        float f;
        int i;
        super.m_213897_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / (f = CrassostreaOysterBlock.getGrowthChance((Block)this, (LevelReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, this.withAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8 ? super.m_5573_(context) : null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState blockstate = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!blockstate.m_60795_()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return blockstate;
    }

    public void grow(Level worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.m_7731_(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.m_216271_((RandomSource)worldIn.f_46441_, (int)1, (int)2);
    }

    protected static float getGrowthChance(Block blockIn, LevelReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    protected ItemLike getBaseSeedId() {
        return ((Block)PFBlocks.CRASSOSTREA_OYSTER.get()).m_5456_();
    }

    public ItemStack getItem(LevelReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean m_7370_(LevelReader p_52258_, BlockPos p_52259_, BlockState state, boolean p_52261_) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level p_52268_, RandomSource p_52269_, BlockPos p_52270_, BlockState p_52271_) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        this.grow((Level)worldIn, pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public FluidState m_5888_(BlockState state) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public boolean m_6044_(BlockGetter p_154505_, BlockPos p_154506_, BlockState p_154507_, Fluid p_154508_) {
        return false;
    }

    public boolean m_7361_(LevelAccessor p_154520_, BlockPos p_154521_, BlockState p_154522_, FluidState p_154523_) {
        return false;
    }
}

