/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import superlord.prehistoricfauna.init.PFBlocks;

public class CarvedTuberBlock
extends HorizontalDirectionalBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    @Nullable
    private BlockPattern snowGolemBase;
    @Nullable
    private BlockPattern snowGolemFull;
    @Nullable
    private BlockPattern ironGolemBase;
    @Nullable
    private BlockPattern ironGolemFull;
    private static final Predicate<BlockState> TUBER_PREDICATE = tuber -> tuber != null && (tuber.m_60713_((Block)PFBlocks.CARVED_TUBER.get()) || tuber.m_60713_((Block)PFBlocks.CARVED_TUBER_LIT.get()) || tuber.m_60713_((Block)PFBlocks.CARVED_TUBER_SOUL_LIT.get()) || tuber.m_60713_((Block)PFBlocks.CARVED_TUBER_TIME_LIT.get()));

    public CarvedTuberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState placeState, boolean p_51391_) {
        if (!placeState.m_60713_(state.m_60734_())) {
            this.trySpawnGolem(world, pos);
        }
    }

    public boolean canSpawnGolem(LevelReader world, BlockPos pos) {
        return this.getOrCreateSnowGolemBase().m_61184_(world, pos) != null || this.getOrCreateIronGolemBase().m_61184_(world, pos) != null;
    }

    private void trySpawnGolem(Level world, BlockPos pos) {
        block9: {
            BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch;
            block8: {
                blockpattern$blockpatternmatch = this.getOrCreateSnowGolemFull().m_61184_((LevelReader)world, pos);
                if (blockpattern$blockpatternmatch == null) break block8;
                for (int i = 0; i < this.getOrCreateSnowGolemFull().m_61202_(); ++i) {
                    BlockInWorld blockinworld = blockpattern$blockpatternmatch.m_61229_(0, i, 0);
                    world.m_7731_(blockinworld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    world.m_46796_(2001, blockinworld.m_61176_(), Block.m_49956_((BlockState)blockinworld.m_61168_()));
                }
                SnowGolem snowgolem = (SnowGolem)EntityType.f_20528_.m_20615_(world);
                BlockPos blockpos1 = blockpattern$blockpatternmatch.m_61229_(0, 2, 0).m_61176_();
                snowgolem.m_7678_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.05, (double)blockpos1.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)snowgolem);
                for (ServerPlayer serverplayer : world.m_45976_(ServerPlayer.class, snowgolem.m_20191_().m_82400_(5.0))) {
                    CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)snowgolem);
                }
                for (int l = 0; l < this.getOrCreateSnowGolemFull().m_61202_(); ++l) {
                    BlockInWorld blockinworld3 = blockpattern$blockpatternmatch.m_61229_(0, l, 0);
                    world.m_6289_(blockinworld3.m_61176_(), Blocks.f_50016_);
                }
                break block9;
            }
            blockpattern$blockpatternmatch = this.getOrCreateIronGolemFull().m_61184_((LevelReader)world, pos);
            if (blockpattern$blockpatternmatch == null) break block9;
            for (int j = 0; j < this.getOrCreateIronGolemFull().m_61203_(); ++j) {
                for (int k = 0; k < this.getOrCreateIronGolemFull().m_61202_(); ++k) {
                    BlockInWorld blockinworld2 = blockpattern$blockpatternmatch.m_61229_(j, k, 0);
                    world.m_7731_(blockinworld2.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    world.m_46796_(2001, blockinworld2.m_61176_(), Block.m_49956_((BlockState)blockinworld2.m_61168_()));
                }
            }
            BlockPos blockpos = blockpattern$blockpatternmatch.m_61229_(1, 2, 0).m_61176_();
            IronGolem irongolem = (IronGolem)EntityType.f_20460_.m_20615_(world);
            irongolem.m_28887_(true);
            irongolem.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
            world.m_7967_((Entity)irongolem);
            for (ServerPlayer serverplayer1 : world.m_45976_(ServerPlayer.class, irongolem.m_20191_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayer1, (Entity)irongolem);
            }
            for (int i1 = 0; i1 < this.getOrCreateIronGolemFull().m_61203_(); ++i1) {
                for (int j1 = 0; j1 < this.getOrCreateIronGolemFull().m_61202_(); ++j1) {
                    BlockInWorld blockinworld1 = blockpattern$blockpatternmatch.m_61229_(i1, j1, 0);
                    world.m_6289_(blockinworld1.m_61176_(), Blocks.f_50016_);
                }
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    private BlockPattern getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50127_))).m_61249_();
        }
        return this.snowGolemBase;
    }

    private BlockPattern getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#", "#"}).m_61244_('^', BlockInWorld.m_61169_(TUBER_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50127_))).m_61249_();
        }
        return this.snowGolemFull;
    }

    private BlockPattern getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "###", "~#~"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', p_284869_ -> p_284869_.m_61168_().m_60795_()).m_61249_();
        }
        return this.ironGolemBase;
    }

    private BlockPattern getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_(TUBER_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('~', p_284868_ -> p_284868_.m_61168_().m_60795_()).m_61249_();
        }
        return this.ironGolemFull;
    }
}

