/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.blocks;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import superlord.prehistoricfauna.common.entity.henos.Henos;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEntities;

public class AmmoniteLargeShellBlock
extends Block
implements LiquidBlockContainer {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE_FRONT_LARGE = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SIDE_LARGE = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    @Nullable
    private BlockPattern henosBase;
    @Nullable
    private BlockPattern henosFull;
    private static final Predicate<BlockState> SHELL_PREDICATE = tuber -> tuber != null && tuber.m_60713_((Block)PFBlocks.LARGE_AMMONITE_FOSSIL.get());

    public AmmoniteLargeShellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch (AmmoniteLargeShellBlock.getDirection(state)) {
            default: {
                return SHAPE_FRONT_LARGE;
            }
            case WEST: {
                return SHAPE_SIDE_LARGE;
            }
            case SOUTH: {
                return SHAPE_FRONT_LARGE;
            }
            case EAST: 
        }
        return SHAPE_SIDE_LARGE;
    }

    public static Direction getDirection(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_192917_((Fluid)Fluids.f_76193_)));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState placeState, boolean p_51391_) {
        if (!placeState.m_60713_(state.m_60734_())) {
            this.trySpawnHenos(world, pos);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public boolean m_6044_(BlockGetter p_54766_, BlockPos p_54767_, BlockState p_54768_, Fluid p_54769_) {
        return false;
    }

    public boolean m_7361_(LevelAccessor p_54770_, BlockPos p_54771_, BlockState p_54772_, FluidState p_54773_) {
        return false;
    }

    public boolean canSpawnHenos(LevelReader world, BlockPos pos) {
        return this.getOrCreateHenosBase().m_61184_(world, pos) != null;
    }

    private void trySpawnHenos(Level world, BlockPos pos) {
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = this.getOrCreateHenosFull().m_61184_((LevelReader)world, pos);
        if (blockpattern$blockpatternmatch != null && blockpattern$blockpatternmatch != null) {
            for (int j = 0; j < this.getOrCreateHenosFull().m_61203_(); ++j) {
                for (int k = 0; k < this.getOrCreateHenosFull().m_61202_(); ++k) {
                    BlockInWorld blockinworld2 = blockpattern$blockpatternmatch.m_61229_(j, k, 0);
                    world.m_7731_(blockinworld2.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    world.m_46796_(2001, blockinworld2.m_61176_(), Block.m_49956_((BlockState)blockinworld2.m_61168_()));
                }
            }
            BlockPos blockpos = blockpattern$blockpatternmatch.m_61229_(1, 2, 0).m_61176_();
            Henos henos = (Henos)((EntityType)PFEntities.HENOS.get()).m_20615_(world);
            henos.setSummoned(true);
            henos.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
            world.m_7967_((Entity)henos);
            for (ServerPlayer serverplayer1 : world.m_45976_(ServerPlayer.class, henos.m_20191_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayer1, (Entity)henos);
            }
            for (int i1 = 0; i1 < this.getOrCreateHenosFull().m_61203_(); ++i1) {
                for (int j1 = 0; j1 < this.getOrCreateHenosFull().m_61202_(); ++j1) {
                    BlockInWorld blockinworld1 = blockpattern$blockpatternmatch.m_61229_(i1, j1, 0);
                    world.m_6289_(blockinworld1.m_61176_(), Blocks.f_50016_);
                }
            }
        }
    }

    private BlockPattern getOrCreateHenosBase() {
        if (this.henosBase == null) {
            this.henosBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "#X#", "~#~"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)PFBlocks.HENOSTONE.get())))).m_61244_('~', p_284869_ -> p_284869_.m_61168_().m_60795_()).m_61244_('X', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)PFBlocks.TIME_FRAGMENT_BLOCK.get())))).m_61249_();
        }
        return this.henosBase;
    }

    private BlockPattern getOrCreateHenosFull() {
        if (this.henosFull == null) {
            this.henosFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "#X#", "~#~"}).m_61244_('^', BlockInWorld.m_61169_(SHELL_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)PFBlocks.HENOSTONE.get())))).m_61244_('X', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)PFBlocks.TIME_FRAGMENT_BLOCK.get())))).m_61244_('~', p_284868_ -> p_284868_.m_61168_().m_60795_()).m_61249_();
        }
        return this.henosFull;
    }
}

