/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.client.render.jurassic.morrison;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import superlord.prehistoricfauna.client.ClientEvents;
import superlord.prehistoricfauna.client.model.jurassic.morrison.AllosaurusBabyModel;
import superlord.prehistoricfauna.client.model.jurassic.morrison.AllosaurusModel;
import superlord.prehistoricfauna.client.render.layer.AllosaurusBabyEyeLayer;
import superlord.prehistoricfauna.client.render.layer.AllosaurusEyeLayer;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Allosaurus;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;

public class AllosaurusRenderer
extends MobRenderer<Allosaurus, EntityModel<Allosaurus>> {
    private static final ResourceLocation ALLOSAURUS_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/allosaurus.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/albino.png");
    private static final ResourceLocation MELANISTIC = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/melanistic.png");
    private static final ResourceLocation ALLOSAURUS_SLEEPING_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/allosaurus_sleeping.png");
    private static final ResourceLocation ALBINO_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/albino_sleeping.png");
    private static final ResourceLocation MELANISTIC_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/melanistic_sleeping.png");
    private static final ResourceLocation ALLOSAURUS_BABY_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/allosaurus_baby.png");
    private static final ResourceLocation ALBINO_BABY = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/albino_baby.png");
    private static final ResourceLocation MELANISTIC_BABY = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/melanistic_baby.png");
    private static final ResourceLocation ALLOSAURUS_BABY_SLEEPING_TEXTURE = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/allosaurus_baby_sleeping.png");
    private static final ResourceLocation ALBINO_BABY_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/albino_baby_sleeping.png");
    private static final ResourceLocation MELANISTIC_BABY_SLEEPING = new ResourceLocation("prehistoricfauna", "textures/entities/allosaurus/melanistic_baby_sleeping.png");
    private static AllosaurusModel ALLOSAURUS_MODEL;
    private static AllosaurusBabyModel BABY_ALLOSAURUS_MODEL;

    public AllosaurusRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new AllosaurusModel(renderManagerIn.m_174023_(ClientEvents.ALLOSAURUS)), 1.25f);
        ALLOSAURUS_MODEL = new AllosaurusModel(renderManagerIn.m_174023_(ClientEvents.ALLOSAURUS));
        BABY_ALLOSAURUS_MODEL = new AllosaurusBabyModel(renderManagerIn.m_174023_(ClientEvents.ALLOSAURUS_BABY));
        if (PrehistoricFaunaConfig.eyeShine) {
            this.m_115326_(new AllosaurusBabyEyeLayer((RenderLayerParent<Allosaurus, EntityModel<Allosaurus>>)this));
            this.m_115326_(new AllosaurusEyeLayer((RenderLayerParent<Allosaurus, EntityModel<Allosaurus>>)this));
        }
    }

    protected void scale(Allosaurus thescelosaurus, PoseStack matrixStackIn, float partialTickTime) {
        this.f_115290_ = thescelosaurus.m_6162_() ? BABY_ALLOSAURUS_MODEL : ALLOSAURUS_MODEL;
        super.m_7546_((LivingEntity)thescelosaurus, matrixStackIn, partialTickTime);
    }

    public ResourceLocation getTextureLocation(Allosaurus entity) {
        if (entity.m_6162_()) {
            if (entity.isAlbino()) {
                if (entity.isAsleep() || entity.f_19797_ % 50 >= 0 && entity.f_19797_ % 50 <= 5) {
                    return ALBINO_BABY_SLEEPING;
                }
                return ALBINO_BABY;
            }
            if (entity.isMelanistic()) {
                if (entity.isAsleep() || entity.f_19797_ % 50 >= 0 && entity.f_19797_ % 50 <= 5) {
                    return MELANISTIC_BABY_SLEEPING;
                }
                return MELANISTIC_BABY;
            }
            if (entity.isAsleep() || entity.f_19797_ % 50 >= 0 && entity.f_19797_ % 50 <= 5) {
                return ALLOSAURUS_BABY_SLEEPING_TEXTURE;
            }
            return ALLOSAURUS_BABY_TEXTURE;
        }
        if (entity.isAlbino()) {
            if (entity.isAsleep() || entity.f_19797_ % 50 >= 0 && entity.f_19797_ % 50 <= 5) {
                return ALBINO_SLEEPING;
            }
            return ALBINO;
        }
        if (entity.isMelanistic()) {
            if (entity.isAsleep() || entity.f_19797_ % 50 >= 0 && entity.f_19797_ % 50 <= 5) {
                return MELANISTIC_SLEEPING;
            }
            return MELANISTIC;
        }
        if (entity.isAsleep() || entity.f_19797_ % 50 >= 0 && entity.f_19797_ % 50 <= 5) {
            return ALLOSAURUS_SLEEPING_TEXTURE;
        }
        return ALLOSAURUS_TEXTURE;
    }
}

